/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.Oritech;
import rearth.oritech.util.InventoryInputMode;

public interface ScreenProvider {
    default public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        return List.of();
    }

    public List<GuiSlot> getGuiSlots();

    default public boolean showEnergy() {
        return true;
    }

    public float getDisplayedEnergyUsage();

    default public float getDisplayedEnergyTransfer() {
        return this.getDisplayedEnergyUsage() * 10.0f;
    }

    public float getProgress();

    public InventoryInputMode getInventoryInputMode();

    public Container getDisplayedInventory();

    public MenuType<?> getScreenHandlerType();

    default public boolean inputOptionsEnabled() {
        return true;
    }

    default public Property<Direction> getBlockFacingProperty() {
        return BlockStateProperties.HORIZONTAL_FACING;
    }

    default public boolean showProgress() {
        return true;
    }

    default public boolean showArmor() {
        return false;
    }

    default public boolean showExpansionPanel() {
        return true;
    }

    default public boolean hasRedstoneControlAvailable() {
        return false;
    }

    default public int receivedRedstoneSignal() {
        return 0;
    }

    default public String currentRedstoneEffect() {
        return "";
    }

    default public BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 24, 15, 54);
    }

    default public BarConfiguration getFluidConfiguration() {
        return new BarConfiguration(147, 6, 21, 74);
    }

    default public ArrowConfiguration getIndicatorConfiguration() {
        return new ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 80, 35, 29, 16, true);
    }

    public record BarConfiguration(int x, int y, int width, int height) {
    }

    public record ArrowConfiguration(ResourceLocation empty, ResourceLocation full, int x, int y, int width, int height, boolean horizontal) {
    }

    public record GuiSlot(int index, int x, int y, boolean output) {
        public GuiSlot(int index, int x, int y) {
            this(index, x, y, false);
        }
    }
}

