/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortalEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int age = 0;
    public Vec3 target;
    protected static final RawAnimation PORTAL = RawAnimation.begin().thenPlay("create").thenLoop("idle");

    public PortalEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void playerTouch(Player player) {
        if (this.target != null) {
            player.randomTeleport(this.target.x, this.target.y, this.target.z, true);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void tick() {
        Level world = this.level();
        if (world.isClientSide) {
            return;
        }
        ++this.age;
        if (this.age > 100) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(PORTAL)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

