/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import rearth.oritech.block.entity.storage.SmallFluidTankEntity;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.init.LootContent;

public class NbtBlockLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "nbt_block_loot";
    public static final MapCodec<NbtBlockLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootItemConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, NbtBlockLootFunction::new));

    public NbtBlockLootFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        SmallStorageBlockEntity storageEntity;
        BlockEntity blockEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        CompoundTag nbt = new CompoundTag();
        if (blockEntity instanceof SmallFluidTankEntity) {
            SmallFluidTankEntity tankEntity = (SmallFluidTankEntity)blockEntity;
            if (tankEntity.getForDirectFluidAccess().amount > 0L) {
                tankEntity.saveAdditional(nbt, (HolderLookup.Provider)context.getLevel().registryAccess());
                Component fluidName = FluidVariantAttributes.getName((FluidVariant)((FluidVariant)tankEntity.getForDirectFluidAccess().variant));
                stack.set(DataComponents.CUSTOM_NAME, (Object)fluidName.copy().append(" ").append((Component)Component.translatable((String)"block.oritech.small_tank_block")));
                nbt.putUUID("unstackable", UUID.randomUUID());
            }
        } else if (blockEntity instanceof SmallStorageBlockEntity && (storageEntity = (SmallStorageBlockEntity)blockEntity).getStorage(null).getAmount() > 0L) {
            storageEntity.saveAdditional(nbt, (HolderLookup.Provider)context.getLevel().registryAccess());
            nbt.putUUID("unstackable", UUID.randomUUID());
        }
        if (nbt.contains("Items")) {
            nbt.remove("Items");
        }
        if (!nbt.isEmpty()) {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return stack;
    }

    public LootItemFunctionType<NbtBlockLootFunction> getType() {
        return LootContent.NBT_BLOCK_LOOT_FUNCTION;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(NbtBlockLootFunction::new);
    }
}

