/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class DelegatingFluidStorage
implements Storage<FluidVariant> {
    protected final Supplier<Storage<FluidVariant>> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingFluidStorage(Supplier<Storage<FluidVariant>> backingStorage, BooleanSupplier validPredicate) {
        this.backingStorage = backingStorage;
        this.validPredicate = validPredicate;
    }

    public boolean supportsInsertion() {
        if (this.validPredicate.getAsBoolean() && this.backingStorage.get() != null) {
            return this.backingStorage.get().supportsInsertion();
        }
        return false;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.validPredicate.getAsBoolean() && this.backingStorage.get() != null) {
            return this.backingStorage.get().insert((Object)resource, maxAmount, transaction);
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        if (this.validPredicate.getAsBoolean() && this.backingStorage.get() != null) {
            return this.backingStorage.get().supportsExtraction();
        }
        return false;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.validPredicate.getAsBoolean() && this.backingStorage.get() != null) {
            return this.backingStorage.get().extract((Object)resource, maxAmount, transaction);
        }
        return 0L;
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        if (this.validPredicate.getAsBoolean() && this.backingStorage.get() != null) {
            return this.backingStorage.get().iterator();
        }
        return Collections.emptyIterator();
    }
}

