/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;

public class AutoPlayingSoundKeyframeHandler<A extends GeoAnimatable>
implements AnimationController.SoundKeyframeHandler<A> {
    private final Supplier<Float> speedSupplier;
    private final Map<ResourceLocation, Long> lastPlayedAt = new HashMap<ResourceLocation, Long>();

    public AutoPlayingSoundKeyframeHandler(Supplier<Float> speedSupplier) {
        this.speedSupplier = speedSupplier;
    }

    public AutoPlayingSoundKeyframeHandler() {
        this.speedSupplier = AutoPlayingSoundKeyframeHandler::getDefaultSpeed;
    }

    private static float getDefaultSpeed() {
        return 1.0f;
    }

    public void handle(SoundKeyframeEvent<A> event) {
        String[] segments = event.getKeyframeData().getSound().split("\\|");
        SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)segments[0]));
        if (sound != null) {
            long time = Minecraft.getInstance().player.clientLevel.getGameTime();
            long age = time - this.lastPlayedAt.getOrDefault(sound.getLocation(), 0L);
            if (age < 30L) {
                return;
            }
            BlockEntity entity = (BlockEntity)event.getAnimatable();
            Vec3 pos = entity.getBlockPos().getCenter();
            double distance = Math.sqrt(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().distanceToSqr(pos));
            double volumeFalloff = Math.min(1.0, 1.0 / (distance / 4.0));
            if (distance > 25.0) {
                return;
            }
            Float speed = this.speedSupplier.get();
            speed = Float.valueOf(Math.min(Math.max(speed.floatValue(), 0.125f), 8.0f));
            float volume = segments.length > 1 ? Float.parseFloat(segments[1]) : 1.0f;
            float pitch = segments.length > 2 ? Float.parseFloat(segments[2]) : 1.0f;
            SoundSource source = SoundSource.BLOCKS;
            Minecraft.getInstance().player.clientLevel.playLocalSound(entity.getBlockPos(), sound, source, volume *= (float)((double)(Oritech.CONFIG.machineVolumeMultiplier() * this.getPitchRandomMultiplier(entity.getLevel().random)) * volumeFalloff * 0.5), pitch *= speed.floatValue() * this.getPitchRandomMultiplier(entity.getLevel().random), true);
            this.lastPlayedAt.put(sound.getLocation(), time);
        }
    }

    private float getPitchRandomMultiplier(RandomSource random) {
        return random.nextFloat() * 0.15f + 1.0f;
    }
}

