/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.network;

import dev.architectury.fluid.FluidStack;
import io.wispforest.owo.network.OwoNetChannel;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.BlackHoleBlockEntity;
import rearth.oritech.block.entity.accelerator.ParticleCollectorBlockEntity;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;
import rearth.oritech.block.entity.arcane.EnchantmentCatalystBlockEntity;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.interaction.PumpBlockEntity;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.item.tools.armor.BaseJetpackItem;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;

public class NetworkContent {
    public static final OwoNetChannel MACHINE_CHANNEL = OwoNetChannel.create((ResourceLocation)Oritech.id("machine_data"));
    public static final OwoNetChannel UI_CHANNEL = OwoNetChannel.create((ResourceLocation)Oritech.id("ui_interactions"));

    public static void registerChannels() {
        Oritech.LOGGER.debug("Registering oritech channels");
        MACHINE_CHANNEL.builder().register(ItemFilterBlockEntity.FILTER_ITEMS_ENDEC, Map.class);
        MACHINE_CHANNEL.builder().register(OritechRecipeType.ORI_RECIPE_ENDEC, OritechRecipe.class);
        MACHINE_CHANNEL.registerClientbound(MachineSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)entity;
                machine.handleNetworkEntry((MachineSyncPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(MachineSetupEventPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController machine = (MultiblockMachineController)entity;
                System.out.println("playing setup on client!");
                machine.playSetupAnimation();
            }
        });
        MACHINE_CHANNEL.registerClientbound(EnchanterSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof EnchanterBlockEntity) {
                EnchanterBlockEntity machine = (EnchanterBlockEntity)entity;
                machine.handleSyncPacket((EnchanterSyncPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(ItemFilterSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof ItemFilterBlockEntity) {
                ItemFilterBlockEntity filter = (ItemFilterBlockEntity)entity;
                filter.setFilterSettings(message.data);
            }
        });
        MACHINE_CHANNEL.registerClientbound(LaserArmSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof LaserArmBlockEntity) {
                LaserArmBlockEntity laserArmBlock = (LaserArmBlockEntity)entity;
                laserArmBlock.setCurrentTarget(message.target);
                laserArmBlock.setLastFiredAt(message.lastFiredAt);
                laserArmBlock.areaSize = message.areaSize;
                laserArmBlock.yieldAddons = message.yieldAddons;
                laserArmBlock.hunterAddons = message.hunterAddons;
                laserArmBlock.hasCropFilterAddon = message.cropAddon;
                laserArmBlock.setLivingTargetFromNetwork(message.targetEntityId);
                laserArmBlock.hunterTargetMode = LaserArmBlockEntity.HunterTargetMode.fromValue(message.hunterTargetMode);
                laserArmBlock.setRedstonePowered(message.redstonePowered);
            }
        });
        MACHINE_CHANNEL.registerClientbound(DeepDrillSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof DeepDrillEntity) {
                DeepDrillEntity drillBlock = (DeepDrillEntity)entity;
                drillBlock.setLastWorkTime(message.lastWorkTime);
            }
        });
        MACHINE_CHANNEL.registerClientbound(CatalystSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof EnchantmentCatalystBlockEntity) {
                EnchantmentCatalystBlockEntity catalystBlock = (EnchantmentCatalystBlockEntity)entity;
                catalystBlock.handleNetworkPacket((CatalystSyncPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(GenericEnergySyncPacket.class, (message, access) -> {
            EnergyApi.BlockProvider energyProvider;
            EnergyApi.EnergyContainer patt1$temp;
            EnergyApi.BlockProvider energyProvider2;
            EnergyApi.EnergyContainer patt0$temp;
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof EnergyApi.BlockProvider && (patt0$temp = (energyProvider2 = (EnergyApi.BlockProvider)entity).getStorage(null)) instanceof DynamicEnergyStorage) {
                DynamicEnergyStorage storage = (DynamicEnergyStorage)patt0$temp;
                storage.capacity = message.maxEnergy;
                storage.amount = message.currentEnergy;
            } else if (entity instanceof EnergyApi.BlockProvider && (patt1$temp = (energyProvider = (EnergyApi.BlockProvider)entity).getStorage(null)) instanceof SimpleEnergyStorage) {
                SimpleEnergyStorage storage = (SimpleEnergyStorage)patt1$temp;
                storage.setAmount(message.currentEnergy);
            }
        });
        MACHINE_CHANNEL.registerClientbound(FullEnergySyncPacket.class, (message, access) -> {
            EnergyApi.BlockProvider energyProvider;
            EnergyApi.EnergyContainer patt0$temp;
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof EnergyApi.BlockProvider && (patt0$temp = (energyProvider = (EnergyApi.BlockProvider)entity).getStorage(null)) instanceof DynamicEnergyStorage) {
                DynamicEnergyStorage storage = (DynamicEnergyStorage)patt0$temp;
                storage.capacity = message.maxEnergy;
                storage.amount = message.currentEnergy;
                storage.maxExtract = message.maxExtract;
                storage.maxInsert = message.maxInsert;
            }
        });
        MACHINE_CHANNEL.registerClientbound(DroneSendEventPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof DronePortEntity) {
                DronePortEntity dronePort = (DronePortEntity)entity;
                if (message.sendEvent) {
                    dronePort.playSendAnimation();
                }
                if (message.receiveEvent) {
                    dronePort.playReceiveAnimation();
                }
            }
        });
        MACHINE_CHANNEL.registerClientbound(DroneCardEventPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof DronePortEntity) {
                DronePortEntity dronePort = (DronePortEntity)entity;
                dronePort.setStatusMessage(message.message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(SingleVariantFluidSyncPacket.class, (message, access) -> {
            FluidProvider fluidProvider;
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof FluidProvider && (fluidProvider = (FluidProvider)entity).getForDirectFluidAccess() != null) {
                SingleVariantStorage<FluidVariant> storage = fluidProvider.getForDirectFluidAccess();
                storage.amount = message.amount;
                storage.variant = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidType))));
            }
        });
        MACHINE_CHANNEL.registerClientbound(SpawnerSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof SpawnerControllerBlockEntity) {
                SpawnerControllerBlockEntity spawnerEntity = (SpawnerControllerBlockEntity)entity;
                spawnerEntity.loadEntityFromIdentifier(message.spawnedMob);
                spawnerEntity.hasCage = message.hasCage;
                spawnerEntity.collectedSouls = message.collectedSouls;
                spawnerEntity.maxSouls = message.maxSouls;
            }
        });
        MACHINE_CHANNEL.registerClientbound(GeneratorSteamSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof UpgradableGeneratorBlockEntity) {
                UpgradableGeneratorBlockEntity generatorBlock = (UpgradableGeneratorBlockEntity)entity;
                generatorBlock.steamStorage.amount = message.steamAmount;
                generatorBlock.waterStorage.amount = message.waterAmount;
            }
        });
        MACHINE_CHANNEL.registerClientbound(AcceleratorParticleRenderPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof AcceleratorControllerBlockEntity) {
                AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)entity;
                acceleratorBlock.onReceiveMovement(message.particleTrail);
            }
        });
        MACHINE_CHANNEL.registerClientbound(AcceleratorControllerBlockEntity.LastEventPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position());
            if (entity instanceof AcceleratorControllerBlockEntity) {
                AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)entity;
                acceleratorBlock.onReceivedEvent((AcceleratorControllerBlockEntity.LastEventPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(AcceleratorParticleInsertEventPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position());
            if (entity instanceof AcceleratorControllerBlockEntity) {
                AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)entity;
                acceleratorBlock.onParticleInsertedClient();
            }
        });
        MACHINE_CHANNEL.registerClientbound(PumpWorkSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof PumpBlockEntity) {
                PumpBlockEntity pump = (PumpBlockEntity)entity;
                FluidVariant variant = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidType))));
                pump.setLastPumpedVariant(variant);
                pump.setLastPumpTime(message.workedAt);
            }
        });
        MACHINE_CHANNEL.registerClientbound(CentrifugeFluidSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof CentrifugeBlockEntity) {
                CentrifugeBlockEntity centrifuge = (CentrifugeBlockEntity)entity;
                centrifuge.hasFluidAddon = message.fluidAddon;
                SingleVariantStorage<FluidVariant> inStorage = centrifuge.inputStorage;
                SingleVariantStorage<FluidVariant> outStorage = centrifuge.outputStorage;
                inStorage.amount = message.amountIn;
                outStorage.amount = message.amountOut;
                inStorage.variant = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidTypeIn))));
                outStorage.variant = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidTypeOut))));
            }
        });
        MACHINE_CHANNEL.registerClientbound(DronePortFluidSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof DronePortEntity) {
                DronePortEntity dronePort = (DronePortEntity)entity;
                dronePort.hasFluidAddon = message.fluidAddon;
                dronePort.fluidStorage.amount = message.amount;
                dronePort.fluidStorage.variant = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidType))));
            }
        });
        MACHINE_CHANNEL.registerClientbound(GeneratorUISyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof UpgradableGeneratorBlockEntity) {
                UpgradableGeneratorBlockEntity generatorBlock = (UpgradableGeneratorBlockEntity)entity;
                generatorBlock.setCurrentMaxBurnTime(message.burnTime);
                generatorBlock.isProducingSteam = message.steamAddon;
            }
        });
        MACHINE_CHANNEL.registerClientbound(BlackHoleSuckPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof BlackHoleBlockEntity) {
                BlackHoleBlockEntity hole = (BlackHoleBlockEntity)entity;
                hole.onClientPullEvent((BlackHoleSuckPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(MachineFrameMovementPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof FrameInteractionBlockEntity) {
                FrameInteractionBlockEntity machine = (FrameInteractionBlockEntity)entity;
                machine.setCurrentTarget(message.currentTarget);
                machine.setLastTarget(message.lastTarget);
                machine.setMoveStartedAt(access.player().level().getGameTime());
                machine.setAreaMin(message.areaMin);
                machine.setAreaMax(message.areaMax);
                machine.disabledViaRedstone = message.redstoneDisable();
            }
        });
        MACHINE_CHANNEL.registerClientbound(QuarryTargetPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof DestroyerBlockEntity) {
                DestroyerBlockEntity machine = (DestroyerBlockEntity)entity;
                machine.quarryTarget = message.quarryTarget;
                machine.range = message.range;
                machine.yieldAddons = message.yieldAddons;
                MachineAddonController.BaseAddonData oldData = machine.getBaseAddonData();
                MachineAddonController.BaseAddonData newData = new MachineAddonController.BaseAddonData(message.operationSpeed, oldData.efficiency(), oldData.energyBonusCapacity(), oldData.energyBonusTransfer(), oldData.extraChambers());
                machine.setBaseAddonData(newData);
            }
        });
        MACHINE_CHANNEL.registerClientbound(ParticleAcceleratorAnimationPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof ParticleCollectorBlockEntity) {
                ParticleCollectorBlockEntity machine = (ParticleCollectorBlockEntity)entity;
                machine.playAnimation();
            }
        });
        MACHINE_CHANNEL.registerClientbound(SteamEnginePacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof SteamEngineEntity) {
                SteamEngineEntity machine = (SteamEngineEntity)entity;
                MachineAddonController.BaseAddonData oldData = machine.getBaseAddonData();
                MachineAddonController.BaseAddonData newData = new MachineAddonController.BaseAddonData(message.speed, message.efficiency, oldData.energyBonusCapacity(), oldData.energyBonusTransfer(), oldData.extraChambers());
                machine.setBaseAddonData(newData);
                machine.waterStorage.amount = message.waterStored;
                machine.energyProducedTick = message.energyProducedTick;
            }
        });
        MACHINE_CHANNEL.registerClientbound(InventorySyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof ScreenProvider) {
                ScreenProvider machine = (ScreenProvider)entity;
                List<ItemStack> heldStacks = message.heldStacks;
                for (int i = 0; i < heldStacks.size(); ++i) {
                    ItemStack stack = heldStacks.get(i);
                    machine.getDisplayedInventory().setItem(i, stack);
                }
            }
        });
        MACHINE_CHANNEL.registerClientbound(MachineFrameGuiPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof ItemEnergyFrameInteractionBlockEntity) {
                ItemEnergyFrameInteractionBlockEntity machine = (ItemEnergyFrameInteractionBlockEntity)entity;
                machine.setCurrentProgress(message.progress);
                DynamicEnergyStorage energyStorage = machine.getEnergyStorage();
                energyStorage.amount = message.currentEnergy;
                energyStorage.capacity = message.maxEnergy;
            }
        });
        MACHINE_CHANNEL.registerClientbound(RedstoneAddonSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().clientLevel.getBlockEntity(message.position);
            if (entity instanceof RedstoneAddonBlockEntity) {
                RedstoneAddonBlockEntity machine = (RedstoneAddonBlockEntity)entity;
                machine.handleClientBound((RedstoneAddonSyncPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(EnchanterSelectionPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof EnchanterBlockEntity) {
                EnchanterBlockEntity enchanter = (EnchanterBlockEntity)entity;
                enchanter.handleEnchantmentSelection((EnchanterSelectionPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(AugmentDataPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof AugmentApplicationEntity) {
                AugmentApplicationEntity enhancer = (AugmentApplicationEntity)entity;
                enhancer.handleAugmentUpdatePacket((AugmentDataPacket)message);
            }
        });
        MACHINE_CHANNEL.registerClientbound(AugmentOperationSyncPacket.class, (message, access) -> {
            if (access != null) {
                PlayerAugments.handlePlayerAugmentOperation(message, access);
            }
        });
        MACHINE_CHANNEL.registerClientbound(ReactorUIDataPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof ReactorControllerBlockEntity) {
                ReactorControllerBlockEntity reactor = (ReactorControllerBlockEntity)entity;
                reactor.uiData = message;
            }
        });
        MACHINE_CHANNEL.registerClientbound(ReactorUISyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof ReactorControllerBlockEntity) {
                ReactorControllerBlockEntity reactor = (ReactorControllerBlockEntity)entity;
                reactor.uiSyncData = message;
                reactor.energyStorage.setAmount(message.energy);
            }
        });
        MACHINE_CHANNEL.registerClientbound(ReactorPortDataPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof ReactorFuelPortEntity) {
                ReactorFuelPortEntity port = (ReactorFuelPortEntity)entity;
                port.currentFuelOriginalCapacity = message.capacity;
                port.availableFuel = message.remaining;
            } else if (entity instanceof ReactorAbsorberPortEntity) {
                ReactorAbsorberPortEntity port = (ReactorAbsorberPortEntity)entity;
                port.currentFuelOriginalCapacity = message.capacity;
                port.availableFuel = message.remaining;
            }
        });
        UI_CHANNEL.registerServerbound(RedstoneAddonSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof RedstoneAddonBlockEntity) {
                RedstoneAddonBlockEntity machine = (RedstoneAddonBlockEntity)entity;
                machine.handleServerBound((RedstoneAddonSyncPacket)message);
            }
        });
        UI_CHANNEL.registerServerbound(InventoryInputModeSelectorPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)entity;
                machine.cycleInputMode();
            }
        });
        UI_CHANNEL.registerServerbound(InventoryProxySlotSelectorPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof InventoryProxyAddonBlockEntity) {
                InventoryProxyAddonBlockEntity machine = (InventoryProxyAddonBlockEntity)entity;
                machine.setTargetSlot(message.slot);
            }
        });
        UI_CHANNEL.registerServerbound(ItemFilterSyncPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof ItemFilterBlockEntity) {
                ItemFilterBlockEntity filter = (ItemFilterBlockEntity)entity;
                filter.setFilterSettings(message.data);
            }
        });
        UI_CHANNEL.registerServerbound(EnchanterSelectionPacket.class, (message, access) -> {
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof EnchanterBlockEntity) {
                EnchanterBlockEntity enchanter = (EnchanterBlockEntity)entity;
                enchanter.handleEnchantmentSelection((EnchanterSelectionPacket)message);
            }
        });
        UI_CHANNEL.registerServerbound(JetpackUsageUpdatePacket.class, (message, access) -> {
            ServerPlayer player = access.player();
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (!(stack.getItem() instanceof BaseJetpackItem)) {
                return;
            }
            player.connection.aboveGroundTickCount = 0;
            stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)message.energyStored);
            if (message.fluidAmount > 0L) {
                stack.set(ComponentContent.STORED_FLUID.get(), (Object)FluidStack.create((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)message.fluidType))), (long)message.fluidAmount));
            }
        });
        UI_CHANNEL.registerServerbound(AugmentInstallTriggerPacket.class, (message, access) -> {
            ServerPlayer player = access.player();
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof AugmentApplicationEntity) {
                AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
                PlayerAugments.AugmentOperation operation = PlayerAugments.AugmentOperation.values()[message.operationId];
                switch (operation) {
                    case RESEARCH: {
                        modifierEntity.researchAugment(message.id, player.isCreative(), (Player)player);
                        break;
                    }
                    case ADD: {
                        modifierEntity.installAugmentToPlayer(message.id, (Player)player);
                        break;
                    }
                    case REMOVE: {
                        modifierEntity.removeAugmentFromPlayer(message.id, (Player)player);
                    }
                }
            }
        });
        UI_CHANNEL.registerServerbound(LoadPlayerAugmentsToMachinePacket.class, (message, access) -> {
            ServerPlayer player = access.player();
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof AugmentApplicationEntity) {
                AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
                modifierEntity.loadResearchesFromPlayer((Player)player);
            }
        });
        UI_CHANNEL.registerServerbound(OpenAugmentScreenPacket.class, (message, access) -> {
            ServerPlayer player = access.player();
            BlockEntity entity = access.player().level().getBlockEntity(message.position);
            if (entity instanceof AugmentApplicationEntity) {
                AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
                modifierEntity.screenInvOverride = true;
                player.openMenu((MenuProvider)modifierEntity);
            }
        });
        UI_CHANNEL.registerServerbound(AugmentPlayerTogglePacket.class, (message, access) -> {
            ServerPlayer player = access.player();
            AugmentApplicationEntity.toggleAugmentForPlayer(message.id, (Player)player);
        });
    }

    public record MachineSyncPacket(BlockPos position, long energy, long maxEnergy, long maxInsert, long maxExtract, int progress, OritechRecipe activeRecipe, InventoryInputMode inputMode, long lastWorkedAt, boolean disabledViaRedstone) {
    }

    public record MachineSetupEventPacket(BlockPos position) {
    }

    public record EnchanterSyncPacket(BlockPos position, long energy, int progress, int maxProgress, int requiredCatalysts, int availableCatalysts) {
    }

    public record ItemFilterSyncPacket(BlockPos position, ItemFilterBlockEntity.FilterData data) {
    }

    public record LaserArmSyncPacket(BlockPos position, BlockPos target, long lastFiredAt, int areaSize, int yieldAddons, int hunterAddons, int hunterTargetMode, boolean cropAddon, int targetEntityId, boolean redstonePowered) {
    }

    public record DeepDrillSyncPacket(BlockPos position, long lastWorkTime) {
    }

    public record CatalystSyncPacket(BlockPos position, int storedSouls, int progress, boolean isHyperEnchanting, int maxSouls) {
    }

    public record GenericEnergySyncPacket(BlockPos position, long currentEnergy, long maxEnergy) {
    }

    public record FullEnergySyncPacket(BlockPos position, long currentEnergy, long maxEnergy, long maxInsert, long maxExtract) {
    }

    public record DroneSendEventPacket(BlockPos position, boolean sendEvent, boolean receiveEvent) {
    }

    public record DroneCardEventPacket(BlockPos position, String message) {
    }

    public record SingleVariantFluidSyncPacket(BlockPos position, String fluidType, long amount) {
    }

    public record SpawnerSyncPacket(BlockPos position, ResourceLocation spawnedMob, boolean hasCage, int collectedSouls, int maxSouls) {
    }

    public record GeneratorSteamSyncPacket(BlockPos position, long steamAmount, long waterAmount) {
    }

    public record AcceleratorParticleRenderPacket(BlockPos position, List<Vec3> particleTrail) {
    }

    public record AcceleratorParticleInsertEventPacket(BlockPos position) {
    }

    public record PumpWorkSyncPacket(BlockPos position, String fluidType, long workedAt) {
    }

    public record CentrifugeFluidSyncPacket(BlockPos position, boolean fluidAddon, String fluidTypeIn, long amountIn, String fluidTypeOut, long amountOut) {
    }

    public record DronePortFluidSyncPacket(BlockPos position, boolean fluidAddon, String fluidType, long amount) {
    }

    public record GeneratorUISyncPacket(BlockPos position, int burnTime, boolean steamAddon) {
    }

    public record BlackHoleSuckPacket(BlockPos position, BlockPos from, long startedAt, long duration) {
    }

    public record MachineFrameMovementPacket(BlockPos position, BlockPos currentTarget, BlockPos lastTarget, BlockPos areaMin, BlockPos areaMax, boolean redstoneDisable) {
    }

    public record QuarryTargetPacket(BlockPos position, BlockPos quarryTarget, int range, int yieldAddons, float operationSpeed) {
    }

    public record ParticleAcceleratorAnimationPacket(BlockPos position) {
    }

    public record SteamEnginePacket(BlockPos position, float speed, float efficiency, long waterStored, int energyProducedTick) {
    }

    public record InventorySyncPacket(BlockPos position, List<ItemStack> heldStacks) {
    }

    public record MachineFrameGuiPacket(BlockPos position, long currentEnergy, long maxEnergy, int progress) {
    }

    public record RedstoneAddonSyncPacket(BlockPos position, BlockPos controllerPos, int targetSlot, int targetMode, int currentOutput) {
    }

    public record EnchanterSelectionPacket(BlockPos position, String enchantment) {
    }

    public record AugmentDataPacket(BlockPos position, List<ResourceLocation> allResearched, List<ResourceLocation> researchBlocks, List<Boolean> researchStates, List<ResourceLocation> activeResearches, List<Long> startedTimes, List<Integer> researchTimes) {
    }

    public record AugmentOperationSyncPacket(ResourceLocation id, int operation) {
    }

    public record ReactorUIDataPacket(BlockPos position, BlockPos min, BlockPos max, BlockPos previewMax) {
    }

    public record ReactorUISyncPacket(BlockPos position, List<BlockPos> componentPositions, List<ReactorControllerBlockEntity.ComponentStatistics> componentHeats, long energy) {
    }

    public record ReactorPortDataPacket(BlockPos position, int capacity, int remaining) {
    }

    public record InventoryInputModeSelectorPacket(BlockPos position) {
    }

    public record InventoryProxySlotSelectorPacket(BlockPos position, int slot) {
    }

    public record JetpackUsageUpdatePacket(long energyStored, String fluidType, long fluidAmount) {
    }

    public record AugmentInstallTriggerPacket(BlockPos position, ResourceLocation id, int operationId) {
    }

    public record LoadPlayerAugmentsToMachinePacket(BlockPos position) {
    }

    public record OpenAugmentScreenPacket(BlockPos position) {
    }

    public record AugmentPlayerTogglePacket(ResourceLocation id) {
    }

    public record GenericRedstoneSyncPacket(BlockPos position, boolean isPowered) {
    }
}

