/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.energy.BlockEnergyApi;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.ItemEnergyApi;

public class NeoforgeEnergyApiImpl
implements BlockEnergyApi,
ItemEnergyApi {
    private final List<Supplier<BlockEntityType<?>>> registeredBlockEntities = new ArrayList();
    private final List<Supplier<Item>> registeredItems = new ArrayList<Supplier<Item>>();

    @Override
    public void registerBlockEntity(Supplier<BlockEntityType<?>> typeSupplier) {
        this.registeredBlockEntities.add(typeSupplier);
    }

    @Override
    public void registerForItem(Supplier<Item> itemSupplier) {
        this.registeredItems.add(itemSupplier);
    }

    @Override
    public DataComponentType<Long> getEnergyComponent() {
        return ComponentContent.NEO_ENERGY_COMPONENT.get();
    }

    public void registerEvent(RegisterCapabilitiesEvent event) {
        for (Supplier<BlockEntityType<?>> supplier : this.registeredBlockEntities) {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, supplier.get(), (entity, direction) -> ContainerStorageWrapper.of(((EnergyApi.BlockProvider)entity).getStorage((Direction)direction)));
        }
        for (Supplier<BlockEntityType<?>> supplier : this.registeredItems) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ignored) -> ContainerStorageWrapper.of(((EnergyApi.ItemProvider)stack.getItem()).getStorage((ItemStack)stack)), new ItemLike[]{(ItemLike)supplier.get()});
        }
    }

    @Override
    public EnergyApi.EnergyContainer find(ItemStack stack, ContainerItemContext context) {
        IEnergyStorage candidate = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        return new NeoforgeStorageWrapper(candidate);
    }

    @Override
    public EnergyApi.EnergyContainer find(Level world, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        IEnergyStorage candidate = (IEnergyStorage)world.getCapability(Capabilities.EnergyStorage.BLOCK, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        return new NeoforgeStorageWrapper(candidate);
    }

    @Override
    public EnergyApi.EnergyContainer find(Level world, BlockPos pos, @Nullable Direction direction) {
        return this.find(world, pos, null, null, direction);
    }

    public static class ContainerStorageWrapper
    implements IEnergyStorage {
        public final EnergyApi.EnergyContainer container;

        public static ContainerStorageWrapper of(EnergyApi.EnergyContainer container) {
            if (container == null) {
                return null;
            }
            return new ContainerStorageWrapper(container);
        }

        public ContainerStorageWrapper(EnergyApi.EnergyContainer container) {
            this.container = container;
        }

        public int receiveEnergy(int i, boolean bl) {
            long inserted = this.container.insert(i, bl);
            if (!bl) {
                this.container.update();
            }
            return (int)inserted;
        }

        public int extractEnergy(int i, boolean bl) {
            long extracted = this.container.extract(i, bl);
            if (!bl) {
                this.container.update();
            }
            return (int)extracted;
        }

        public int getEnergyStored() {
            return (int)this.container.getAmount();
        }

        public int getMaxEnergyStored() {
            return (int)this.container.getCapacity();
        }

        public boolean canExtract() {
            return this.container.supportsExtraction();
        }

        public boolean canReceive() {
            return this.container.supportsInsertion();
        }
    }

    public static class NeoforgeStorageWrapper
    extends EnergyApi.EnergyContainer {
        public final IEnergyStorage storage;

        public NeoforgeStorageWrapper(IEnergyStorage storage) {
            this.storage = storage;
        }

        @Override
        public long insert(long maxAmount, boolean simulate) {
            return this.storage.receiveEnergy((int)maxAmount, simulate);
        }

        @Override
        public long extract(long maxAmount, boolean simulate) {
            return this.storage.extractEnergy((int)maxAmount, simulate);
        }

        @Override
        public long getAmount() {
            return this.storage.getEnergyStored();
        }

        @Override
        public long getCapacity() {
            return this.storage.getMaxEnergyStored();
        }

        @Override
        public void setAmount(long amount) {
        }

        @Override
        public void update() {
        }
    }
}

