/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.util;

import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyItemStorage;

public interface OritechEnergyItem
extends EnergyApi.ItemProvider,
FabricItem {
    default public long getEnergyCapacity(ItemStack stack) {
        return 10000L;
    }

    default public long getEnergyMaxInput(ItemStack stack) {
        return 500L;
    }

    default public long getEnergyMaxOutput(ItemStack stack) {
        return 0L;
    }

    default public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    default public boolean tryUseEnergy(ItemStack stack, long amount, Player player) {
        EnergyApi.EnergyContainer storage;
        RandomSource random = RandomSource.create();
        int unbreakingLevel = this.getUnbreakingLevel(stack);
        if (unbreakingLevel > 0) {
            amount /= (long)(random.nextInt(unbreakingLevel) + 1);
        }
        if ((storage = this.getStorage(stack)) instanceof SimpleEnergyItemStorage) {
            SimpleEnergyItemStorage itemStorage = (SimpleEnergyItemStorage)storage;
            long extracted = itemStorage.extractIgnoringLimit(amount, false);
            if (extracted > 0L) {
                itemStorage.update();
            }
            return extracted == amount;
        }
        return false;
    }

    private int getUnbreakingLevel(ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Holder entry : enchantments.keySet()) {
            if (!entry.unwrapKey().isPresent() || !((ResourceKey)entry.unwrapKey().get()).equals(Enchantments.UNBREAKING)) continue;
            return enchantments.getLevel(entry);
        }
        return 0;
    }

    default public long getStoredEnergy(ItemStack stack) {
        return this.getStorage(stack).getAmount();
    }

    @Override
    default public EnergyApi.EnergyContainer getStorage(ItemStack stack) {
        return new SimpleEnergyItemStorage(this.getEnergyMaxInput(stack), this.getEnergyMaxOutput(stack), this.getEnergyCapacity(stack), stack);
    }
}

