/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.item.tools.util.OritechEnergyItem;

public class DrillItem
extends DiggerItem
implements OritechEnergyItem {
    public static final int BAR_STEP_COUNT = 13;
    private final float energyUsageMultiplier;

    public DrillItem(Tier toolMaterial, TagKey<Block> effectiveBlocks, Item.Properties settings) {
        super(toolMaterial, effectiveBlocks, settings);
        this.energyUsageMultiplier = Oritech.CONFIG.basicDrill.energyUsage();
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!(miner instanceof Player)) {
            return true;
        }
        Player player = (Player)miner;
        float amount = state.getBlock().defaultDestroyTime() * this.energyUsageMultiplier;
        amount = Math.min(amount, (float)this.getStoredEnergy(stack));
        return this.tryUseEnergy(stack, (long)amount, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{this.getStoredEnergy(stack), this.getEnergyCapacity(stack)});
        tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        boolean enoughEnergy = (float)this.getStoredEnergy(stack) >= state.getBlock().defaultDestroyTime() * this.energyUsageMultiplier;
        float multiplier = enoughEnergy ? 1.0f : 0.1f;
        return super.getDestroySpeed(stack, state) * multiplier;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.basicDrill.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.basicDrill.chargeSpeed();
    }
}

