/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import java.util.Deque;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.item.tools.harvesting.PromethiumAxeItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;

public class ChainsawItem
extends AxeItem
implements OritechEnergyItem {
    public static final int BAR_STEP_COUNT = 13;
    private final float energyUsageMultiplier;

    public ChainsawItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
        this.energyUsageMultiplier = Oritech.CONFIG.chainSaw.energyUsage();
        Tool toolComponent = new Tool(List.of(Tool.Rule.deniesDrops((TagKey)toolMaterial.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_AXE, (float)toolMaterial.getSpeed()), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f), Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f)), 1.0f, 1);
        this.components = settings.component(DataComponents.TOOL, (Object)toolComponent).buildAndValidateComponents();
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        BlockPos startPos;
        BlockState startState;
        if (!(miner instanceof Player)) {
            return true;
        }
        Player player = (Player)miner;
        float amount = state.getBlock().defaultDestroyTime() * this.energyUsageMultiplier;
        amount = Math.min(amount, (float)this.getStoredEnergy(stack));
        boolean energySuccess = this.tryUseEnergy(stack, (long)amount, player);
        if (!world.isClientSide && miner.isShiftKeyDown() && energySuccess && Oritech.CONFIG.chainsawTreeCutting() && (startState = world.getBlockState(startPos = pos.above())).is(BlockTags.LOGS)) {
            Deque<BlockPos> treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
            PromethiumAxeItem.pendingBlocks.addAll(treeBlocks.stream().map(elem -> new Tuple((Object)world, elem)).toList());
            float extraEnergyUsed = (float)treeBlocks.size() * this.energyUsageMultiplier / 2.0f;
            this.tryUseEnergy(stack, (long)extraEnergyUsed, player);
        }
        return energySuccess;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{this.getStoredEnergy(stack), this.getEnergyCapacity(stack)});
        tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        if (Oritech.CONFIG.chainsawTreeCutting()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.promethium_axe").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        boolean enoughEnergy = (float)this.getStoredEnergy(stack) >= state.getBlock().defaultDestroyTime() * this.energyUsageMultiplier;
        float multiplier = enoughEnergy ? 1.0f : 0.1f;
        return super.getDestroySpeed(stack, state) * multiplier;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.chainSaw.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.chainSaw.chargeSpeed();
    }
}

