/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.SoundContent;

public class Wrench
extends Item {
    public static int ACTION_COOLDOWN = 8;

    public Wrench(Item.Properties settings) {
        super(settings);
    }

    public static Tool createToolComponent() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(BlockContent.ENERGY_PIPE, BlockContent.SUPERCONDUCTOR, BlockContent.FLUID_PIPE, BlockContent.ITEM_PIPE, BlockContent.ENERGY_PIPE_CONNECTION, BlockContent.SUPERCONDUCTOR_CONNECTION, BlockContent.FLUID_PIPE_CONNECTION, BlockContent.ITEM_PIPE_CONNECTION, BlockContent.ENERGY_PIPE_DUCT_BLOCK, BlockContent.SUPERCONDUCTOR_DUCT_BLOCK, BlockContent.FLUID_PIPE_DUCT_BLOCK, BlockContent.ITEM_PIPE_DUCT_BLOCK, BlockContent.FRAMED_ENERGY_PIPE, BlockContent.FRAMED_SUPERCONDUCTOR, BlockContent.FRAMED_FLUID_PIPE, BlockContent.FRAMED_ITEM_PIPE, BlockContent.FRAMED_ENERGY_PIPE_CONNECTION, BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION, BlockContent.FRAMED_FLUID_PIPE_CONNECTION, BlockContent.FRAMED_ITEM_PIPE_CONNECTION, BlockContent.MACHINE_FRAME_BLOCK), (float)25.0f)), 1.0f, 1);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        return this.useWrench(stack, user, hand) ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.fail((Object)stack);
    }

    protected boolean useWrench(ItemStack item, Player player, InteractionHand hand) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        player.getCooldowns().addCooldown((Item)this, ACTION_COOLDOWN);
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        Level world = player.level();
        BlockHitResult result = Wrench.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos blockPos = result.getBlockPos();
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof Wrenchable) {
            Wrenchable wrenchable = (Wrenchable)block;
            InteractionResult resultAction = wrenchable.onWrenchUse(blockState, world, blockPos, player, hand);
            if (resultAction == InteractionResult.SUCCESS) {
                this.onUsed(item, player, hand);
                return true;
            }
        } else {
            Wrenchable wrenchable;
            InteractionResult resultAction;
            Direction direction = result.getDirection();
            BlockPos neighborPos = blockPos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            Block block2 = neighborState.getBlock();
            if (block2 instanceof Wrenchable && (resultAction = (wrenchable = (Wrenchable)block2).onWrenchUseNeighbor(neighborState, blockState, world, neighborPos, blockPos, direction, player, hand)) == InteractionResult.SUCCESS) {
                this.onUsed(item, player, hand);
                return true;
            }
        }
        return false;
    }

    protected void onUsed(ItemStack item, Player player, InteractionHand hand) {
        this.playSound(player.level(), player);
        item.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    protected void playSound(Level world, Player player) {
        world.playSound(null, player.blockPosition(), SoundContent.WRENCH_TURN, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static interface Wrenchable {
        public InteractionResult onWrenchUse(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5);

        public InteractionResult onWrenchUseNeighbor(BlockState var1, BlockState var2, Level var3, BlockPos var4, BlockPos var5, Direction var6, Player var7, InteractionHand var8);
    }
}

