/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.client.init.ParticleContent;

public class WeedKiller
extends Item {
    public WeedKiller(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return super.useOn(context);
        }
        BlockPos startPos = context.getClickedPos();
        new Thread(() -> this.doWeedKilling(context.getLevel(), startPos)).start();
        context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }

    private void doWeedKilling(Level world, BlockPos startPos) {
        int maxRange = 20;
        int spreadRange = 3;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> open = new ArrayDeque<BlockPos>();
        open.add(startPos);
        while (!open.isEmpty()) {
            BlockPos candidate = (BlockPos)open.pop();
            for (int x = -spreadRange; x <= spreadRange; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -spreadRange; z <= spreadRange; ++z) {
                        BlockPos target = new BlockPos((Vec3i)candidate.offset(x, y, z));
                        if (visited.contains(target)) continue;
                        int distance = target.distManhattan((Vec3i)startPos);
                        if (this.isWeedBlock(target, world) && distance < maxRange) {
                            open.add(target);
                            world.setBlockAndUpdate(target, Blocks.AIR.defaultBlockState());
                            ParticleContent.WEED_KILLER.spawn(world, target.getCenter(), (Object)new ParticleContent.LineData(candidate.getCenter(), target.getCenter()));
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        visited.add(target);
                    }
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.weed_killer").withStyle(ChatFormatting.GRAY));
    }

    private boolean isWeedBlock(BlockPos pos, Level world) {
        BlockState state = world.getBlockState(pos);
        if (state.isAir() || state.liquid()) {
            return false;
        }
        return state.canBeReplaced() || state.is(BlockTags.FLOWERS);
    }
}

