/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class SmallFluidTankBlockItem
extends BlockItem {
    public SmallFluidTankBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return;
        }
        CompoundTag nbt = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (nbt.isEmpty() || !nbt.contains("variant") || !nbt.contains("amount")) {
            return;
        }
        Fluid variant = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getCompound("variant").getString("fluid")));
        long amount = nbt.getLong("amount") * 1000L / 81000L;
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{amount, amount <= 0L ? Component.translatable((String)"tooltip.oritech.fluid_empty") : FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((Fluid)variant)).getString()}));
    }
}

