/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.rei.Screens;

import io.wispforest.owo.compat.rei.ReiUIAdapter;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.compat.rei.OritechDisplay;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechReiDisplay
implements DisplayCategory<Display> {
    protected final OritechRecipeType recipeType;
    private final Boolean isGenerator;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    protected final ItemLike icon;

    public OritechReiDisplay(OritechRecipeType recipeType, Class<? extends MachineBlockEntity> screenProviderSource, ItemLike icon) {
        BlockState blockState = Blocks.STONE.defaultBlockState();
        if (icon instanceof Block) {
            Block blockItem = (Block)icon;
            blockState = blockItem.defaultBlockState();
        }
        BlockState finalBlockState = blockState;
        this.recipeType = recipeType;
        try {
            MachineBlockEntity screenProvider = screenProviderSource.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(new BlockPos(0, 0, 0), finalBlockState);
            this.isGenerator = screenProvider instanceof UpgradableGeneratorBlockEntity;
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlots();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.icon = icon;
    }

    public OritechReiDisplay(OritechRecipeType recipeType, ItemLike icon, boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        this.recipeType = recipeType;
        this.icon = icon;
        this.isGenerator = isGenerator;
        this.slots = slots;
        this.slotOffsets = assignments;
    }

    public List<Widget> setupDisplay(Display display, Rectangle bounds) {
        ReiUIAdapter adapter = new ReiUIAdapter(bounds, Containers::verticalFlow);
        FlowLayout root = (FlowLayout)adapter.rootComponent();
        root.horizontalAlignment(HorizontalAlignment.CENTER).surface(Surface.PANEL).padding(Insets.of((int)4));
        this.fillDisplay(root, (OritechDisplay)display, (ReiUIAdapter<FlowLayout>)adapter);
        adapter.prepare();
        return List.of(adapter);
    }

    public void fillDisplay(FlowLayout root, OritechDisplay display, ReiUIAdapter<FlowLayout> adapter) {
        TextureComponent foreGround;
        MutableComponent text;
        Fluid fluid;
        int offsetX = 23;
        int offsetY = 17;
        List<EntryIngredient> inputEntries = display.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient entry = inputEntries.get(i);
            if (entry.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)entry).markInput()).positioning(Positioning.absolute((int)(pos.x() - offsetX), (int)(pos.y() - offsetY))));
        }
        if (this.isGenerator.booleanValue()) {
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createBurningFire((Point)new Point(0, 0))).positioning(Positioning.absolute((int)(77 - offsetX), (int)(42 - offsetY))));
        } else {
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createArrow((Point)new Point(0, 0))).positioning(Positioning.absolute((int)(80 - offsetX), (int)(39 - offsetY))));
        }
        List<EntryIngredient> outputEntries = display.getOutputEntries();
        for (int i = 0; i < outputEntries.size(); ++i) {
            EntryIngredient entry = outputEntries.get(i);
            if (entry.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createSlot((Point)new Point(0, 0)).entry((EntryStack)entry.get(0)).markOutput()).positioning(Positioning.absolute((int)(pos.x() - offsetX), (int)(pos.y() - offsetY))));
        }
        String duration = String.format("%.0f", Float.valueOf((float)((OritechRecipe)display.getEntry().value()).getTime() / 20.0f));
        root.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"rei.title.oritech.cookingtime", (Object[])new Object[]{duration, ((OritechRecipe)display.getEntry().value()).getTime()})).lineHeight(7).positioning(Positioning.relative((int)35, (int)97)));
        if (((OritechRecipe)display.entry.value()).getFluidInput() != null && ((OritechRecipe)display.entry.value()).getFluidInput().getAmount() > 0L) {
            fluid = ((OritechRecipe)display.entry.value()).getFluidInput().getFluid();
            long amount = ((OritechRecipe)display.entry.value()).getFluidInput().getAmount();
            root.child((Component)BasicMachineScreen.createFluidRenderer(FluidVariant.of((Fluid)fluid), 81000L, new ScreenProvider.BarConfiguration(4, 5, 16, 50)));
            text = amount > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{amount * 1000L / 81000L, FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((Fluid)fluid)).getString()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
            foreGround = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
            foreGround.sizing(Sizing.fixed((int)18), Sizing.fixed((int)52));
            foreGround.positioning(Positioning.absolute((int)3, (int)4));
            foreGround.tooltip((net.minecraft.network.chat.Component)text);
            root.child((Component)foreGround);
        }
        if (((OritechRecipe)display.entry.value()).getFluidOutput() != null && ((OritechRecipe)display.entry.value()).getFluidOutput().getAmount() > 0L) {
            fluid = ((OritechRecipe)display.entry.value()).getFluidOutput().getFluid();
            long amount = ((OritechRecipe)display.entry.value()).getFluidOutput().getAmount();
            root.child((Component)BasicMachineScreen.createFluidRenderer(FluidVariant.of((Fluid)fluid), 81000L, new ScreenProvider.BarConfiguration(123, 5, 16, 50)));
            text = amount > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{amount * 1000L / 81000L, FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((Fluid)fluid)).getString()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
            foreGround = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
            foreGround.sizing(Sizing.fixed((int)18), Sizing.fixed((int)52));
            foreGround.positioning(Positioning.absolute((int)122, (int)4));
            foreGround.tooltip((net.minecraft.network.chat.Component)text);
            root.child((Component)foreGround);
        }
    }

    public CategoryIdentifier<? extends Display> getCategoryIdentifier() {
        return CategoryIdentifier.of((ResourceLocation)this.recipeType.getIdentifier());
    }

    public net.minecraft.network.chat.Component getTitle() {
        return net.minecraft.network.chat.Component.translatable((String)("rei.process." + String.valueOf(this.recipeType.getIdentifier())));
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)this.icon);
    }
}

