/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.jei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechRecipeCategory
implements IRecipeCategory<OritechRecipe> {
    public final OritechRecipeType type;
    private final Boolean isGenerator;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    public final IDrawable icon;
    public final IDrawableAnimated arrow;
    public final IDrawableStatic background;
    public final IDrawableStatic fluidBackground;

    public OritechRecipeCategory(OritechRecipeType type, Class<? extends MachineBlockEntity> screenProviderSource, Block machine, IGuiHelper helper) {
        this.type = type;
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)machine.asItem()));
        try {
            MachineBlockEntity screenProvider = screenProviderSource.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(new BlockPos(0, 0, 0), machine.defaultBlockState());
            this.isGenerator = screenProvider instanceof UpgradableGeneratorBlockEntity;
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlots();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
        this.fluidBackground = helper.drawableBuilder(BasicMachineScreen.GUI_COMPONENTS, 48, 0, 14, 50).setTextureSize(98, 96).build();
    }

    public OritechRecipeCategory(OritechRecipeType type, Block machine, IGuiHelper helper, Boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment slotOffsets) {
        this.type = type;
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)machine.asItem()));
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
        this.fluidBackground = helper.drawableBuilder(BasicMachineScreen.GUI_COMPONENTS, 48, 0, 14, 50).setTextureSize(98, 96).build();
        this.isGenerator = isGenerator;
        this.slots = slots;
        this.slotOffsets = slotOffsets;
    }

    @NotNull
    public RecipeType<OritechRecipe> getRecipeType() {
        return RecipeType.create((String)this.type.getIdentifier().getNamespace(), (String)this.type.getIdentifier().getPath(), OritechRecipe.class);
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)("emi.category.oritech." + this.type.getIdentifier().getPath()));
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 66;
    }

    public void draw(OritechRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 57, 24);
        String duration = String.format("%.0f", Float.valueOf((float)recipe.getTime() / 20.0f));
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"emi.title.oritech.cookingtime", (Object[])new Object[]{duration, recipe.getTime()}), (int)((double)this.getWidth() * 0.35), (int)((double)this.getHeight() * 0.88), 0xFFFFFF);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OritechRecipe recipe, IFocusGroup focuses) {
        int offsetX = 23;
        int offsetY = 17;
        int fluidDivider = Platform.isNeoForge() ? 81 : 1;
        List<Ingredient> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Ingredient input = inputs.get(i);
            if (input.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            ((IRecipeSlotBuilder)builder.addInputSlot(pos.x() - offsetX, pos.y() - offsetY).addIngredients(input)).setBackground((IDrawable)this.background, -1, -1);
        }
        if (recipe.getFluidInput() == null || !recipe.getFluidInput().isEmpty()) {
            FluidStack stack = recipe.getFluidInput();
            long shownAmount = Math.max(1L, stack.getAmount() / (long)fluidDivider);
            builder.addInputSlot(10, 6).addFluidStack(stack.getFluid(), shownAmount).setBackground((IDrawable)this.fluidBackground, -2, -2).setFluidRenderer(shownAmount, false, 10, 46);
        }
        List<ItemStack> outputs = recipe.getResults();
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i);
            if (output.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            ((IRecipeSlotBuilder)builder.addOutputSlot(pos.x() - offsetX, pos.y() - offsetY).addItemStack(output)).setBackground((IDrawable)this.background, -1, -1);
        }
        if (recipe.getFluidOutput() == null || !recipe.getFluidOutput().isEmpty()) {
            FluidStack stack = recipe.getFluidOutput();
            builder.addInputSlot(120, 6).addFluidStack(stack.getFluid(), stack.getAmount() / (long)fluidDivider).setBackground((IDrawable)this.fluidBackground, -2, -2).setFluidRenderer(stack.getAmount() / 81L, false, 10, 46);
        }
    }
}

