/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.generators.BioGeneratorEntity;
import rearth.oritech.block.entity.generators.FuelGeneratorEntity;
import rearth.oritech.block.entity.generators.LavaGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.AssemblerBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.processing.CoolerBlockEntity;
import rearth.oritech.block.entity.processing.FoundryBlockEntity;
import rearth.oritech.block.entity.processing.FragmentForgeBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.compat.emi.EmiTransferHandler;
import rearth.oritech.init.compat.emi.OritechEMIParticleCollisionRecipe;
import rearth.oritech.init.compat.emi.OritechEMIRecipe;
import rearth.oritech.init.compat.emi.OritechEmiLaserRecipe;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

@EmiEntrypoint
public class OritechEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        RecipeManager manager = registry.getRecipeManager();
        this.registerOritechCategory(registry, manager, RecipeContent.PULVERIZER, (ItemLike)BlockContent.PULVERIZER_BLOCK, PulverizerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.GRINDER, (ItemLike)BlockContent.FRAGMENT_FORGE_BLOCK, FragmentForgeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.ASSEMBLER, (ItemLike)BlockContent.ASSEMBLER_BLOCK, AssemblerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.FOUNDRY, (ItemLike)BlockContent.FOUNDRY_BLOCK, FoundryBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.COOLER, (ItemLike)BlockContent.COOLER_BLOCK, CoolerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.CENTRIFUGE, (ItemLike)BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.CENTRIFUGE_FLUID, (ItemLike)BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.ATOMIC_FORGE, (ItemLike)BlockContent.ATOMIC_FORGE_BLOCK, AtomicForgeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.BIO_GENERATOR, (ItemLike)BlockContent.BIO_GENERATOR_BLOCK, BioGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.FUEL_GENERATOR, (ItemLike)BlockContent.FUEL_GENERATOR_BLOCK, FuelGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.LAVA_GENERATOR, (ItemLike)BlockContent.LAVA_GENERATOR_BLOCK, LavaGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.STEAM_ENGINE, (ItemLike)BlockContent.STEAM_ENGINE_BLOCK, SteamEngineEntity.class);
        this.registerCustom(registry, manager, RecipeContent.REACTOR, (ItemLike)BlockContent.REACTOR_CONTROLLER, List.of(new ScreenProvider.GuiSlot(0, 55, 35)), new InventorySlotAssignment(0, 1, 1, 0));
        this.registerParticleAccelerator(registry, manager, RecipeContent.PARTICLE_COLLISION);
        this.registerLaser(registry, manager, RecipeContent.LASER);
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((ItemLike)BlockContent.POWERED_FURNACE_BLOCK));
        registry.addRecipeHandler(ModScreens.ASSEMBLER_SCREEN, new EmiTransferHandler(RecipeContent.ASSEMBLER.getIdentifier()));
        registry.addRecipeHandler(ModScreens.FOUNDRY_SCREEN, new EmiTransferHandler(RecipeContent.FOUNDRY.getIdentifier()));
        registry.addRecipeHandler(ModScreens.ATOMIC_FORGE_SCREEN, new EmiTransferHandler(RecipeContent.ATOMIC_FORGE.getIdentifier()));
    }

    private void registerOritechCategory(EmiRegistry registry, RecipeManager manager, OritechRecipeType recipeType, ItemLike machine, Class<? extends MachineBlockEntity> screenProviderSource) {
        EmiStack icon = EmiStack.of((ItemLike)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        BlockState blockState = Blocks.STONE.defaultBlockState();
        if (machine instanceof Block) {
            Block blockItem = (Block)machine;
            blockState = blockItem.defaultBlockState();
        }
        BlockState finalBlockState = blockState;
        manager.getAllRecipesFor((RecipeType)recipeType).stream().map(entry -> new OritechEMIRecipe((RecipeHolder<OritechRecipe>)entry, category, screenProviderSource, finalBlockState)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerCustom(EmiRegistry registry, RecipeManager manager, OritechRecipeType recipeType, ItemLike machine, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        EmiStack icon = EmiStack.of((ItemLike)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.getAllRecipesFor((RecipeType)recipeType).stream().map(entry -> new OritechEMIRecipe((RecipeHolder<OritechRecipe>)entry, category, true, slots, assignments)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerParticleAccelerator(EmiRegistry registry, RecipeManager manager, OritechRecipeType recipeType) {
        Block machine = BlockContent.ACCELERATOR_CONTROLLER;
        EmiStack icon = EmiStack.of((ItemLike)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.getAllRecipesFor((RecipeType)recipeType).stream().map(entry -> new OritechEMIParticleCollisionRecipe((RecipeHolder<OritechRecipe>)entry, category)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerLaser(EmiRegistry registry, RecipeManager manager, OritechRecipeType recipeType) {
        Block machine = BlockContent.LASER_ARM_BLOCK;
        EmiStack icon = EmiStack.of((ItemLike)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.getAllRecipesFor((RecipeType)recipeType).stream().map(entry -> new OritechEmiLaserRecipe((RecipeHolder<OritechRecipe>)entry, category)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }
}

