/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init;

import dev.architectury.core.block.ArchitecturyLiquidBlock;
import dev.architectury.core.fluid.ArchitecturyFlowingFluid;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.SimpleArchitecturyFluidAttributes;
import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.owo.ui.core.Color;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import rearth.oritech.Oritech;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.ItemGroups;

public class FluidContent {
    public static final ArchitecturyFluidAttributes OIL_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_OIL, () -> STILL_OIL).blockSupplier(() -> STILL_OIL_BLOCK).bucketItemSupplier(() -> STILL_OIL_BUCKET).sourceTexture(Oritech.id("block/fluid/fluid_gas_dark")).flowingTexture(Oritech.id("block/fluid/fluid_gas_dark")).color(new Color(0.478f, 0.478f, 0.478f).argb());
    public static final ArchitecturyFluidAttributes FUEL_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_FUEL, () -> STILL_FUEL).blockSupplier(() -> STILL_FUEL_BLOCK).bucketItemSupplier(() -> STILL_FUEL_BUCKET).sourceTexture(Oritech.id("block/fluid/fluid_strange_pale_2")).flowingTexture(Oritech.id("block/fluid/fluid_strange_pale_2")).color(new Color(0.176f, 0.239f, 0.282f).argb());
    public static final ArchitecturyFluidAttributes STEAM_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_STEAM, () -> STILL_STEAM).blockSupplier(() -> STILL_STEAM_BLOCK).bucketItemSupplier(() -> STILL_STEAM_BUCKET).sourceTexture(Oritech.id("block/fluid/fluid_steam")).flowingTexture(Oritech.id("block/fluid/fluid_steam")).color(Color.WHITE.argb());
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((String)"oritech", (ResourceKey)Registries.FLUID);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"oritech", (ResourceKey)Registries.BLOCK);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"oritech", (ResourceKey)Registries.ITEM);
    public static final List<ArchitecturyFluidAttributes> FLUID_ATTRIBUTES = List.of(OIL_ATTRIBUTES, FUEL_ATTRIBUTES, STEAM_ATTRIBUTES);
    public static final RegistrySupplier<FlowingFluid> STILL_OIL = FLUIDS.register("still_oil", () -> new ArchitecturyFlowingFluid.Source(OIL_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> FLOWING_OIL = FLUIDS.register("flowing_oil", () -> new ArchitecturyFlowingFluid.Flowing(OIL_ATTRIBUTES));
    public static final RegistrySupplier<LiquidBlock> STILL_OIL_BLOCK = BLOCKS.register("still_oil_block", () -> new ArchitecturyLiquidBlock(STILL_OIL, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final RegistrySupplier<Item> STILL_OIL_BUCKET = ITEMS.register("still_oil_bucket", () -> new ArchitecturyBucketItem(STILL_OIL, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
    public static final RegistrySupplier<FlowingFluid> STILL_FUEL = FLUIDS.register("still_fuel", () -> new ArchitecturyFlowingFluid.Source(FUEL_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> FLOWING_FUEL = FLUIDS.register("flowing_fuel", () -> new ArchitecturyFlowingFluid.Flowing(FUEL_ATTRIBUTES));
    public static final RegistrySupplier<LiquidBlock> STILL_FUEL_BLOCK = BLOCKS.register("still_fuel_block", () -> new ArchitecturyLiquidBlock(STILL_FUEL, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final RegistrySupplier<Item> STILL_FUEL_BUCKET = ITEMS.register("still_fuel_bucket", () -> new ArchitecturyBucketItem(STILL_FUEL, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
    public static final RegistrySupplier<FlowingFluid> STILL_STEAM = FLUIDS.register("still_steam", () -> new ArchitecturyFlowingFluid.Source(STEAM_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> FLOWING_STEAM = FLUIDS.register("flowing_steam", () -> new ArchitecturyFlowingFluid.Flowing(STEAM_ATTRIBUTES));
    public static final RegistrySupplier<LiquidBlock> STILL_STEAM_BLOCK = BLOCKS.register("still_steam_block", () -> new ArchitecturyLiquidBlock(STILL_STEAM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final RegistrySupplier<Item> STILL_STEAM_BUCKET = ITEMS.register("still_steam_bucket", () -> new ArchitecturyBucketItem(STILL_STEAM, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));

    public static void registerFluids() {
        FLUIDS.register();
    }

    public static void registerBlocks() {
        BLOCKS.register();
    }

    public static void registerItems() {
        ITEMS.register();
    }

    public static void registerItemsToGroups() {
        ItemGroups.add(ItemContent.Groups.components, (ItemLike)STILL_OIL_BUCKET.get());
        ItemGroups.add(ItemContent.Groups.components, (ItemLike)STILL_FUEL_BUCKET.get());
        ItemGroups.add(ItemContent.Groups.components, (ItemLike)STILL_STEAM_BUCKET.get());
    }
}

