/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init;

import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.owo.registration.reflect.BlockRegistryContainer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.accelerator.AcceleratorControllerBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorMotorBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorRingBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorSensorBlock;
import rearth.oritech.block.blocks.accelerator.BlackHoleBlock;
import rearth.oritech.block.blocks.accelerator.ParticleCollectorBlock;
import rearth.oritech.block.blocks.addons.InventoryProxyAddonBlock;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.blocks.addons.RedstoneAddonBlock;
import rearth.oritech.block.blocks.addons.SteamBoilerAddonBlock;
import rearth.oritech.block.blocks.arcane.EnchanterBlock;
import rearth.oritech.block.blocks.arcane.EnchantmentCatalystBlock;
import rearth.oritech.block.blocks.arcane.SpawnerCageBlock;
import rearth.oritech.block.blocks.arcane.SpawnerControllerBlock;
import rearth.oritech.block.blocks.arcane.WitheredCropBlock;
import rearth.oritech.block.blocks.augmenter.AugmentApplicationBlock;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.blocks.decorative.MetalBeamBlock;
import rearth.oritech.block.blocks.decorative.TechDoorBlock;
import rearth.oritech.block.blocks.decorative.TechDoorBlockHinge;
import rearth.oritech.block.blocks.decorative.TechLever;
import rearth.oritech.block.blocks.decorative.TechRedstoneButton;
import rearth.oritech.block.blocks.decorative.WallMountedLight;
import rearth.oritech.block.blocks.generators.BasicGeneratorBlock;
import rearth.oritech.block.blocks.generators.BigSolarPanelBlock;
import rearth.oritech.block.blocks.generators.BioGeneratorBlock;
import rearth.oritech.block.blocks.generators.FuelGeneratorBlock;
import rearth.oritech.block.blocks.generators.LavaGeneratorBlock;
import rearth.oritech.block.blocks.generators.SteamEngineBlock;
import rearth.oritech.block.blocks.interaction.ChargerBlock;
import rearth.oritech.block.blocks.interaction.DeepDrillBlock;
import rearth.oritech.block.blocks.interaction.DestroyerBlock;
import rearth.oritech.block.blocks.interaction.DronePortBlock;
import rearth.oritech.block.blocks.interaction.FertilizerBlock;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.blocks.interaction.MachineFrameBlock;
import rearth.oritech.block.blocks.interaction.PipeBoosterBlock;
import rearth.oritech.block.blocks.interaction.PlacerBlock;
import rearth.oritech.block.blocks.interaction.PumpBlock;
import rearth.oritech.block.blocks.interaction.TreefellerBlock;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeDuctBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorConnectionBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorDuctBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeDuctBlock;
import rearth.oritech.block.blocks.pipes.item.ItemFilterBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeDuctBlock;
import rearth.oritech.block.blocks.processing.AssemblerBlock;
import rearth.oritech.block.blocks.processing.AtomicForgeBlock;
import rearth.oritech.block.blocks.processing.CentrifugeBlock;
import rearth.oritech.block.blocks.processing.CoolerBlock;
import rearth.oritech.block.blocks.processing.FoundryBlock;
import rearth.oritech.block.blocks.processing.FragmentForge;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.blocks.processing.PoweredFurnaceBlock;
import rearth.oritech.block.blocks.processing.PulverizerBlock;
import rearth.oritech.block.blocks.reactor.NuclearExplosionBlock;
import rearth.oritech.block.blocks.reactor.NukeBlock;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberPortBlock;
import rearth.oritech.block.blocks.reactor.ReactorControllerBlock;
import rearth.oritech.block.blocks.reactor.ReactorEnergyPortBlock;
import rearth.oritech.block.blocks.reactor.ReactorFuelPortBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRedstonePortBlock;
import rearth.oritech.block.blocks.reactor.ReactorReflectorBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.blocks.reactor.ReactorWallBlock;
import rearth.oritech.block.blocks.storage.CreativeFluidTank;
import rearth.oritech.block.blocks.storage.CreativeStorageBlock;
import rearth.oritech.block.blocks.storage.LargeStorageBlock;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.ItemGroups;
import rearth.oritech.item.other.SmallFluidTankBlockItem;
import rearth.oritech.util.ArchitecturyBlockRegistryContainer;
import rearth.oritech.util.item.OritechGeoItem;

public class BlockContent
implements ArchitecturyBlockRegistryContainer {
    public static Set<Block> autoRegisteredDrops = new HashSet<Block>();
    public static final Block SPAWNER_CAGE_BLOCK = new SpawnerCageBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block MACHINE_FRAME_BLOCK = new MachineFrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS));
    public static final Block FLUID_PIPE = new FluidPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block FRAMED_FLUID_PIPE = new FluidPipeBlock.FramedFluidPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block FLUID_PIPE_DUCT_BLOCK = new FluidPipeDuctBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block ENERGY_PIPE = new EnergyPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block FRAMED_ENERGY_PIPE = new EnergyPipeBlock.FramedEnergyPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block ENERGY_PIPE_DUCT_BLOCK = new EnergyPipeDuctBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block SUPERCONDUCTOR = new SuperConductorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block FRAMED_SUPERCONDUCTOR = new SuperConductorBlock.FramedSuperConductorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block SUPERCONDUCTOR_DUCT_BLOCK = new SuperConductorDuctBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block ITEM_PIPE = new ItemPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block FRAMED_ITEM_PIPE = new ItemPipeBlock.FramedItemPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    public static final Block ITEM_PIPE_DUCT_BLOCK = new ItemPipeDuctBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block ITEM_FILTER_BLOCK = new ItemFilterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FLUID_PIPE_CONNECTION = new FluidPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FRAMED_FLUID_PIPE_CONNECTION = new FluidPipeConnectionBlock.FramedFluidPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block ENERGY_PIPE_CONNECTION = new EnergyPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FRAMED_ENERGY_PIPE_CONNECTION = new EnergyPipeConnectionBlock.FramedEnergyPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block SUPERCONDUCTOR_CONNECTION = new SuperConductorConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FRAMED_SUPERCONDUCTOR_CONNECTION = new SuperConductorConnectionBlock.FramedSuperConductorConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block ITEM_PIPE_CONNECTION = new ItemPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FRAMED_ITEM_PIPE_CONNECTION = new ItemPipeConnectionBlock.FramedItemPipeConnectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(1.0f, 2.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block FRAME_GANTRY_ARM = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLOCK_DESTROYER_HEAD = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLOCK_PLACER_HEAD = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLOCK_FERTILIZER_HEAD = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block PUMP_TRUNK_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block QUARRY_BEAM_INNER = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion().lightLevel(item -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block QUARRY_BEAM_RING = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion().lightLevel(item -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block QUARRY_BEAM_TARGET = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion());
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLACK_HOLE_INNER = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion().lightLevel(item -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLACK_HOLE_MIDDLE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion().lightLevel(item -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block BLACK_HOLE_OUTER = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).noOcclusion().lightLevel(item -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block ADDON_INDICATOR_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_COLD_INDICATOR_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_MEDIUM_INDICATOR_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_HOT_INDICATOR_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    @UseGeoBlockItem(scale=0.7f)
    public static final Block PULVERIZER_BLOCK = new PulverizerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block FRAGMENT_FORGE_BLOCK = new FragmentForge(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block ASSEMBLER_BLOCK = new AssemblerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block FOUNDRY_BLOCK = new FoundryBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block COOLER_BLOCK = new CoolerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block CENTRIFUGE_BLOCK = new CentrifugeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.3f)
    public static final Block ATOMIC_FORGE_BLOCK = new AtomicForgeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block BIO_GENERATOR_BLOCK = new BioGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block LAVA_GENERATOR_BLOCK = new LavaGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.3f)
    public static final Block FUEL_GENERATOR_BLOCK = new FuelGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block BASIC_GENERATOR_BLOCK = new BasicGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block STEAM_ENGINE_BLOCK = new SteamEngineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block BIG_SOLAR_PANEL_BLOCK = new BigSolarPanelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), Oritech.CONFIG.generators.solarGeneratorData.energyPerTick());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block POWERED_FURNACE_BLOCK = new PoweredFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(Blocks.litBlockEmission((int)15)));
    @UseGeoBlockItem(scale=0.5f)
    public static final Block LASER_ARM_BLOCK = new LaserArmBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.25f)
    public static final Block DEEP_DRILL_BLOCK = new DeepDrillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.3f)
    public static final Block DRONE_PORT_BLOCK = new DronePortBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @NoAutoDrop
    @DispenserPlace
    public static final Block SMALL_STORAGE_BLOCK = new SmallStorageBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block LARGE_STORAGE_BLOCK = new LargeStorageBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @DispenserPlace
    public static final Block CREATIVE_STORAGE_BLOCK = new CreativeStorageBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().pushReaction(PushReaction.BLOCK).destroyTime(-1.0f));
    @NoAutoDrop
    @DispenserPlace
    public static final Block SMALL_TANK_BLOCK = new SmallFluidTank(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().pushReaction(PushReaction.DESTROY).lightLevel(Blocks.litBlockEmission((int)15)));
    @NoAutoDrop
    @DispenserPlace
    public static final Block CREATIVE_TANK_BLOCK = new CreativeFluidTank(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().pushReaction(PushReaction.BLOCK).lightLevel(Blocks.litBlockEmission((int)15)).destroyTime(-1.0f));
    @UseGeoBlockItem(scale=0.7f)
    public static final Block AUGMENT_APPLICATION_BLOCK = new AugmentApplicationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block SIMPLE_AUGMENT_STATION = new AugmentResearchStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(item -> 2));
    public static final Block ADVANCED_AUGMENT_STATION = new AugmentResearchStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(item -> 2));
    public static final Block ARCANE_AUGMENT_STATION = new AugmentResearchStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(item -> 2));
    public static final Block PLACER_BLOCK = new PlacerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block DESTROYER_BLOCK = new DestroyerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block FERTILIZER_BLOCK = new FertilizerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block TREEFELLER_BLOCK = new TreefellerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block PIPE_BOOSTER_BLOCK = new PipeBoosterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block ENCHANTMENT_CATALYST_BLOCK = new EnchantmentCatalystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block ENCHANTER_BLOCK = new EnchanterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block SPAWNER_CONTROLLER_BLOCK = new SpawnerControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @NoAutoDrop
    public static final Block WITHER_CROP_BLOCK = new WitheredCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT));
    public static final Block ACCELERATOR_RING = new AcceleratorRingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block ACCELERATOR_MOTOR = new AcceleratorMotorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(item -> 5));
    public static final Block ACCELERATOR_CONTROLLER = new AcceleratorControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block ACCELERATOR_SENSOR = new AcceleratorSensorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block BLACK_HOLE_BLOCK = new BlackHoleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_PORTAL).lightLevel(item -> 12).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block PARTICLE_COLLECTOR_BLOCK = new ParticleCollectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion());
    @UseGeoBlockItem(scale=0.7f)
    public static final Block PUMP_BLOCK = new PumpBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block CHARGER_BLOCK = new ChargerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block MACHINE_CORE_1 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 1.0f);
    public static final Block MACHINE_CORE_2 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 2.0f);
    public static final Block MACHINE_CORE_3 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 3.0f);
    public static final Block MACHINE_CORE_4 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 4.0f);
    public static final Block MACHINE_CORE_5 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 5.0f);
    public static final Block MACHINE_CORE_6 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 6.0f);
    public static final Block MACHINE_CORE_7 = new MachineCoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), 7.0f);
    public static final Block MACHINE_SPEED_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withSpeedMultiplier(0.9f).withEfficiencyMultiplier(1.05f).withBoundingShape(MachineAddonBlock.MACHINE_SPEED_ADDON_SHAPE));
    public static final Block MACHINE_PROCESSING_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withEfficiencyMultiplier(1.5f).withChambers(1).withBoundingShape(MachineAddonBlock.MACHINE_PROCESSING_ADDON_SHAPE));
    public static final Block MACHINE_FLUID_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.MACHINE_FLUID_ADDON_SHAPE));
    public static final Block MACHINE_YIELD_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.MACHINE_YIELD_ADDON_SHAPE));
    public static final Block CROP_FILTER_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.CROP_FILTER_ADDON_SHAPE));
    public static final Block QUARRY_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.QUARRY_ADDON_SHAPE));
    public static final Block MACHINE_HUNTER_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.MACHINE_HUNTER_ADDON_SHAPE));
    public static final Block MACHINE_EFFICIENCY_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withEfficiencyMultiplier(0.9f).withBoundingShape(MachineAddonBlock.MACHINE_EFFICIENCY_ADDON_SHAPE));
    public static final Block MACHINE_CAPACITOR_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withAddedCapacity(2000000L).withAddedInsert(1000L).withBoundingShape(MachineAddonBlock.MACHINE_CAPACITOR_ADDON_SHAPE));
    public static final Block MACHINE_ACCEPTOR_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withAddedCapacity(500000L).withAddedInsert(2000L).withAcceptEnergy(true).withBoundingShape(MachineAddonBlock.MACHINE_ACCEPTOR_ADDON_SHAPE));
    public static final Block MACHINE_INVENTORY_PROXY_ADDON = new InventoryProxyAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.MACHINE_INVENTORY_PROXY_ADDON_SHAPE));
    public static final Block MACHINE_EXTENDER = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withExtender(true).withNeedsSupport(false));
    public static final Block CAPACITOR_ADDON_EXTENDER = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withExtender(true).withNeedsSupport(false).withAddedCapacity(2500000L).withAddedInsert(500L));
    public static final Block STEAM_BOILER_ADDON = new SteamBoilerAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.STEAM_BOILER_ADDON_SHAPE));
    public static final Block MACHINE_REDSTONE_ADDON = new RedstoneAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withBoundingShape(MachineAddonBlock.MACHINE_REDSTONE_ADDON_SHAPE));
    public static final Block MACHINE_ULTIMATE_ADDON = new MachineAddonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion(), MachineAddonBlock.AddonSettings.getDefaultSettings().withSpeedMultiplier(0.83f).withEfficiencyMultiplier(0.9f).withBoundingShape(MachineAddonBlock.MACHINE_ULTIMATE_ADDON_SHAPE));
    public static final Block REACTOR_CONTROLLER = new ReactorControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 5));
    public static final Block REACTOR_WALL = new ReactorWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).strength(10.0f, 1800.0f));
    public static final Block REACTOR_ROD = new ReactorRodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 3), 1, 1);
    public static final Block REACTOR_DOUBLE_ROD = new ReactorRodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 3), 2, 4);
    public static final Block REACTOR_QUAD_ROD = new ReactorRodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 3), 4, 12);
    public static final Block REACTOR_VENT = new ReactorHeatVentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block REACTOR_REFLECTOR = new ReactorReflectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion().lightLevel(state -> 15));
    public static final Block REACTOR_HEAT_PIPE = new ReactorHeatPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    public static final Block REACTOR_CONDENSER = new ReactorAbsorberBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block REACTOR_FUEL_PORT = new ReactorFuelPortBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block REACTOR_ABSORBER_PORT = new ReactorAbsorberPortBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block REACTOR_ENERGY_PORT = new ReactorEnergyPortBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final Block REACTOR_REDSTONE_PORT = new ReactorRedstonePortBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block URANIUM_CRYSTAL = new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).lightLevel(state -> 5));
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_EXPLOSION_SMALL = new NuclearExplosionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), 9);
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_EXPLOSION_MEDIUM = new NuclearExplosionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), 14);
    @BlockRegistryContainer.NoBlockItem
    public static final Block REACTOR_EXPLOSION_LARGE = new NuclearExplosionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), 20);
    public static final Block LOW_YIELD_NUKE = new NukeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), true);
    public static final Block NUKE = new NukeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), false);
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_ORE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block DEEPSLATE_NICKEL_ORE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block ENDSTONE_PLATINUM_ORE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block DEEPSLATE_PLATINUM_ORE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_DIAMOND_ORE));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block DEEPSLATE_URANIUM_ORE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_DIAMOND_ORE));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_REDSTONE = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_LAPIS = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_IRON = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_COAL = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_GOLD = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_EMERALD = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_DIAMOND = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_COPPER = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_NICKEL = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_PLATINUM = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @NoAutoDrop
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RESOURCE_NODE_URANIUM = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block CEILING_LIGHT = new WallMountedLight(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE).noOcclusion(), 2);
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block CEILING_LIGHT_HANGING = new WallMountedLight(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE).noOcclusion(), 12);
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block TECH_BUTTON = new TechRedstoneButton(BlockSetType.IRON, 80, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block TECH_LEVER = new TechLever(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block MACHINE_PLATING_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block MACHINE_PLATING_SLAB = new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block MACHINE_PLATING_STAIRS = new StairBlock(MACHINE_PLATING_BLOCK.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block MACHINE_PLATING_PRESSURE_PLATE = new PressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block IRON_PLATING_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block IRON_PLATING_SLAB = new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block IRON_PLATING_STAIRS = new StairBlock(IRON_PLATING_BLOCK.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block IRON_PLATING_PRESSURE_PLATE = new PressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_PLATING_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_PLATING_SLAB = new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_PLATING_STAIRS = new StairBlock(NICKEL_PLATING_BLOCK.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_PLATING_PRESSURE_PLATE = new PressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block METAL_BEAM_BLOCK = new MetalBeamBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion());
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block INDUSTRIAL_GLASS_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).requiresCorrectToolForDrops().strength(7.0f, 8.0f).noOcclusion());
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    @UseGeoBlockItem(scale=0.5f)
    public static final Block TECH_DOOR = new TechDoorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR).strength(8.0f));
    @BlockRegistryContainer.NoBlockItem
    public static final Block TECH_DOOR_HINGE = new TechDoorBlockHinge(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR).strength(8.0f));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block STEEL_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block ENERGITE_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> 6));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block NICKEL_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block BIOSTEEL_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block PLATINUM_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block ADAMANT_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block ELECTRUM_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block DURATIUM_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block BIOMASS_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.MOSS));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block PLASTIC_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.SHROOMLIGHT));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block FLUXITE_BLOCK = new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.AMETHYST));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block SILICON_BLOCK = new SlimeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SLIME_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RAW_NICKEL_BLOCK = new SlimeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    @ItemContent.ItemGroupTarget(value=ItemContent.Groups.decorative)
    public static final Block RAW_PLATINUM_BLOCK = new SlimeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));

    @Override
    public void postProcessField(String namespace, Block value, String identifier, Field field, RegistrySupplier<Block> supplier) {
        if (field.isAnnotationPresent(BlockRegistryContainer.NoBlockItem.class)) {
            return;
        }
        if (field.isAnnotationPresent(UseGeoBlockItem.class)) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (Object)this.getGeoBlockItem(value, identifier, field.getAnnotation(UseGeoBlockItem.class).scale()));
        } else if (value.equals(SMALL_TANK_BLOCK) || value.equals(CREATIVE_TANK_BLOCK)) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (Object)((Object)new SmallFluidTankBlockItem(value, new Item.Properties())));
        } else {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (Object)this.createBlockItem(value, identifier));
        }
        ItemContent.Groups targetGroup = ItemContent.Groups.machines;
        if (field.isAnnotationPresent(ItemContent.ItemGroupTarget.class)) {
            targetGroup = field.getAnnotation(ItemContent.ItemGroupTarget.class).value();
        }
        if (!field.isAnnotationPresent(NoAutoDrop.class)) {
            autoRegisteredDrops.add(value);
        }
        if (field.isAnnotationPresent(DispenserPlace.class)) {
            DispenserBlock.registerBehavior((ItemLike)value, (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        }
        ItemGroups.add(targetGroup, (ItemLike)value);
    }

    private BlockItem getGeoBlockItem(Block block, String identifier, float scale) {
        return new OritechGeoItem(block, new Item.Properties(), scale, identifier);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface UseGeoBlockItem {
        public float scale();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoAutoDrop {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DispenserPlace {
    }
}

