/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.MachineAddonController;

public class UpgradableMachineScreenHandler
extends BasicMachineScreenHandler {
    protected final MachineAddonController.AddonUiData addonUiData;
    protected final Level worldAccess;
    protected final float quality;

    public UpgradableMachineScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, MachineAddonController.AddonUiData addonUiData, float coreQuality) {
        super(syncId, playerInventory, blockEntity);
        this.addonUiData = addonUiData;
        if (playerInventory.player.level().isClientSide() && blockEntity instanceof MachineAddonController) {
            MachineAddonController upgradableEntity = (MachineAddonController)blockEntity;
            MachineAddonController.BaseAddonData baseData = new MachineAddonController.BaseAddonData(addonUiData.speed(), addonUiData.efficiency(), 100L, 100L, addonUiData.extraChambers());
            upgradableEntity.setBaseAddonData(baseData);
        }
        this.worldAccess = playerInventory.player.level();
        this.quality = coreQuality;
    }

    @Override
    public boolean showRedstoneAddon() {
        return super.showRedstoneAddon() || this.addonUiData.positions().stream().anyMatch(addonPos -> this.worldAccess.getBlockState(addonPos).getBlock().equals(BlockContent.MACHINE_REDSTONE_ADDON));
    }
}

