/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.processing.FragmentForgeBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.client.ui.components.BlockPreviewComponent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.MachineAddonController;

public class UpgradableMachineScreen<S extends UpgradableMachineScreenHandler>
extends BasicMachineScreen<S> {
    private static final Color SPEED_COLOR = Color.ofRgb((int)2203324);
    private static final Color EFFICIENCY_COLOR = Color.ofRgb((int)9358054);
    private static final Color CAPACITY_COLOR = Color.ofRgb((int)143431);
    private static final Color THROUGHPUT_COLOR = Color.ofRgb((int)16758531);
    private static final float rotationSpeed = 0.2f;
    private static final ResourceLocation MACHINE_CORE_CENTER = Oritech.id("textures/gui/modular/machine_core/center.png");
    protected LabelComponent speedLabel;
    protected LabelComponent efficiencyLabel;

    public UpgradableMachineScreen(S handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public void addExtensionComponents(FlowLayout container) {
        super.addExtensionComponents(container);
        float speed = 1.0f / ((UpgradableMachineScreenHandler)this.menu).addonUiData.speed() * 100.0f;
        float efficiency = 1.0f / ((UpgradableMachineScreenHandler)this.menu).addonUiData.efficiency() * 100.0f;
        int extraChambers = ((UpgradableMachineScreenHandler)this.menu).addonUiData.extraChambers();
        this.speedLabel = Components.label((Component)Component.translatable((String)"title.oritech.machine_speed", (Object[])new Object[]{(int)speed}));
        this.efficiencyLabel = Components.label((Component)Component.translatable((String)"title.oritech.machine_efficiency", (Object[])new Object[]{(int)efficiency}));
        container.child((io.wispforest.owo.ui.core.Component)Components.box((Sizing)Sizing.fixed((int)73), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)));
        container.child(this.speedLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_speed")).margins(Insets.of((int)3)));
        container.child(this.efficiencyLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_efficiency")).margins(Insets.of((int)3)));
        if (extraChambers > 0) {
            container.child(Components.label((Component)Component.translatable((String)"title.oritech.chambers", (Object[])new Object[]{extraChambers})).tooltip((Component)Component.translatable((String)"tooltip.oritech.chambers")).margins(Insets.of((int)3)));
        }
        if (this.steamProductionLabel != null) {
            container.child((io.wispforest.owo.ui.core.Component)this.steamProductionLabel.margins(Insets.of((int)3)));
        }
        if (((UpgradableMachineScreenHandler)this.menu).blockEntity instanceof PulverizerBlockEntity || ((UpgradableMachineScreenHandler)this.menu).blockEntity instanceof FragmentForgeBlockEntity) {
            container.child(Components.label((Component)Component.translatable((String)"title.oritech.machine_option_enabled")).tooltip((Component)Component.translatable((String)"tooltip.oritech.pulverizer_dust_combine")).margins(Insets.of((int)3)));
        }
        if (!((MachineAddonController)((UpgradableMachineScreenHandler)this.menu).blockEntity).getAddonSlots().isEmpty()) {
            this.addMachinePreview(container);
        }
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        int offsetX = -5;
        int offsetY = -23;
        int x = ((UpgradableMachineScreenHandler)this.menu).screenData.getEnergyConfiguration().x() + offsetX;
        int y = ((UpgradableMachineScreenHandler)this.menu).screenData.getEnergyConfiguration().y() + offsetY;
        int size = 25;
        float level = ((UpgradableMachineScreenHandler)this.menu).quality;
        float upgradeCount = level - 1.0f;
        if (upgradeCount == 6.0f) {
            overlay.child(Components.texture((ResourceLocation)this.getRingIdentifier(6), (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)));
            upgradeCount = 5.0f;
        }
        overlay.child(Components.texture((ResourceLocation)MACHINE_CORE_CENTER, (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)).tooltip(this.getQualityTooltip()));
        int i = 1;
        while ((float)i <= upgradeCount) {
            overlay.child(Components.texture((ResourceLocation)this.getRingIdentifier(i), (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)));
            ++i;
        }
    }

    private Component getQualityTooltip() {
        String quality = String.format("%.2f", Float.valueOf(((UpgradableMachineScreenHandler)this.menu).quality));
        int effectiveQuality = (int)((UpgradableMachineScreenHandler)this.menu).quality;
        return Component.translatable((String)"tooltip.oritech.machine.quality", (Object[])new Object[]{effectiveQuality, quality});
    }

    private ResourceLocation getRingIdentifier(int level) {
        return Oritech.id("textures/gui/modular/machine_core/ring_" + level + ".png");
    }

    public void addMachinePreview(FlowLayout sidePanel) {
        FlowLayout floatingContent = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        FlowLayout holoPreviewContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)96));
        holoPreviewContainer.surface(Surface.PANEL);
        holoPreviewContainer.margins(Insets.of((int)2));
        FlowLayout detailsScrollPane = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        detailsScrollPane.padding(Insets.of((int)2));
        ScrollContainer detailsContainer = Containers.verticalScroll((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)110), (io.wispforest.owo.ui.core.Component)detailsScrollPane);
        detailsContainer.surface(Surface.PANEL);
        detailsContainer.margins(Insets.of((int)2));
        detailsContainer.padding(Insets.of((int)4));
        floatingContent.child((io.wispforest.owo.ui.core.Component)holoPreviewContainer);
        floatingContent.child((io.wispforest.owo.ui.core.Component)detailsContainer);
        OverlayContainer<FlowLayout> floatingPanel = new OverlayContainer<FlowLayout>(this, floatingContent){

            public void remove() {
                super.remove();
            }
        };
        floatingPanel.zIndex(9000);
        floatingPanel.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        int previewX = 78;
        int previewY = 41;
        for (BlockPos addonBlockPos : ((UpgradableMachineScreenHandler)this.menu).addonUiData.positions()) {
            BlockState addonBlock = ((UpgradableMachineScreenHandler)this.menu).worldAccess.getBlockState(addonBlockPos);
            BlockEntity addonBlockEntity = ((UpgradableMachineScreenHandler)this.menu).worldAccess.getBlockEntity(addonBlockPos);
            Direction facing = (Direction)((UpgradableMachineScreenHandler)this.menu).machineBlock.getValue(((UpgradableMachineScreenHandler)this.menu).screenData.getBlockFacingProperty());
            Vec3i relativePos = MultiblockMachineEntity.worldToRelativePos((Vec3i)((UpgradableMachineScreenHandler)this.menu).blockPos, (Vec3i)addonBlockPos, facing);
            holoPreviewContainer.child(new BlockPreviewComponent(addonBlock, addonBlockEntity, relativePos, 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
            addonBlock = addonBlock.getBlock().defaultBlockState();
            MachineAddonBlock addonBlockType = (MachineAddonBlock)addonBlock.getBlock();
            MachineAddonBlock.AddonSettings addonSettings = addonBlockType.getAddonSettings();
            float speed = (1.0f - addonSettings.speedMultiplier()) * 100.0f;
            float efficiency = (1.0f - addonSettings.efficiencyMultiplier()) * 100.0f;
            int blockSize = addonSettings.extender() ? 15 : 23;
            FlowLayout detailPane = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)2)).child(Components.block((BlockState)addonBlock).sizing(Sizing.fixed((int)blockSize)).margins(Insets.of((int)4))).child(Components.label((Component)addonBlock.getBlock().getName()).margins(Insets.of((int)5, (int)2, (int)4, (int)2)).verticalSizing(Sizing.fixed((int)15)));
            detailPane.surface(Surface.PANEL_INSET);
            FlowLayout bottomPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
            if (speed != 0.0f) {
                bottomPanel.child(Components.label((Component)Component.translatable((String)"title.oritech.machine_speed", (Object[])new Object[]{(int)speed})).color(SPEED_COLOR).tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_speed")));
            }
            if (efficiency != 0.0f) {
                bottomPanel.child(Components.label((Component)Component.translatable((String)"title.oritech.machine_efficiency", (Object[])new Object[]{(int)efficiency})).color(EFFICIENCY_COLOR).tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_efficiency")));
            }
            if (addonBlockType.getAddonSettings().addedCapacity() > 0L) {
                bottomPanel.child(Components.label((Component)Component.translatable((String)"title.oritech.machine.capacitor_added_capacity", (Object[])new Object[]{addonSettings.addedCapacity()})).color(CAPACITY_COLOR).tooltip((Component)Component.translatable((String)"tooltip.oritech.machine.capacitor_added_capacity")));
            }
            if (addonBlockType.getAddonSettings().addedInsert() > 0L) {
                bottomPanel.child(Components.label((Component)Component.translatable((String)"title.oritech.machine.capacitor_added_throughput", (Object[])new Object[]{addonSettings.addedInsert()})).color(THROUGHPUT_COLOR).tooltip((Component)Component.translatable((String)"tooltip.oritech.machine.capacitor_added_throughput")));
            }
            detailPane.child((io.wispforest.owo.ui.core.Component)bottomPanel.positioning(Positioning.absolute((int)34, (int)18)));
            detailsScrollPane.child((io.wispforest.owo.ui.core.Component)detailPane);
        }
        for (BlockPos openPos : ((UpgradableMachineScreenHandler)this.menu).addonUiData.openSlots()) {
            Vec3i relativePos = MultiblockMachineEntity.worldToRelativePos((Vec3i)((UpgradableMachineScreenHandler)this.menu).blockPos, (Vec3i)openPos, (Direction)((UpgradableMachineScreenHandler)this.menu).machineBlock.getValue(((UpgradableMachineScreenHandler)this.menu).screenData.getBlockFacingProperty()));
            BlockState dummyBlock = BlockContent.ADDON_INDICATOR_BLOCK.defaultBlockState();
            holoPreviewContainer.child(new BlockPreviewComponent(dummyBlock, null, relativePos, 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
        }
        if (((UpgradableMachineScreenHandler)this.menu).addonUiData.positions().isEmpty()) {
            detailsScrollPane.child((io.wispforest.owo.ui.core.Component)Components.label((Component)Component.translatable((String)"title.oritech.machine.no_addons")));
        }
        holoPreviewContainer.child(new BlockPreviewComponent(((UpgradableMachineScreenHandler)this.menu).machineBlock, ((UpgradableMachineScreenHandler)this.menu).blockEntity, new Vec3i(0, 0, 0), 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
        ButtonComponent openAddonsButton = Components.button((Component)Component.translatable((String)"button.oritech.machine.addons"), arg_0 -> this.lambda$addMachinePreview$0(floatingPanel, arg_0));
        sidePanel.child((io.wispforest.owo.ui.core.Component)openAddonsButton);
    }

    private /* synthetic */ void lambda$addMachinePreview$0(1 floatingPanel, ButtonComponent button) {
        this.root.child((io.wispforest.owo.ui.core.Component)floatingPanel);
    }
}

