/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Insets;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.SteamEngineScreenHandler;
import rearth.oritech.client.ui.UpgradableMachineScreen;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class SteamEngineScreen
extends UpgradableMachineScreen<SteamEngineScreenHandler> {
    private final BasicMachineScreen.FluidDisplay waterDisplay;
    protected LabelComponent productionLabel;
    protected LabelComponent steamUsageLabel;

    public SteamEngineScreen(SteamEngineScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        ScreenProvider.BarConfiguration config = handler.screenData.getFluidConfiguration();
        int offset = -config.width() - 8;
        ScreenProvider.BarConfiguration configWater = new ScreenProvider.BarConfiguration(config.x() + offset, config.y(), config.width(), config.height());
        SingleVariantStorage<FluidVariant> container = handler.engineWaterStorage;
        this.waterDisplay = this.initFluidDisplay(container, configWater);
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        this.addFluidDisplay(overlay, this.waterDisplay);
        this.updateFluidDisplay(this.waterDisplay);
    }

    @Override
    public void addExtensionComponents(FlowLayout container) {
        super.addExtensionComponents(container);
        this.productionLabel = Components.label((Component)Component.translatable((String)"title.oritech.steam_energy_production", (Object[])new Object[]{0}));
        container.child(this.productionLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.steam_energy_production")).margins(Insets.of((int)3)));
        this.steamUsageLabel = Components.label((Component)Component.translatable((String)"title.oritech.steam_consumption", (Object[])new Object[]{0}));
        container.child(this.steamUsageLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.steam_consumption")).margins(Insets.of((int)3)));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.updateFluidDisplay(this.waterDisplay);
        SteamEngineEntity steamEntity = (SteamEngineEntity)((SteamEngineScreenHandler)this.menu).blockEntity;
        MachineAddonController.BaseAddonData data = steamEntity.getBaseAddonData();
        String speed = String.format("%.0f", Float.valueOf(1.0f / data.speed() * 100.0f));
        String efficiency = String.format("%.0f", Float.valueOf(1.0f / data.efficiency() * 100.0f));
        int totalProduction = steamEntity.energyProducedTick;
        String totalSteamUsage = String.format("%.0f", Float.valueOf((float)steamEntity.energyProducedTick * data.efficiency() / (float)steamEntity.getEnergyPerTick()));
        this.speedLabel.text((Component)Component.translatable((String)"title.oritech.machine_speed", (Object[])new Object[]{speed}));
        this.efficiencyLabel.text((Component)Component.translatable((String)"title.oritech.machine_efficiency", (Object[])new Object[]{efficiency}));
        this.productionLabel.text((Component)Component.translatable((String)"title.oritech.machine_energy_production", (Object[])new Object[]{totalProduction}));
        this.steamUsageLabel.text((Component)Component.translatable((String)"title.oritech.steam_consumption", (Object[])new Object[]{totalSteamUsage}));
    }
}

