/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.client.init.ModScreens;

public class PlayerModifierScreenHandler
extends AbstractContainerMenu {
    @NotNull
    protected final BlockPos blockPos;
    public final Player player;
    protected BlockState machineBlock;
    public AugmentApplicationEntity blockEntity;

    public PlayerModifierScreenHandler(int syncId, Inventory inventory, ModScreens.BasicData setupData) {
        this(syncId, inventory, inventory.player.level().getBlockEntity(setupData.pos()));
    }

    public PlayerModifierScreenHandler(int syncId, Inventory playerInventory, @NotNull BlockEntity blockEntity) {
        super(ModScreens.MODIFIER_SCREEN, syncId);
        this.blockPos = blockEntity.getBlockPos();
        this.player = playerInventory.player;
        this.machineBlock = blockEntity.getBlockState();
        this.blockEntity = (AugmentApplicationEntity)blockEntity;
        if (blockEntity.getLevel().isClientSide) {
            this.blockEntity.loadAvailableStations(this.player);
        }
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public static class HandlerFactory
    implements ExtendedScreenHandlerType.ExtendedFactory<PlayerModifierScreenHandler, ModScreens.BasicData> {
        public PlayerModifierScreenHandler create(int syncId, Inventory inventory, ModScreens.BasicData data) {
            return new PlayerModifierScreenHandler(syncId, inventory, data);
        }
    }
}

