/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.client.screens.SlotGenerator;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.ItemFilterScreen;

public class ItemFilterScreenHandler
extends AbstractContainerMenu {
    @NotNull
    protected final BlockPos blockPos;
    @NotNull
    protected final ItemFilterBlockEntity blockEntity;

    public ItemFilterScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(ModScreens.ITEM_FILTER_SCREEN, syncId);
        this.blockPos = blockEntity.getBlockPos();
        this.blockEntity = (ItemFilterBlockEntity)blockEntity;
        SlotGenerator.begin(x$0 -> this.addSlot((Slot)x$0), (int)8, (int)84).playerInventory(playerInventory);
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack slotStack = player.getInventory().getItem((slot + 9) % 36);
        if (slotStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack displayStack = new ItemStack((ItemLike)slotStack.getItem(), 1);
        ItemFilterBlockEntity.FilterData data = this.blockEntity.getFilterSettings();
        for (ItemStack item : data.items().values()) {
            if (!item.is(displayStack.getItem())) continue;
            return ItemStack.EMPTY;
        }
        HashMap<Integer, ItemStack> newItems = new HashMap<Integer, ItemStack>(data.items());
        for (int i = 0; i < 8; ++i) {
            if (newItems.containsKey(i)) continue;
            newItems.put(i, displayStack);
            break;
        }
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(data.useNbt(), data.useWhitelist(), newItems);
        this.blockEntity.setFilterSettings(newData);
        if (Objects.requireNonNull(this.blockEntity.getLevel()).isClientSide && player instanceof LocalPlayer) {
            LocalPlayer clientPlayer = (LocalPlayer)player;
            Screen screen = clientPlayer.minecraft.screen;
            if (screen instanceof ItemFilterScreen) {
                ItemFilterScreen filterScreen = (ItemFilterScreen)screen;
                filterScreen.updateItemFilters();
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

