/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.util.ScreenProvider;

public class InventoryProxyScreenHandler
extends AbstractContainerMenu {
    @NotNull
    protected final BlockPos blockPos;
    @NotNull
    protected final InventoryProxyAddonBlockEntity addonEntity;
    protected int selectedSlot = 0;
    @NotNull
    protected final ScreenProvider controllerScreen;

    public InventoryProxyScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, @NotNull ScreenProvider controllerScreen, int selectedSlot) {
        super(ModScreens.INVENTORY_PROXY_SCREEN, syncId);
        this.blockPos = blockEntity.getBlockPos();
        this.controllerScreen = controllerScreen;
        this.selectedSlot = selectedSlot;
        this.addonEntity = (InventoryProxyAddonBlockEntity)blockEntity;
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public static class HandlerFactory
    implements ExtendedScreenHandlerType.ExtendedFactory<InventoryProxyScreenHandler, InvProxyData> {
        public InventoryProxyScreenHandler create(int syncId, Inventory inventory, InvProxyData data) {
            return new InventoryProxyScreenHandler(syncId, inventory, inventory.player.level().getBlockEntity(data.ownPos), (ScreenProvider)inventory.player.level().getBlockEntity(data.controllerPos), data.slot);
        }
    }

    public record InvProxyData(BlockPos ownPos, BlockPos controllerPos, int slot) {
        public static final Endec<InvProxyData> PACKET_ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.BLOCK_POS.fieldOf("ownPos", InvProxyData::ownPos), (StructField)MinecraftEndecs.BLOCK_POS.fieldOf("controllerPos", InvProxyData::controllerPos), (StructField)Endec.INT.fieldOf("slot", InvProxyData::slot), InvProxyData::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, InvProxyData> PACKET_CODEC = CodecUtils.toPacketCodec(PACKET_ENDEC);
    }
}

