/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.ScreenProvider;

public class InventoryProxyScreen
extends BaseOwoHandledScreen<FlowLayout, InventoryProxyScreenHandler> {
    private final List<ButtonComponent> buttons = new ArrayList<ButtonComponent>();

    public InventoryProxyScreen(InventoryProxyScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)100));
        FlowLayout spacer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)71));
        rootComponent.child((io.wispforest.owo.ui.core.Component)overlay.surface(Surface.PANEL));
        rootComponent.child((io.wispforest.owo.ui.core.Component)spacer);
        for (ScreenProvider.GuiSlot slot : Objects.requireNonNull(((InventoryProxyScreenHandler)this.menu).controllerScreen).getGuiSlots()) {
            ButtonComponent button = Components.button((Component)Component.literal((String)""), elem -> this.setActiveSlot(slot.index()));
            this.buttons.add(button);
            overlay.child(BasicMachineScreen.getItemFrame(slot.x(), slot.y()));
            overlay.child(button.sizing(Sizing.fixed((int)10)).positioning(Positioning.absolute((int)(slot.x() + 2), (int)(slot.y() + 2))));
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonComponent button = this.buttons.get(i);
            button.active = i != ((InventoryProxyScreenHandler)this.menu).selectedSlot;
        }
        this.addTitle(overlay);
        LabelComponent hint = Components.label((Component)Component.translatable((String)"tooltip.oritech.addon_proxy_select"));
        hint.horizontalTextAlignment(HorizontalAlignment.CENTER);
        hint.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        hint.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        overlay.child((io.wispforest.owo.ui.core.Component)hint.positioning(Positioning.relative((int)50, (int)90)));
    }

    private void addTitle(FlowLayout overlay) {
        MutableComponent blockTitle = ((InventoryProxyScreenHandler)this.menu).addonEntity.getBlockState().getBlock().getName();
        LabelComponent label = Components.label((Component)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((io.wispforest.owo.ui.core.Component)label.positioning(Positioning.relative((int)50, (int)2)));
    }

    private void setActiveSlot(int slot) {
        ((InventoryProxyScreenHandler)this.menu).selectedSlot = slot;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonComponent button = this.buttons.get(i);
            button.active = i != slot;
        }
        ((InventoryProxyScreenHandler)this.menu).addonEntity.setTargetSlot(slot);
        NetworkContent.UI_CHANNEL.clientHandle().send((Record)new NetworkContent.InventoryProxySlotSelectorPacket(((InventoryProxyScreenHandler)this.menu).blockPos, slot));
    }
}

