/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.EnchanterScreenHandler;
import rearth.oritech.network.NetworkContent;

public class EnchanterScreen
extends BasicMachineScreen<EnchanterScreenHandler> {
    private ItemStack currentItem = null;
    private FlowLayout detailsScrollPane;
    private ButtonComponent openEnchantmentSelection;
    private LabelComponent statisticsLabel;

    public EnchanterScreen(EnchanterScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public boolean showExtensionPanel() {
        return false;
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        this.openEnchantmentSelection = Components.button((Component)Component.translatable((String)"button.oritech.enchanter.bane_of_long_names"), this::onOpenClicked);
        this.openEnchantmentSelection.positioning(Positioning.relative((int)54, (int)13));
        this.openEnchantmentSelection.active(false);
        overlay.child((io.wispforest.owo.ui.core.Component)this.openEnchantmentSelection);
        this.detailsScrollPane = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        this.detailsScrollPane.padding(Insets.of((int)2));
        this.detailsScrollPane.margins(Insets.of((int)3));
        this.statisticsLabel = Components.label((Component)Component.translatable((String)"title.oritech.enchanter.catalysts_available", (Object[])new Object[]{1, 4}));
        this.statisticsLabel.positioning(Positioning.relative((int)54, (int)29));
        overlay.child((io.wispforest.owo.ui.core.Component)this.statisticsLabel);
    }

    private void onOpenClicked(ButtonComponent event) {
        NetworkContent.UI_CHANNEL.clientHandle().send((Record)new NetworkContent.EnchanterSelectionPacket(((EnchanterScreenHandler)this.menu).blockPos, ""));
        ((EnchanterScreenHandler)this.menu).enchanter.selectedEnchantment = null;
        this.openSelectionPanel();
    }

    @Override
    protected void containerTick() {
        boolean hasSelection;
        super.containerTick();
        ItemStack stack = ((EnchanterScreenHandler)this.menu).enchanter.inventory.getItem(0);
        if (this.currentItem == null) {
            this.currentItem = stack;
        }
        if (stack.getItem() != this.currentItem.getItem()) {
            this.currentItem = stack;
            this.onStackChanged();
        }
        MutableComponent description = Component.translatable((String)"message.oritech.enchanter.insert_item");
        boolean bl = hasSelection = ((EnchanterScreenHandler)this.menu).enchanter.selectedEnchantment != null;
        if (hasSelection) {
            description = ((Enchantment)((EnchanterScreenHandler)this.menu).enchanter.selectedEnchantment.value()).description();
        }
        this.openEnchantmentSelection.setMessage((Component)description);
        Registry registry = ((EnchanterScreenHandler)this.menu).enchanter.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        boolean canBeEnchanted = registry.stream().anyMatch(elem -> elem.canEnchant(stack));
        this.openEnchantmentSelection.active(hasSelection && canBeEnchanted);
        EnchanterBlockEntity.EnchanterStatistics statistics = ((EnchanterScreenHandler)this.menu).enchanter.statistics;
        if (statistics.equals(EnchanterBlockEntity.EnchanterStatistics.EMPTY)) {
            this.statisticsLabel.text((Component)Component.literal((String)""));
        } else {
            this.statisticsLabel.text((Component)Component.translatable((String)"title.oritech.enchanter.catalysts", (Object[])new Object[]{statistics.availableCatalysts(), statistics.requiredCatalysts()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        this.progress_indicator.tooltip((Component)Component.translatable((String)"title.oritech.enchanter.souls_used", (Object[])new Object[]{((EnchanterScreenHandler)this.menu).enchanter.progress, ((EnchanterScreenHandler)this.menu).enchanter.maxProgress}));
    }

    private void onStackChanged() {
        if (((EnchanterScreenHandler)this.menu).enchanter.selectedEnchantment != null) {
            return;
        }
        this.openSelectionPanel();
    }

    private void openSelectionPanel() {
        Registry registry = ((EnchanterScreenHandler)this.menu).enchanter.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        List<Holder> all = registry.stream().map(arg_0 -> ((Registry)registry).wrapAsHolder(arg_0)).filter(entry -> ((Enchantment)entry.value()).canEnchant(this.currentItem)).toList();
        if (all.isEmpty()) {
            return;
        }
        this.detailsScrollPane.clearChildren();
        LabelComponent title = Components.label((Component)Component.translatable((String)"tooltip.oritech.enchanter_selection"));
        this.detailsScrollPane.child((io.wispforest.owo.ui.core.Component)title);
        ScrollContainer scrollPane = Containers.verticalScroll((Sizing)Sizing.fixed((int)184), (Sizing)Sizing.fixed((int)200), (io.wispforest.owo.ui.core.Component)this.detailsScrollPane);
        scrollPane.padding(Insets.of((int)2));
        OverlayContainer floatingPanel = Containers.overlay((io.wispforest.owo.ui.core.Component)scrollPane);
        for (Holder entry2 : all) {
            Enchantment candidate = (Enchantment)entry2.value();
            ButtonComponent button = Components.button((Component)candidate.description(), data -> this.onEnchantmentSelected((Holder<Enchantment>)entry2, (OverlayContainer<ScrollContainer<FlowLayout>>)floatingPanel));
            button.sizing(Sizing.fill(), Sizing.fixed((int)25));
            button.margins(Insets.of((int)1, (int)1, (int)0, (int)8));
            this.detailsScrollPane.child((io.wispforest.owo.ui.core.Component)button);
        }
        scrollPane.surface(Surface.DARK_PANEL);
        floatingPanel.zIndex(9800);
        floatingPanel.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.root.child((io.wispforest.owo.ui.core.Component)floatingPanel);
    }

    private void onEnchantmentSelected(Holder<Enchantment> entry, OverlayContainer<ScrollContainer<FlowLayout>> floatingPanel) {
        ((EnchanterScreenHandler)this.menu).enchanter.selectedEnchantment = entry;
        floatingPanel.remove();
        NetworkContent.UI_CHANNEL.clientHandle().send((Record)new NetworkContent.EnchanterSelectionPacket(((EnchanterScreenHandler)this.menu).blockPos, entry.getRegisteredName()));
    }
}

