/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.item.tools.LaserTargetDesignator;
import rearth.oritech.util.MachineAddonController;

public class DroneScreenHandler
extends UpgradableMachineScreenHandler {
    private final SimpleContainer cardInventory;
    private final SingleVariantStorage<FluidVariant> fluidTank;

    public DroneScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, MachineAddonController.AddonUiData addonUiData, float coreQuality) {
        super(syncId, playerInventory, blockEntity, addonUiData, coreQuality);
        if (!(blockEntity instanceof DronePortEntity)) {
            this.cardInventory = null;
            this.fluidTank = null;
            Oritech.LOGGER.error("Opened drone screen on non-drone block, this should never happen");
            return;
        }
        DronePortEntity dronePortEntity = (DronePortEntity)blockEntity;
        this.cardInventory = dronePortEntity.getCardInventory();
        this.cardInventory.startOpen(playerInventory.player);
        this.addCardSlots();
        this.fluidTank = dronePortEntity.hasFluidAddon ? dronePortEntity.fluidStorage : null;
    }

    private void addCardSlots() {
        this.addSlot(new Slot((Container)this.cardInventory, 0, 130, 26));
        this.addSlot(new Slot((Container)this.cardInventory, 1, 130, 62));
    }

    @Override
    public int getPlayerInvEndSlot(ItemStack stack) {
        return super.getPlayerInvEndSlot(stack) - 2;
    }

    @Override
    public int getMachineInvStartSlot(ItemStack stack) {
        if (stack.getItem() instanceof LaserTargetDesignator) {
            return this.slots.size() - 2;
        }
        return super.getMachineInvStartSlot(stack);
    }

    @Override
    public int getMachineInvEndSlot(ItemStack stack) {
        if (stack.getItem() instanceof LaserTargetDesignator) {
            return this.slots.size();
        }
        return super.getMachineInvEndSlot(stack);
    }
}

