/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.MachineAddonController;

public class CentrifugeScreenHandler
extends UpgradableMachineScreenHandler {
    public final SingleVariantStorage<FluidVariant> inputTank;
    public final SimpleContainer bucketInventory;

    public CentrifugeScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, MachineAddonController.AddonUiData addonUiData, float coreQuality) {
        super(syncId, playerInventory, blockEntity, addonUiData, coreQuality);
        if (!(blockEntity instanceof CentrifugeBlockEntity)) {
            this.inputTank = null;
            this.bucketInventory = null;
            Oritech.LOGGER.error("Opened centrifuge screen on non-centrifuge block, this should never happen");
            return;
        }
        CentrifugeBlockEntity centrifugeEntity = (CentrifugeBlockEntity)blockEntity;
        if (centrifugeEntity.hasFluidAddon) {
            this.inputTank = centrifugeEntity.inputStorage;
            this.bucketInventory = centrifugeEntity.bucketInventory;
            this.bucketInventory.startOpen(playerInventory.player);
            this.addBucketSlots();
        } else {
            this.inputTank = null;
            this.bucketInventory = null;
        }
    }

    private void addBucketSlots() {
        this.addSlot(new Slot((Container)this.bucketInventory, 0, 130, -30));
        this.addSlot(new Slot((Container)this.bucketInventory, 1, 130, -10));
    }

    @Override
    public int getPlayerInvEndSlot(ItemStack stack) {
        return super.getPlayerInvEndSlot(stack) - 2;
    }

    @Override
    public int getMachineInvStartSlot(ItemStack stack) {
        if (stack.getItem() instanceof BucketItem && this.inputTank != null) {
            return this.slots.size() - 2;
        }
        return super.getMachineInvStartSlot(stack);
    }

    @Override
    public int getMachineInvEndSlot(ItemStack stack) {
        if (stack.getItem() instanceof BucketItem && this.inputTank != null) {
            return this.slots.size();
        }
        return super.getMachineInvEndSlot(stack);
    }
}

