/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.client.screens.SlotGenerator;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineOutputSlot;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;

public class BasicMachineScreenHandler
extends AbstractContainerMenu {
    @NotNull
    protected final Inventory playerInventory;
    @NotNull
    protected final Container inventory;
    @NotNull
    protected final EnergyApi.EnergyContainer energyStorage;
    @NotNull
    protected final BlockPos blockPos;
    @NotNull
    public final ScreenProvider screenData;
    @Nullable
    protected final SingleVariantStorage<FluidVariant> steamStorage;
    @Nullable
    protected final SingleVariantStorage<FluidVariant> waterStorage;
    protected final FluidProvider fluidProvider;
    protected BlockState machineBlock;
    public BlockEntity blockEntity;
    protected List<Integer> armorSlots;

    public BasicMachineScreenHandler(int syncId, Inventory inventory, ModScreens.BasicData setupData) {
        this(syncId, inventory, inventory.player.level().getBlockEntity(setupData.pos()));
    }

    /*
     * Unable to fully structure code
     */
    public BasicMachineScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(((ScreenProvider)blockEntity).getScreenHandlerType(), syncId);
        this.screenData = (ScreenProvider)blockEntity;
        this.blockPos = blockEntity.getBlockPos();
        this.inventory = this.screenData.getDisplayedInventory();
        this.inventory.startOpen(playerInventory.player);
        this.playerInventory = playerInventory;
        if (blockEntity instanceof EnergyApi.BlockProvider) {
            energyProvider = (EnergyApi.BlockProvider)blockEntity;
            this.energyStorage = energyProvider.getStorage(null);
        } else {
            this.energyStorage = null;
        }
        this.fluidProvider = blockEntity instanceof FluidProvider && (blockFluidProvider = (FluidProvider)blockEntity).getForDirectFluidAccess() != null ? ((fluidIterator = blockFluidProvider.getFluidStorage(null).iterator()).hasNext() ? blockFluidProvider : null) : null;
        this.machineBlock = blockEntity.getBlockState();
        var5_5 = this.blockEntity = blockEntity;
        if (!(var5_5 instanceof UpgradableGeneratorBlockEntity)) ** GOTO lbl-1000
        generatorEntity = (UpgradableGeneratorBlockEntity)var5_5;
        if (generatorEntity.isProducingSteam) {
            this.steamStorage = generatorEntity.getSteamStorage();
            this.waterStorage = generatorEntity.getWaterStorage();
        } else lbl-1000:
        // 2 sources

        {
            this.steamStorage = null;
            this.waterStorage = null;
        }
        this.buildItemSlots();
    }

    private void buildItemSlots() {
        for (ScreenProvider.GuiSlot slot : this.screenData.getGuiSlots()) {
            this.addMachineSlot(slot.index(), slot.x(), slot.y(), slot.output());
        }
        SlotGenerator.begin(x$0 -> this.addSlot((Slot)x$0), (int)8, (int)84).playerInventory(this.playerInventory);
        if (this.screenData.showArmor()) {
            this.armorSlots = new ArrayList<Integer>(5);
            for (int i = 0; i < this.playerInventory.armor.size() + 1; ++i) {
                final int iteration = i;
                Slot index = this.addSlot(new Slot(this, (Container)this.playerInventory, 36 + i, -20, i * 19){

                    public boolean mayPlace(ItemStack stack) {
                        if (iteration == 4) {
                            return super.mayPlace(stack);
                        }
                        Item item = stack.getItem();
                        if (item instanceof ArmorItem) {
                            ArmorItem armorItem = (ArmorItem)item;
                            return super.mayPlace(stack) && armorItem.getEquipmentSlot().getIndex() == iteration;
                        }
                        return false;
                    }
                });
                this.armorSlots.add(index.index);
            }
        }
    }

    public void addMachineSlot(int inventorySlot, int x, int y, boolean output) {
        if (output) {
            this.addSlot(new BasicMachineOutputSlot(this.inventory, inventorySlot, x, y));
        } else {
            this.addSlot(new Slot(this.inventory, inventorySlot, x, y));
        }
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() || invSlot >= this.inventory.getContainerSize() + 36 ? !this.moveItemStackTo(originalStack, this.getPlayerInvStartSlot(newStack), this.getPlayerInvEndSlot(newStack), true) : !this.moveItemStackTo(originalStack, this.getMachineInvStartSlot(newStack), this.getMachineInvEndSlot(newStack), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public int getPlayerInvStartSlot(ItemStack stack) {
        return this.inventory.getContainerSize();
    }

    public int getPlayerInvEndSlot(ItemStack stack) {
        if (this.screenData.showArmor()) {
            return this.slots.size() - 1;
        }
        return this.slots.size();
    }

    public int getMachineInvStartSlot(ItemStack stack) {
        return 0;
    }

    public int getMachineInvEndSlot(ItemStack stack) {
        return this.inventory.getContainerSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean showRedstoneAddon() {
        return this.screenData.hasRedstoneControlAvailable();
    }
}

