/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class LaserArmModel<T extends LaserArmBlockEntity>
extends DefaultedBlockGeoModel<T> {
    private static final HashMap<Long, ModelRenderData> additionalData = new HashMap();
    private static final HashMap<Long, Vec3> drillOffsets = new HashMap();

    public LaserArmModel(String subpath) {
        super(Oritech.id(subpath));
    }

    private ModelRenderData getById(long id) {
        return additionalData.computeIfAbsent(id, s -> new ModelRenderData(0.0f, 0.0f, this.getAnimationProcessor().getBone("pivotX"), this.getAnimationProcessor().getBone("pivotY")));
    }

    private Vec3 getOffsetByDrillId(long id, T laserEntity) {
        return drillOffsets.computeIfAbsent(id, s -> {
            Direction drillFacing = (Direction)laserEntity.getLevel().getBlockState(laserEntity.getCurrentTarget()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return Geometry.rotatePosition(new Vec3(1.0, 1.4, 0.0), drillFacing);
        });
    }

    public void setCustomAnimations(T laserEntity, long instanceId, AnimationState<T> animationState) {
        if (((LaserArmBlockEntity)laserEntity).getCurrentTarget() == null) {
            return;
        }
        Vec3 target = ((LaserArmBlockEntity)laserEntity).getVisualTarget();
        if (((LaserArmBlockEntity)laserEntity).isTargetingDeepdrill()) {
            long drillId = ((LaserArmBlockEntity)laserEntity).getCurrentTarget().asLong();
            Vec3 offset = this.getOffsetByDrillId(drillId, laserEntity);
            target = target.add(offset);
        }
        Vec3 ownPos = Vec3.atLowerCornerOf((Vec3i)laserEntity.getBlockPos());
        Vec3 offset = target.subtract(ownPos.add(0.0, 1.2, 0.0));
        Vector2f offsetY = new Vector2f((float)offset.x(), (float)offset.z());
        Vector2f forwardY = new Vector2f(0.0f, 1.0f);
        float detY = LaserArmModel.determinant(offsetY, forwardY);
        float dotY = offsetY.dot((Vector2fc)forwardY);
        double angleY = Math.atan2(detY, dotY);
        float lengthY = offsetY.length();
        double heightDiff = offset.y();
        Vector2f offsetX = new Vector2f(lengthY, (float)heightDiff);
        Vector2f forwardX = new Vector2f(0.0f, 1.0f);
        float detX = LaserArmModel.determinant(offsetX, forwardX);
        float dotX = offsetX.dot((Vector2fc)forwardX);
        double angleX = Math.atan2(detX, dotX);
        angleX -= 0.7417649263516068;
        ModelRenderData data = this.getById(instanceId);
        if (data.boneX != null) {
            float newRotY = LaserArmModel.lerp(data.angleY, (float)angleY, 0.06f);
            float newRotX = LaserArmModel.lerp(data.angleX, (float)angleX, 0.06f);
            data.boneY.setRotY(newRotY);
            data.boneX.setRotX(newRotX);
            data.angleY = newRotY;
            data.angleX = newRotX;
        }
    }

    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static float determinant(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }

    private static class ModelRenderData {
        protected float angleY;
        protected float angleX;
        protected GeoBone boneX;
        protected GeoBone boneY;

        public ModelRenderData(float angleX, float angleY, GeoBone boneX, GeoBone boneY) {
            this.angleY = angleY;
            this.angleX = angleX;
            this.boneX = boneX;
            this.boneY = boneY;
        }
    }
}

