/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.blocks.storage.LargeStorageBlock;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;

public class BlockOutlineRenderer {
    public static void render(ClientLevel world, Camera camera, DeltaTracker counter, PoseStack matrixStack, MultiBufferSource consumer, GameRenderer gameRenderer, Matrix4f matrix, LightTexture lightTexture, LevelRenderer worldRenderer) {
        if (world == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null || player.isShiftKeyDown()) {
            return;
        }
        if (client.hitResult == null || client.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        BlockPos blockPos = ((BlockHitResult)client.hitResult).getBlockPos();
        if (Oritech.CONFIG.showMachinePreview()) {
            BlockOutlineRenderer.renderBlockPlacementPreviewOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
        }
        BlockOutlineRenderer.renderPromethiumPickaxeOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
    }

    private static void renderBlockPlacementPreviewOutline(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer, ItemStack itemStack, LocalPlayer player, BlockPos blockPos) {
        BlockState placementState;
        EntityBlock entityProvider;
        BlockItem blockItem;
        block12: {
            block11: {
                Item item = itemStack.getItem();
                if (!(item instanceof BlockItem)) {
                    return;
                }
                blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                if (!(block instanceof EntityBlock)) break block11;
                entityProvider = (EntityBlock)block;
                if (blockItem.getBlock().defaultBlockState().hasProperty((Property)MultiblockMachine.ASSEMBLED)) break block12;
            }
            return;
        }
        BlockPos machinePos = blockPos.offset(((BlockHitResult)player.minecraft.hitResult).getDirection().getNormal());
        BlockEntity entity = entityProvider.newBlockEntity(machinePos, placementState = blockItem.getBlock().getStateForPlacement(new BlockPlaceContext((Player)player, player.swingingArm, itemStack, (BlockHitResult)player.minecraft.hitResult)));
        if (!(entity instanceof MultiblockMachineController)) {
            return;
        }
        MultiblockMachineController multiblockController = (MultiblockMachineController)entity;
        List<Vec3i> coreOffsets = multiblockController.getCorePositions();
        Direction machineFacing = BlockOutlineRenderer.getFacingFromState(placementState);
        if (blockItem.getBlock() instanceof LargeStorageBlock) {
            machineFacing = player.getDirection().getOpposite();
        } else if (blockItem.getBlock() instanceof AugmentResearchStationBlock) {
            machineFacing = player.getNearestViewDirection();
        } else if (!(blockItem.getBlock() instanceof MultiblockMachine)) {
            machineFacing = machineFacing.getOpposite();
        }
        ArrayList<Vec3i> fullList = new ArrayList<Vec3i>(coreOffsets);
        fullList.add(Vec3i.ZERO);
        matrixStack.pushPose();
        Vec3 cameraPos = camera.getPosition();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        matrixStack.translate(0.005f, 0.005f, 0.005f);
        VoxelShape shape = Shapes.block();
        for (Vec3i coreOffset : fullList) {
            Vec3i fixedOffset = new Vec3i(coreOffset.getX(), coreOffset.getY(), coreOffset.getZ());
            Vec3i worldOffset = Geometry.offsetToWorldPosition(machineFacing, fixedOffset, (Vec3i)machinePos);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)worldOffset.getX(), (double)worldOffset.getY(), (double)worldOffset.getZ(), (double)(worldOffset.getX() + 1), (double)(worldOffset.getY() + 1), (double)(worldOffset.getZ() + 1)));
        }
        LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)shape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        matrixStack.popPose();
    }

    private static Direction getFacingFromState(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.FACING);
        }
        if (state.hasProperty((Property)SmallStorageBlock.TARGET_DIR)) {
            return (Direction)state.getValue((Property)SmallStorageBlock.TARGET_DIR);
        }
        return Direction.NORTH;
    }

    private static void renderPromethiumPickaxeOutline(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer, ItemStack itemStack, LocalPlayer player, BlockPos blockPos) {
        if (!itemStack.is(ToolsContent.PROMETHIUM_PICKAXE)) {
            return;
        }
        List<BlockPos> offsetBlocks = PromethiumPickaxeItem.getOffsetBlocks((Level)world, (Player)player, blockPos);
        matrixStack.pushPose();
        Vec3 cameraPos = camera.getPosition();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        for (BlockPos offsetPos : offsetBlocks) {
            BlockState offsetState = world.getBlockState(offsetPos);
            VoxelShape renderShape = offsetState.getShape((BlockGetter)world, offsetPos);
            matrixStack.pushPose();
            matrixStack.translate((float)offsetPos.getX(), (float)offsetPos.getY(), (float)offsetPos.getZ());
            LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)renderShape, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

