/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.other;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class OreFinderRenderer {
    public static List<BlockPos> renderedBlocks;
    public static long receivedAt;
    private static final RenderType OVERLAY;

    public static void doRender(WorldRenderContext worldRenderContext) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null || renderedBlocks == null) {
            return;
        }
        long age = world.getGameTime() - receivedAt;
        if (age > 40L) {
            return;
        }
        for (BlockPos pos : renderedBlocks) {
            BlockState state = world.getBlockState(pos);
            PoseStack matrices = worldRenderContext.matrixStack();
            Camera camera = worldRenderContext.camera();
            matrices.pushPose();
            matrices.translate((double)pos.getX() - camera.getPosition().x, (double)pos.getY() - camera.getPosition().y, (double)pos.getZ() - camera.getPosition().z);
            VertexConsumer vertexProvider = worldRenderContext.consumers().getBuffer(OVERLAY);
            ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            renderer.tesselateWithoutAO((BlockAndTintGetter)world, Minecraft.getInstance().getBlockRenderer().getBlockModel(state), state, pos, matrices, vertexProvider, false, world.random, 0L, 0xF000F0);
            matrices.popPose();
        }
    }

    static {
        OVERLAY = RenderType.create((String)"testoverlay", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.RENDERTYPE_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setOutputState(RenderStateShard.OUTLINE_TARGET).setCullState(RenderStateShard.CULL).createCompositeState(false));
    }
}

