/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.init;

import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;

public class ParticleContent {
    public static final ParticleSystemController PARTICLE_CONTROLLER = new ParticleSystemController(Oritech.id("particles"));
    public static final ParticleSystem<Void> HIGHLIGHT_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, pos, 1.0f, 120, 6);
        ClientParticles.reset();
    });
    public static final ParticleSystem<LineData> WEED_KILLER = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> {
        int dist = (int)data.end.distanceTo(data.start);
        ClientParticles.setParticleCount((int)(dist * 4 + world.random.nextInt(3)));
        ClientParticles.spawnLine((ParticleOptions)ParticleTypes.DRAGON_BREATH, (Level)world, (Vec3)data.start, (Vec3)data.end, (float)0.2f);
    });
    public static final ParticleSystem<Void> DEBUG_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, pos, 1.0f, 120, 2);
        ClientParticles.reset();
    });
    public static final ParticleSystem<SoulParticleData> WANDERING_SOUL = PARTICLE_CONTROLLER.register(SoulParticleData.class, (world, pos, data) -> {
        ClientParticles.setVelocity((Vec3)data.offset.scale((double)(1.0f / (float)data.duration * 1.5f)));
        ClientParticles.spawnWithMaxAge((ParticleOptions)ParticleTypes.SCULK_SOUL, (Vec3)pos, (int)data.duration);
    });
    public static final ParticleSystem<LineData> CATALYST_CONNECTION = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> ClientParticles.spawnEnchantParticles((Level)world, (Vec3)data.start, (Vec3)data.end, (float)0.7f));
    public static final ParticleSystem<Vec3> BLACK_HOLE_EMISSION = PARTICLE_CONTROLLER.register(Vec3.class, (world, pos, data) -> {
        int dist = (int)data.distanceTo(pos);
        ClientParticles.setParticleCount((int)(dist + world.random.nextInt(3)));
        ClientParticles.spawnLine((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, (Level)world, (Vec3)pos, (Vec3)data, (float)0.2f);
    });
    public static final ParticleSystem<Integer> FERTILIZER_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnWithinBlock((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
    });
    public static final ParticleSystem<Integer> BLOCK_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (double)0.6);
    });
    public static final ParticleSystem<Integer> QUARRY_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (Level)world, (Vec3)pos, (double)0.4);
    });
    public static final ParticleSystem<Integer> WATERING_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((ParticleOptions)ParticleTypes.FALLING_WATER, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (double)0.6);
    });
    public static final ParticleSystem<Integer> FURNACE_BURNING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((ParticleOptions)ParticleTypes.LAVA, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (double)0.6);
    });
    public static final ParticleSystem<Integer> PULVERIZER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((ParticleOptions)ParticleTypes.DUST_PLUME, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (double)0.6);
    });
    public static final ParticleSystem<Integer> SOUL_USED = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (Level)world, (Vec3)pos, (double)1.2);
    });
    public static final ParticleSystem<Integer> MELTDOWN_IMMINENT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.LAVA, (Level)world, (Vec3)pos, (double)1.0);
    });
    public static final ParticleSystem<Integer> GRINDER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.DUST_PLUME, (Level)world, (Vec3)pos, (double)0.8);
    });
    public static final ParticleSystem<Integer> ASSEMBLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.ENCHANTED_HIT, (Level)world, (Vec3)pos, (double)0.6);
    });
    public static final ParticleSystem<Integer> COOLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.SNOWFLAKE, (Level)world, (Vec3)pos, (double)1.2);
    });
    public static final ParticleSystem<Integer> STEAM_ENGINE_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.CLOUD, (Level)world, (Vec3)pos, (double)0.6);
    });
    public static final ParticleSystem<Integer> CHARGING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((ParticleOptions)ParticleTypes.SONIC_BOOM, (Level)world, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (double)0.6);
    });
    public static final ParticleSystem<Void> BIG_HIT = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawn((ParticleOptions)ParticleTypes.SONIC_BOOM, (Level)world, (Vec3)pos, (double)0.3));
    public static final ParticleSystem<Void> PARTICLE_COLLIDE = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawn((ParticleOptions)ParticleTypes.GUST, (Level)world, (Vec3)pos, (double)0.0));
    public static final ParticleSystem<Vec3> JETPACK_EXHAUST = PARTICLE_CONTROLLER.register(Vec3.class, (world, pos, data) -> {
        ClientParticles.setVelocity((Vec3)data);
        ClientParticles.spawn((ParticleOptions)ParticleTypes.SMOKE, (Level)world, (Vec3)pos, (double)0.1);
    });
    public static final ParticleSystem<Void> ACCELERATING = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, pos, 1.0f, 5, 3);
        ClientParticles.reset();
    });
    public static final ParticleSystem<Void> LASER_BEAM_EFFECT = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)1);
        ClientParticles.spawnPrecise((ParticleOptions)ParticleTypes.SMALL_FLAME, (Level)world, (Vec3)pos, (double)0.4, (double)0.3, (double)0.4);
    });
    public static final ParticleSystem<Void> PARTICLE_MOVING = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawnPrecise((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (Level)world, (Vec3)pos, (double)0.2, (double)0.3, (double)0.2));

    private static void spawnCubeOutline(ParticleOptions particle, Vec3 origin, float size, int duration, int segments) {
        ParticleContent.spawnLineInner(particle, origin, origin.add((double)size, 0.0, 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add((double)size, 0.0, 0.0), origin.add((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.add(0.0, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add(0.0, 0.0, (double)size), origin.add((double)size, 0.0, (double)size), segments, duration);
        origin = origin.add(0.0, (double)size, 0.0);
        ParticleContent.spawnLineInner(particle, origin, origin.add((double)size, 0.0, 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add((double)size, 0.0, 0.0), origin.add((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.add(0.0, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add(0.0, 0.0, (double)size), origin.add((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.add(0.0, (double)(-size), 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add((double)size, 0.0, 0.0), origin.add((double)size, (double)(-size), 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add(0.0, 0.0, (double)size), origin.add(0.0, (double)(-size), (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.add((double)size, 0.0, (double)size), origin.add((double)size, (double)(-size), (double)size), segments, duration);
    }

    private static void spawnLineInner(ParticleOptions particle, Vec3 start, Vec3 end, float particleCount, int duration) {
        Vec3 increment = end.subtract(start).scale((double)(1.0f / particleCount));
        int i = 0;
        while ((float)i < particleCount) {
            ClientParticles.spawnWithMaxAge((ParticleOptions)particle, (Vec3)start, (int)duration);
            start = start.add(increment);
            ++i;
        }
    }

    public static void registerParticles() {
        Oritech.LOGGER.debug("Registering Oritech particles");
    }

    public record LineData(Vec3 start, Vec3 end) {
    }

    public record SoulParticleData(Vec3 offset, int duration) {
    }
}

