/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleSidedInventory;

public class SmallFluidTankEntity
extends BlockEntity
implements FluidProvider,
InventoryProvider,
ComparatorOutputProvider,
ScreenProvider,
ExtendedScreenHandlerFactory,
BlockEntityTicker<SmallFluidTankEntity> {
    private boolean netDirty = false;
    private int lastComparatorOutput = 0;
    public final boolean isCreative;
    public final SimpleSidedInventory inventory = new SimpleSidedInventory(2, new InventorySlotAssignment(0, 1, 1, 1)){

        public void setChanged() {
            SmallFluidTankEntity.this.setChanged();
        }
    };
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return (long)Oritech.CONFIG.portableTankCapacityBuckets() * 81000L;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            SmallFluidTankEntity.this.setChanged();
        }
    };

    public SmallFluidTankEntity(BlockPos pos, BlockState state, boolean isCreative) {
        super(isCreative ? BlockEntitiesContent.CREATIVE_TANK_ENTITY : BlockEntitiesContent.SMALL_TANK_ENTITY, pos, state);
        this.isCreative = isCreative;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        SingleVariantStorage.writeNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        SingleVariantStorage.readNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
    }

    public void tick(Level world, BlockPos pos, BlockState state, SmallFluidTankEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (world.getGameTime() % 100L == 0L) {
            this.netDirty = true;
        }
        if (this.isCreative) {
            this.fluidStorage.amount = this.fluidStorage.variant != FluidVariant.blank() ? this.fluidStorage.getCapacity() - 81000L : 0L;
        }
        this.processBuckets();
        if ((world.getGameTime() + (long)this.worldPosition.getY()) % 20L == 0L && this.fluidStorage.amount > 0L) {
            this.outputToBelow();
        }
        if (this.netDirty) {
            this.updateComparators(world, pos, state);
            this.updateNetwork();
        }
    }

    private void outputToBelow() {
        if (this.isCreative) {
            return;
        }
        Optional tankCandidate = this.level.getBlockEntity(this.worldPosition.below(), BlockEntitiesContent.SMALL_TANK_ENTITY);
        if (tankCandidate.isEmpty()) {
            return;
        }
        SmallFluidTankEntity belowTank = (SmallFluidTankEntity)tankCandidate.get();
        SingleVariantStorage<FluidVariant> ownTank = this.fluidStorage;
        SingleVariantStorage<FluidVariant> targetTank = belowTank.fluidStorage;
        try (Transaction tx = Transaction.openOuter();){
            long transferAmount = targetTank.insert((TransferVariant)((FluidVariant)ownTank.variant), ownTank.amount, (TransactionContext)tx);
            long extracted = ownTank.extract((TransferVariant)((FluidVariant)ownTank.variant), transferAmount, (TransactionContext)tx);
            if (transferAmount > 0L && transferAmount == extracted) {
                tx.commit();
            }
        }
    }

    private void updateComparators(Level world, BlockPos pos, BlockState state) {
        int previous = this.lastComparatorOutput;
        this.lastComparatorOutput = this.getComparatorOutput();
        if (previous != this.lastComparatorOutput) {
            world.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    private void processBuckets() {
        Item filledBucket2;
        ItemStack inStack = this.inventory.getItem(0);
        if (!inStack.isEmpty() && inStack.is(Items.BUCKET) && this.fluidStorage.amount >= 81000L && this.fluidStorage.variant != FluidVariant.blank()) {
            ItemStack filledBucket2 = ItemVariant.of((ItemLike)((FluidVariant)this.fluidStorage.variant).getFluid().getBucket(), (DataComponentPatch)inStack.getComponentsPatch()).toStack();
            if (!this.outputCanAcceptBucket(filledBucket2)) {
                return;
            }
            if (filledBucket2 == null) {
                return;
            }
            try (Transaction tx = Transaction.openOuter();){
                long extracted = this.fluidStorage.extract((TransferVariant)((FluidVariant)this.fluidStorage.getResource()), 81000L, (TransactionContext)tx);
                if (extracted != 81000L) {
                    return;
                }
                inStack.shrink(1);
                if (this.inventory.getItem(1).isEmpty()) {
                    this.inventory.items.set(1, (Object)filledBucket2);
                } else {
                    this.inventory.getItem(1).grow(1);
                }
                this.inventory.items.set(0, (Object)inStack);
                tx.commit();
            }
        }
        if (inStack != ItemStack.EMPTY && (filledBucket2 = inStack.getItem()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)filledBucket2;
            ItemStack emptyBucket = ItemVariant.of((ItemLike)Items.BUCKET, (DataComponentPatch)inStack.getComponentsPatch()).toStack();
            if (!this.outputCanAcceptBucket(emptyBucket)) {
                return;
            }
            Fluid bucketFluid = bucketItem.arch$getFluid();
            if (bucketFluid == Fluids.EMPTY) {
                return;
            }
            try (Transaction tx = Transaction.openOuter();){
                long inserted = this.fluidStorage.insert((TransferVariant)FluidVariant.of((Fluid)bucketFluid), 81000L, (TransactionContext)tx);
                if (inserted != 81000L) {
                    return;
                }
                inStack.shrink(1);
                if (this.inventory.getItem(1).isEmpty()) {
                    this.inventory.items.set(1, (Object)emptyBucket);
                } else {
                    this.inventory.getItem(1).grow(1);
                }
                this.inventory.items.set(0, (Object)inStack);
                tx.commit();
            }
            this.setChanged();
        }
    }

    private void updateNetwork() {
        this.netDirty = false;
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.SingleVariantFluidSyncPacket(this.worldPosition, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.fluidStorage.variant).getFluid()).toString(), this.fluidStorage.amount));
    }

    private boolean outputCanAcceptBucket(ItemStack bucket) {
        ItemStack slot = this.inventory.getItem(1);
        return slot.isEmpty() || slot.isStackable() && ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)bucket) && slot.getCount() < slot.getMaxStackSize();
    }

    @Override
    public int getComparatorOutput() {
        if (this.fluidStorage.isResourceBlank()) {
            return 0;
        }
        float fillPercentage = (float)this.fluidStorage.amount / (float)this.fluidStorage.getCapacity();
        return (int)(1.0f + fillPercentage * 14.0f);
    }

    public void setChanged() {
        super.setChanged();
        this.netDirty = true;
        if (this.level != null) {
            BlockState blockState = this.level.getBlockState(this.getBlockPos());
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue((Property)SmallFluidTank.LIT, (Comparable)Boolean.valueOf(this.isGlowingFluid())));
        }
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        this.setChanged();
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return InventoryStorage.of((Container)this.inventory, (Direction)direction);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 40), new ScreenProvider.GuiSlot(1, 100, 40, true));
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(70, 18, 21, 60);
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.TANK_SCREEN;
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }

    public boolean isGlowingFluid() {
        return this.fluidStorage.amount > 0L && ((FluidVariant)this.fluidStorage.variant).isOf((Object)Fluids.LAVA);
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        return this.fluidStorage;
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
}

