/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.reactor.BaseReactorBlock;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorEnergyPortBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRedstonePortBlock;
import rearth.oritech.block.blocks.reactor.ReactorReflectorBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.blocks.reactor.ReactorWallBlock;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.ReactorScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;

public class ReactorControllerBlockEntity
extends BlockEntity
implements BlockEntityTicker<ReactorControllerBlockEntity>,
EnergyApi.BlockProvider,
ExtendedScreenHandlerFactory {
    public static final int MAX_SIZE = Oritech.CONFIG.maxSize();
    public static final int RF_PER_PULSE = Oritech.CONFIG.rfPerPulse();
    public static final int ABSORBER_RATE = Oritech.CONFIG.absorberRate();
    public static final int VENT_BASE_RATE = Oritech.CONFIG.ventBaseRate();
    public static final int VENT_RELATIVE_RATE = Oritech.CONFIG.ventRelativeRate();
    public static final int MAX_HEAT = Oritech.CONFIG.maxHeat();
    public static final int MAX_UNSTABLE_TICKS = Oritech.CONFIG.maxUnstableTicks();
    private final HashMap<Vector2i, BaseReactorBlock> activeComponents = new HashMap();
    private final HashMap<Vector2i, ReactorFuelPortEntity> fuelPorts = new HashMap();
    private final HashMap<Vector2i, ReactorAbsorberPortEntity> absorberPorts = new HashMap();
    private final HashMap<Vector2i, Integer> componentHeats = new HashMap();
    private final HashMap<Vector2i, ComponentStatistics> componentStats = new HashMap();
    private final HashSet<Tuple<BlockPos, Direction>> energyPorts = new HashSet();
    private final HashSet<BlockPos> redstonePorts = new HashSet();
    public SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(0L, Oritech.CONFIG.reactorMaxEnergyStored(), Oritech.CONFIG.reactorMaxEnergyStored(), () -> ((ReactorControllerBlockEntity)this).setChanged());
    public boolean active = false;
    private int reactorStackHeight;
    private BlockPos areaMin;
    private BlockPos areaMax;
    private boolean disabledViaRedstone = false;
    private int unstableTicks = 0;
    public long disabledUntil = 0L;
    private boolean doAutoInit = false;
    public NetworkContent.ReactorUIDataPacket uiData;
    public NetworkContent.ReactorUISyncPacket uiSyncData;

    public ReactorControllerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REACTOR_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, ReactorControllerBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (!this.active && this.doAutoInit) {
            this.doAutoInit = false;
            this.init(null);
        }
        if (!this.active || this.activeComponents.isEmpty()) {
            return;
        }
        int activeRods = 0;
        int hottestHeat = 0;
        for (Vector2i localPos : this.activeComponents.keySet()) {
            BaseReactorBlock component = this.activeComponents.get(localPos);
            Integer componentHeat = this.componentHeats.get(localPos);
            if (component instanceof ReactorRodBlock) {
                ReactorRodBlock rodBlock = (ReactorRodBlock)component;
                int ownRodCount = rodBlock.getRodCount();
                int receivedPulses = rodBlock.getInternalPulseCount();
                ReactorFuelPortEntity portEntity = this.fuelPorts.get(localPos);
                if (portEntity == null || portEntity.isRemoved()) continue;
                boolean hasFuel = portEntity.tryConsumeFuel(ownRodCount * this.reactorStackHeight, this.isDisabled() || this.disabledViaRedstone);
                int heatCreated = 0;
                this.setRodBlockState(localPos, hasFuel);
                if (hasFuel) {
                    for (Vector2i neighborPos : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                        BaseReactorBlock neighbor = this.activeComponents.get(neighborPos);
                        if (neighbor instanceof ReactorRodBlock) {
                            ReactorRodBlock neighborRod = (ReactorRodBlock)neighbor;
                            receivedPulses += neighborRod.getRodCount();
                            continue;
                        }
                        if (!(neighbor instanceof ReactorReflectorBlock)) continue;
                        ReactorReflectorBlock reflectorBlock = (ReactorReflectorBlock)neighbor;
                        receivedPulses += rodBlock.getRodCount();
                    }
                    if (!this.isDisabled()) {
                        ++activeRods;
                        this.energyStorage.insertIgnoringLimit(RF_PER_PULSE * receivedPulses * this.reactorStackHeight, false);
                    }
                    heatCreated = receivedPulses / 2 * receivedPulses + 4;
                    if ((double)(componentHeat = Integer.valueOf(componentHeat + heatCreated)).intValue() > (double)MAX_HEAT * 0.85) {
                        this.playMeltdownAnimation(portEntity.getBlockPos());
                    }
                } else {
                    receivedPulses = 0;
                }
                this.componentStats.put(localPos, new ComponentStatistics((short)receivedPulses, componentHeat, (short)heatCreated));
            } else if (component instanceof ReactorHeatPipeBlock) {
                ReactorHeatPipeBlock heatPipeBlock = (ReactorHeatPipeBlock)component;
                int sumGainedHeat = 0;
                for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                    Integer neighborHeat = this.componentHeats.get(neighbor);
                    if (neighborHeat <= componentHeat) continue;
                    int diff = neighborHeat - componentHeat;
                    int gainedHeat = Math.min(diff / 4 + 10, diff);
                    neighborHeat = neighborHeat - gainedHeat;
                    this.componentHeats.put(neighbor, neighborHeat);
                    componentHeat = componentHeat + gainedHeat;
                    sumGainedHeat += gainedHeat;
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, componentHeat, (short)sumGainedHeat));
            } else if (component instanceof ReactorAbsorberBlock) {
                ReactorAbsorberBlock absorberBlock = (ReactorAbsorberBlock)component;
                int sumRemovedHeat = 0;
                ReactorAbsorberPortEntity portEntity = this.absorberPorts.get(localPos);
                if (portEntity == null || portEntity.isRemoved()) continue;
                int fuelAvailable = portEntity.getAvailableFuel();
                if (fuelAvailable >= this.reactorStackHeight) {
                    for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                        Integer neighborHeat = this.componentHeats.get(neighbor);
                        if (neighborHeat <= 0) continue;
                        neighborHeat = neighborHeat - ABSORBER_RATE;
                        sumRemovedHeat += ABSORBER_RATE;
                        this.componentHeats.put(neighbor, neighborHeat);
                    }
                } else if (fuelAvailable > 0) {
                    portEntity.consumeFuel(fuelAvailable);
                }
                if (sumRemovedHeat > 0) {
                    portEntity.consumeFuel(this.reactorStackHeight);
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, 0, (short)sumRemovedHeat));
            } else if (component instanceof ReactorHeatVentBlock) {
                ReactorHeatVentBlock ventBlock = (ReactorHeatVentBlock)component;
                Vector2i hottestPos = localPos;
                int max = 0;
                for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                    Integer neighborHeat = this.componentHeats.get(neighbor);
                    if (neighborHeat <= max) continue;
                    hottestPos = neighbor;
                    max = neighborHeat;
                }
                int removed = 0;
                if (max != 0) {
                    int neighborHeat = max;
                    removed = Math.min(neighborHeat / VENT_RELATIVE_RATE + VENT_BASE_RATE, neighborHeat);
                    this.componentHeats.put(hottestPos, neighborHeat -= removed);
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, 0, (short)removed));
            }
            this.componentHeats.put(localPos, componentHeat);
            if (componentHeat <= hottestHeat) continue;
            hottestHeat = componentHeat;
        }
        this.outputEnergy();
        this.updateRedstonePorts(hottestHeat, activeRods);
        if (activeRods > 0) {
            this.playAmbientSound();
        }
        if (activeRods > 0 && (float)hottestHeat > (float)MAX_HEAT * 0.8f) {
            this.playWarningSound();
        }
        if (hottestHeat > MAX_HEAT && activeRods > 0) {
            ++this.unstableTicks;
            if (this.unstableTicks > MAX_UNSTABLE_TICKS) {
                this.doReactorExplosion(activeRods * this.reactorStackHeight);
            }
        } else {
            this.unstableTicks = 0;
        }
        if (world.getGameTime() % 2L == 0L) {
            this.sendUINetworkData();
        }
    }

    private boolean isDisabled() {
        return this.level.getGameTime() < this.disabledUntil;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.getAmount());
        nbt.putBoolean("was_active", this.active);
        nbt.putBoolean("redstone_disabled", this.disabledViaRedstone);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy_stored"));
        this.doAutoInit = nbt.getBoolean("was_active");
        this.disabledViaRedstone = nbt.getBoolean("redstone_disabled");
    }

    private void playMeltdownAnimation(BlockPos port) {
        ParticleContent.MELTDOWN_IMMINENT.spawn(this.level, port.getCenter().add(0.0, 0.3, 0.0), (Object)5);
    }

    private void playAmbientSound() {
        int soundDuration = 250;
        if (this.level.getGameTime() % (long)soundDuration == 0L) {
            this.level.playSound(null, this.worldPosition, SoundContent.REACTOR, SoundSource.BLOCKS, 0.7f, 0.8f);
        }
    }

    private void playWarningSound() {
        int soundDuration = 50;
        if (this.level.getGameTime() % (long)soundDuration == 0L) {
            this.level.playSound(null, this.worldPosition, SoundContent.REACTOR_WARNING, SoundSource.BLOCKS, 4.0f, 0.8f);
        }
    }

    private void doReactorExplosion(int strength) {
        if (Oritech.CONFIG.safeMode()) {
            this.disableReactor();
            return;
        }
        Block spawnedBlock = BlockContent.REACTOR_EXPLOSION_SMALL;
        if (strength > 8 && strength <= 25) {
            spawnedBlock = BlockContent.REACTOR_EXPLOSION_MEDIUM;
        } else if (strength > 25) {
            spawnedBlock = BlockContent.REACTOR_EXPLOSION_LARGE;
        }
        this.level.setBlockAndUpdate(this.worldPosition, spawnedBlock.defaultBlockState());
    }

    private void disableReactor() {
        this.disabledUntil = this.level.getGameTime() + (long)Oritech.CONFIG.safeModeCooldown();
    }

    public void init(@Nullable Player player) {
        this.active = false;
        BlockPos cornerA = this.worldPosition;
        cornerA = this.expandWall(cornerA, new Vec3i(0, -1, 0), true);
        cornerA = this.expandWall(cornerA, new Vec3i(0, 0, -1));
        cornerA = this.expandWall(cornerA, new Vec3i(-1, 0, 0));
        BlockPos cornerB = cornerA = this.expandWall(cornerA, new Vec3i(0, 0, -1));
        cornerB = this.expandWall(cornerB, new Vec3i(0, 1, 0));
        cornerB = this.expandWall(cornerB, new Vec3i(0, 0, 1));
        cornerB = this.expandWall(cornerB, new Vec3i(1, 0, 0));
        if (cornerA == this.worldPosition || cornerB == this.worldPosition || cornerA == cornerB || ReactorControllerBlockEntity.onSameAxis(cornerA, cornerB)) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.reactor_edge_invalid"));
            }
            return;
        }
        BlockPos finalCornerA = cornerA;
        BlockPos finalCornerB = cornerB;
        this.energyPorts.clear();
        this.redstonePorts.clear();
        boolean wallsValid = BlockPos.betweenClosedStream((BlockPos)cornerA, (BlockPos)cornerB).allMatch(pos -> {
            if (ReactorControllerBlockEntity.isAtEdgeOfBox(pos, finalCornerA, finalCornerB)) {
                Block block = this.level.getBlockState(pos).getBlock();
                return block instanceof ReactorWallBlock;
            }
            if (ReactorControllerBlockEntity.isOnWall(pos, finalCornerA, finalCornerB)) {
                BaseReactorBlock reactorBlock;
                BlockState state = this.level.getBlockState(pos);
                Block block = state.getBlock();
                if (block instanceof ReactorEnergyPortBlock) {
                    Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                    BlockPos blockInFront = pos.offset(Geometry.getForward(facing));
                    this.energyPorts.add((Tuple<BlockPos, Direction>)new Tuple((Object)blockInFront, (Object)Direction.fromDelta((int)Geometry.getBackward(facing).getX(), (int)Geometry.getBackward(facing).getY(), (int)Geometry.getBackward(facing).getZ())));
                } else if (block instanceof ReactorRedstonePortBlock) {
                    this.redstonePorts.add(pos.immutable());
                }
                return !(block instanceof BaseReactorBlock) || (reactorBlock = (BaseReactorBlock)block).validForWalls();
            }
            return true;
        });
        if (!wallsValid) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.reactor_wall_invalid"));
            }
            return;
        }
        int interiorHeight = cornerB.getY() - cornerA.getY() - 1;
        BlockPos cornerAFlat = cornerA.offset(1, 1, 1);
        BlockPos cornerBFlat = new BlockPos(cornerB.getX() - 1, cornerA.getY() + 1, cornerB.getZ() - 1);
        this.fuelPorts.clear();
        this.absorberPorts.clear();
        this.reactorStackHeight = interiorHeight;
        boolean interiorStackedRight = BlockPos.betweenClosedStream((BlockPos)cornerAFlat, (BlockPos)cornerBFlat).allMatch(pos -> {
            BlockPos offset = pos.subtract((Vec3i)cornerAFlat);
            Vector2i localPos = new Vector2i(offset.getX(), offset.getZ());
            Block block = this.level.getBlockState(pos).getBlock();
            if (!(block instanceof BaseReactorBlock)) {
                return true;
            }
            BaseReactorBlock reactorBlock = (BaseReactorBlock)block;
            for (int i = 1; i < interiorHeight; ++i) {
                BlockPos candidatePos = pos.offset(0, i, 0);
                BlockState candidate = this.level.getBlockState(candidatePos);
                if (candidate.getBlock().equals(block)) continue;
                return false;
            }
            Block requiredCeiling = reactorBlock.requiredStackCeiling();
            if (requiredCeiling != Blocks.AIR) {
                BlockPos ceilingPos = pos.offset(0, interiorHeight, 0);
                Block ceilingBlock = this.level.getBlockState(ceilingPos).getBlock();
                if (!requiredCeiling.equals(ceilingBlock)) {
                    return false;
                }
                if (block instanceof ReactorRodBlock) {
                    this.fuelPorts.put(localPos, (ReactorFuelPortEntity)this.level.getBlockEntity(ceilingPos));
                } else if (block instanceof ReactorAbsorberBlock) {
                    this.absorberPorts.put(localPos, (ReactorAbsorberPortEntity)this.level.getBlockEntity(ceilingPos));
                }
            }
            this.activeComponents.put(localPos, reactorBlock);
            this.componentHeats.putIfAbsent(localPos, 0);
            return true;
        });
        if (!interiorStackedRight) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.reactor_interior_issues"));
            }
            return;
        }
        this.areaMin = finalCornerA;
        this.areaMax = finalCornerB;
        this.active = true;
    }

    private void setRodBlockState(Vector2i localPos, boolean on) {
        if (this.level.getGameTime() % 10L != 0L) {
            return;
        }
        BlockPos stackTop = this.fuelPorts.get(localPos).getBlockPos();
        for (int i = 1; i <= this.reactorStackHeight; ++i) {
            Boolean oldLit;
            BlockPos candidatePos = stackTop.below(i);
            BlockState candidateState = this.level.getBlockState(candidatePos);
            if (!(candidateState.getBlock() instanceof ReactorRodBlock) || (oldLit = (Boolean)candidateState.getValue((Property)BlockStateProperties.LIT)) == on) continue;
            this.level.setBlock(candidatePos, (BlockState)candidateState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(on)), 2, 0);
        }
    }

    private static Set<Vector2i> getNeighborsInBounds(Vector2i pos, Set<Vector2i> keys) {
        Vector2i d;
        Vector2i c;
        Vector2i b;
        HashSet<Vector2i> res = new HashSet<Vector2i>(4);
        Vector2i a = new Vector2i((Vector2ic)pos).add(-1, 0);
        if (keys.contains(a)) {
            res.add(a);
        }
        if (keys.contains(b = new Vector2i((Vector2ic)pos).add(0, 1))) {
            res.add(b);
        }
        if (keys.contains(c = new Vector2i((Vector2ic)pos).add(1, 0))) {
            res.add(c);
        }
        if (keys.contains(d = new Vector2i((Vector2ic)pos).add(0, -1))) {
            res.add(d);
        }
        return res;
    }

    private static boolean onSameAxis(BlockPos A, BlockPos B) {
        return A.getX() == B.getX() || A.getY() == B.getY() || A.getZ() == B.getZ();
    }

    private static boolean isOnWall(BlockPos pos, BlockPos min, BlockPos max) {
        return ReactorControllerBlockEntity.onSameAxis(pos, min) || ReactorControllerBlockEntity.onSameAxis(pos, max);
    }

    private static boolean isAtEdgeOfBox(BlockPos pos, BlockPos min, BlockPos max) {
        int planesAligned = 0;
        if (pos.getX() == min.getX() || pos.getX() == max.getX()) {
            ++planesAligned;
        }
        if (pos.getY() == min.getY() || pos.getY() == max.getY()) {
            ++planesAligned;
        }
        if (pos.getZ() == min.getZ() || pos.getZ() == max.getZ()) {
            ++planesAligned;
        }
        return planesAligned >= 2;
    }

    private BlockPos expandWall(BlockPos from, Vec3i direction) {
        return this.expandWall(from, direction, false);
    }

    private BlockPos expandWall(BlockPos from, Vec3i direction, boolean allReactorBlocks) {
        BlockPos result = from;
        for (int i = 1; i < MAX_SIZE; ++i) {
            BlockPos candidate = from.offset(direction.multiply(i));
            Block candidateBlock = this.level.getBlockState(candidate).getBlock();
            if (!allReactorBlocks && !(candidateBlock instanceof ReactorWallBlock)) {
                return result;
            }
            if (allReactorBlocks && !(candidateBlock instanceof BaseReactorBlock)) {
                return result;
            }
            result = candidate;
        }
        return result;
    }

    private void updateRedstonePorts(int hottestTemp, int filledRods) {
        this.disabledViaRedstone = false;
        for (BlockPos pos : this.redstonePorts) {
            BlockState state = this.level.getBlockState(pos);
            if (!state.getBlock().equals(BlockContent.REACTOR_REDSTONE_PORT)) continue;
            int resOutput = 0;
            Integer mode = (Integer)state.getValue((Property)ReactorRedstonePortBlock.PORT_MODE);
            if (mode == 0 && hottestTemp > 0) {
                resOutput = (int)((float)hottestTemp / (float)MAX_HEAT * 15.0f);
                resOutput = Math.max(resOutput, 1);
            } else if (mode == 1) {
                resOutput = Math.min(filledRods, 15);
            } else if (mode == 2 && this.energyStorage.getAmount() > 0L) {
                float fillPercentage = (float)this.energyStorage.getAmount() / (float)this.energyStorage.getCapacity();
                resOutput = (int)(1.0f + fillPercentage * 14.0f);
            }
            resOutput = Math.min(resOutput, 15);
            Integer lastLevel = (Integer)state.getValue((Property)BlockStateProperties.POWER);
            if (lastLevel != resOutput) {
                this.level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(resOutput)));
                this.level.blockEntityChanged(pos);
            }
            if (!this.level.hasNeighborSignal(pos)) continue;
            this.disabledViaRedstone = true;
        }
    }

    private void outputEnergy() {
        int totalMoved = 0;
        int maxRatePerSlot = Oritech.CONFIG.reactorMaxEnergyOutput();
        ArrayList<Tuple<BlockPos, Direction>> randomOrderedList = new ArrayList<Tuple<BlockPos, Direction>>(this.energyPorts);
        Collections.shuffle(randomOrderedList);
        for (Tuple<BlockPos, Direction> candidateData : randomOrderedList) {
            EnergyApi.EnergyContainer candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)candidateData.getA(), (Direction)candidateData.getB());
            if (candidate == null) continue;
            Long moved = EnergyApi.transfer(this.energyStorage, candidate, maxRatePerSlot, false);
            if (moved > 0L) {
                candidate.update();
            }
            totalMoved = (int)((long)totalMoved + moved);
        }
        if (totalMoved > 0) {
            this.energyStorage.update();
        }
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    private void sendUINetworkData() {
        if (!this.active || this.activeComponents.isEmpty() || !this.isActivelyViewed()) {
            return;
        }
        for (ReactorFuelPortEntity reactorFuelPortEntity : this.fuelPorts.values()) {
            reactorFuelPortEntity.updateNetwork();
        }
        for (ReactorAbsorberPortEntity reactorAbsorberPortEntity : this.absorberPorts.values()) {
            reactorAbsorberPortEntity.updateNetwork();
        }
        Set<Vector2i> positionsFlat = this.activeComponents.keySet();
        List<BlockPos> list = positionsFlat.stream().map(pos -> this.areaMin.offset(pos.x + 1, 1, pos.y + 1)).toList();
        List<ComponentStatistics> heats = positionsFlat.stream().map(pos -> this.componentStats.getOrDefault(pos, ComponentStatistics.EMPTY)).toList();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.ReactorUISyncPacket(this.worldPosition, list, heats, this.energyStorage.getAmount()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isActivelyViewed() {
        Player closestPlayer = Objects.requireNonNull(this.level).getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false);
        if (closestPlayer == null) return false;
        AbstractContainerMenu abstractContainerMenu = closestPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof ReactorScreenHandler)) return false;
        ReactorScreenHandler handler = (ReactorScreenHandler)abstractContainerMenu;
        if (!this.getBlockPos().equals((Object)handler.reactorEntity.worldPosition)) return false;
        return true;
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        BlockPos previewMax = new BlockPos(this.areaMax.getX(), this.areaMin.getY() + 1, this.areaMax.getZ());
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.ReactorUIDataPacket(this.worldPosition, this.areaMin, this.areaMax, previewMax));
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new ReactorScreenHandler(syncId, playerInventory, this);
    }

    public record ComponentStatistics(short receivedPulses, int storedHeat, short heatChanged) {
        public static final ComponentStatistics EMPTY = new ComponentStatistics(0, -1, 0);
    }
}

