/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleSidedInventory;

public class ReactorAbsorberPortEntity
extends BlockEntity
implements ExtendedScreenHandlerFactory,
ScreenProvider,
InventoryProvider {
    private final SimpleSidedInventory inventory = new SimpleSidedInventory(1, new InventorySlotAssignment(0, 1, 1, 0));
    private final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
    public int availableFuel;
    public int currentFuelOriginalCapacity;

    public ReactorAbsorberPortEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REACTOR_ABSORBER_PORT_BLOCK_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("available", this.availableFuel);
        nbt.putInt("capacity", this.currentFuelOriginalCapacity);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.availableFuel = nbt.getInt("available");
        this.currentFuelOriginalCapacity = nbt.getInt("capacity");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
    }

    public int getAvailableFuel() {
        if (this.availableFuel > 0) {
            return this.availableFuel;
        }
        ItemStack inputStack = this.inventory.getItem(0);
        if (inputStack.isEmpty()) {
            return 0;
        }
        if (inputStack.is(TagContent.REACTOR_COOLANT)) {
            int capacity;
            this.currentFuelOriginalCapacity = capacity = 1000;
            this.availableFuel = capacity;
            inputStack.shrink(1);
            this.onFuelConsumed();
        }
        return this.availableFuel;
    }

    public void consumeFuel(int amount) {
        if (this.availableFuel >= amount) {
            this.availableFuel -= amount;
            if (this.level.getGameTime() % 5L == 0L) {
                ParticleContent.COOLER_WORKING.spawn(this.level, this.worldPosition.getCenter().add(0.0, 0.5, 0.0), (Object)1);
            }
        }
    }

    private void onFuelConsumed() {
        ParticleContent.COOLER_WORKING.spawn(this.level, this.worldPosition.getCenter().add(0.0, 0.5, 0.0), (Object)15);
    }

    public void updateNetwork() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.ReactorPortDataPacket(this.worldPosition, this.currentFuelOriginalCapacity, this.availableFuel));
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 80, 35));
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.FUEL_PORT_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }
}

