/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class CoolerBlockEntity
extends MultiblockMachineEntity
implements FluidProvider {
    private boolean inColdArea;
    private boolean initialized = false;
    public final SingleVariantStorage<FluidVariant> inputTank = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 324000L;
        }

        public boolean supportsExtraction() {
            return false;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            CoolerBlockEntity.this.setChanged();
        }
    };

    public CoolerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.COOLER_ENTITY, pos, state, Oritech.CONFIG.processingMachines.coolerData.energyPerTick());
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!world.isClientSide && !this.initialized) {
            this.initialized = true;
            Holder biome = world.getBiome(pos);
            this.inColdArea = biome.is(ConventionalBiomeTags.IS_COLD);
        }
    }

    @Override
    public MachineAddonController.AddonUiData getUiData() {
        MachineAddonController.AddonUiData base = super.getUiData();
        if (!this.inColdArea) {
            return base;
        }
        return new MachineAddonController.AddonUiData(base.positions(), base.openSlots(), base.efficiency() * 0.5f, base.speed() * 0.5f, base.ownPosition(), base.extraChambers());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        CompoundTag inNbt = new CompoundTag();
        SingleVariantStorage.writeNbt(this.inputTank, (Codec)FluidVariant.CODEC, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
        nbt.put("inputStorage", (Tag)inNbt);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        CompoundTag inNbt = nbt.getCompound("inputStorage");
        SingleVariantStorage.readNbt(this.inputTank, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected void sendNetworkEntry() {
        super.sendNetworkEntry();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.SingleVariantFluidSyncPacket(this.worldPosition, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.inputTank.variant).getFluid()).toString(), this.inputTank.amount));
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        float progress = this.getProgress();
        if ((double)progress < 0.35 || (double)progress > 0.65) {
            return;
        }
        if ((double)this.level.random.nextFloat() > 0.4) {
            return;
        }
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition);
        ParticleContent.COOLER_WORKING.spawn(this.level, emitPosition, (Object)2);
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        List candidates = Objects.requireNonNull(this.level).getRecipeManager().getRecipesFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
        Optional<RecipeHolder<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeMatchesTank(this.inputTank, (OritechRecipe)candidate.value())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return super.getRecipe();
    }

    @Override
    protected boolean canProceed(OritechRecipe value) {
        return super.canProceed(value) && CentrifugeBlockEntity.recipeMatchesTank(this.inputTank, value);
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        FluidStack input = activeRecipe.getFluidInput();
        try (Transaction tx = Transaction.openOuter();){
            if (input != null && input.getAmount() > 0L) {
                this.inputTank.extract((TransferVariant)FluidVariant.of((Fluid)input.getFluid()), input.getAmount(), (TransactionContext)tx);
            }
            tx.commit();
        }
    }

    @Override
    public float getSpeedMultiplier() {
        float biomeBonus = this.inColdArea ? 0.5f : 1.0f;
        return super.getSpeedMultiplier() * biomeBonus;
    }

    @Override
    public float getEfficiencyMultiplier() {
        float biomeBonus = this.inColdArea ? 0.5f : 1.0f;
        return super.getEfficiencyMultiplier() * biomeBonus;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.coolerData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.coolerData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.COOLER;
    }

    @Override
    public InventorySlotAssignment getSlots() {
        return new InventorySlotAssignment(0, 0, 0, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 36, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.COOLER_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 1;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, -1));
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -2));
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.inputTank;
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        return this.inputTank;
    }
}

