/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.CentrifugeScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class CentrifugeBlockEntity
extends MultiblockMachineEntity
implements FluidProvider {
    public static final long CAPACITY = Oritech.CONFIG.processingMachines.centrifugeData.tankSizeInBuckets() * 81000L;
    public final SingleVariantStorage<FluidVariant> inputStorage = this.createBasicTank();
    public final SingleVariantStorage<FluidVariant> outputStorage = this.createBasicTank();
    private final Storage<FluidVariant> exposedInput = FilteringStorage.insertOnlyOf(this.inputStorage);
    private final Storage<FluidVariant> exposedOutput = FilteringStorage.extractOnlyOf(this.outputStorage);
    private final Storage<FluidVariant> combinedTanks = new CombinedStorage(List.of(this.exposedInput, this.exposedOutput));
    public boolean hasFluidAddon = false;
    public final SimpleContainer bucketInventory = new SimpleContainer(2){

        public void setChanged() {
            CentrifugeBlockEntity.this.setChanged();
        }

        public boolean canAddItem(ItemStack stack) {
            System.out.println(stack);
            return stack.getItem() instanceof BucketItem;
        }
    };
    public final InventoryStorage bucketStorage = InventoryStorage.of((Container)this.bucketInventory, null);

    public CentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.CENTRIFUGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.centrifugeData.energyPerTick());
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.centrifugeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.centrifugeData.maxEnergyInsertion();
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        if (this.hasFluidAddon && !world.isClientSide) {
            ItemStack bucketIn = this.bucketInventory.getItem(0);
            ItemStack bucketOut = this.bucketInventory.getItem(1);
            this.processBucket(bucketIn, bucketOut, this.inputStorage, this.outputStorage);
        }
        FluidMultiblockGeneratorBlockEntity.resetEmptyFluidTank(this.inputStorage);
        super.tick(world, pos, state, blockEntity);
    }

    private void processBucket(ItemStack inStack, ItemStack outStack, SingleVariantStorage<FluidVariant> inStorage, SingleVariantStorage<FluidVariant> outStorage) {
        if (inStack != ItemStack.EMPTY && inStack.getItem().equals(Items.BUCKET) && outStorage.amount >= 81000L && outStack == ItemStack.EMPTY) {
            Item filledBucketType = ((FluidVariant)outStorage.variant).getFluid().getBucket();
            if (filledBucketType == null) {
                return;
            }
            inStack.shrink(1);
            this.bucketInventory.items.set(1, (Object)new ItemStack((ItemLike)filledBucketType));
            this.bucketInventory.items.set(0, (Object)inStack);
            outStorage.amount -= 81000L;
            this.setChanged();
            this.markNetDirty();
        } else if (inStack != ItemStack.EMPTY && inStack.getItem() instanceof BucketItem && !inStack.getItem().equals(Items.BUCKET) && this.outputCanAcceptBucket(outStack)) {
            Storage context = (Storage)ContainerItemContext.ofSingleSlot((SingleSlotStorage)this.bucketStorage.getSlot(0)).find(FluidStorage.ITEM);
            if (context == null) {
                return;
            }
            FluidVariant variant = (FluidVariant)((StorageView)context.iterator().next()).getResource();
            if (variant == null) {
                return;
            }
            boolean bucketUsed = false;
            if (((FluidVariant)inStorage.variant).isOf((Object)variant.getFluid()) && inStorage.amount + 81000L <= inStorage.getCapacity()) {
                bucketUsed = true;
                inStorage.amount += 81000L;
            } else if (inStorage.amount == 0L) {
                inStorage.variant = variant;
                inStorage.amount = 81000L;
                bucketUsed = true;
            }
            if (bucketUsed) {
                this.bucketInventory.setItem(0, ItemStack.EMPTY);
                int bucketCount = this.bucketInventory.getItem(1).getCount();
                this.bucketInventory.setItem(1, new ItemStack((ItemLike)Items.BUCKET, bucketCount + 1));
            }
            this.setChanged();
            this.markNetDirty();
        }
    }

    private boolean outputCanAcceptBucket(ItemStack slot) {
        if (slot == null) {
            return true;
        }
        if (slot.isEmpty()) {
            return true;
        }
        return slot.getItem().equals(Items.BUCKET) && slot.getCount() < slot.getMaxStackSize();
    }

    @Override
    protected boolean canProceed(OritechRecipe recipe) {
        if (!this.hasFluidAddon) {
            return super.canProceed(recipe);
        }
        boolean itemsMatch = super.canProceed(recipe);
        if (!itemsMatch) {
            return false;
        }
        FluidStack input = recipe.getFluidInput();
        if (!(input == null || input.getAmount() <= 0L || input.getFluid().equals(((FluidVariant)this.inputStorage.variant).getFluid()) && input.getAmount() <= this.inputStorage.amount)) {
            return false;
        }
        FluidStack output = recipe.getFluidOutput();
        if (output != null && output.getAmount() > 0L) {
            if (output.getFluid().equals(Fluids.EMPTY) || this.outputStorage.amount == 0L) {
                return super.canProceed(recipe);
            }
            if (this.outputStorage.amount + output.getAmount() > this.outputStorage.getCapacity()) {
                return false;
            }
            if (!((FluidVariant)this.outputStorage.variant).getFluid().equals(output.getFluid())) {
                return false;
            }
        }
        return super.canProceed(recipe);
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        if (!this.hasFluidAddon) {
            return super.getRecipe();
        }
        List candidates = Objects.requireNonNull(this.level).getRecipeManager().getRecipesFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
        Optional<RecipeHolder<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeMatchesTank(this.inputStorage, (OritechRecipe)candidate.value())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return this.getNormalRecipe();
    }

    private Optional<RecipeHolder<OritechRecipe>> getNormalRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.CENTRIFUGE, this.getInputInventory(), this.level);
    }

    public static boolean recipeMatchesTank(SingleVariantStorage<FluidVariant> checkedTank, OritechRecipe recipe) {
        Fluid tankFluid;
        boolean recipeNeedsFluid;
        boolean isTankEmpty = checkedTank.isResourceBlank() || checkedTank.amount <= 0L;
        boolean bl = recipeNeedsFluid = recipe.getFluidInput() != null && recipe.getFluidInput().getAmount() > 0L;
        if (!recipeNeedsFluid) {
            return true;
        }
        if (isTankEmpty) {
            return false;
        }
        Fluid recipeFluid = recipe.getFluidInput().getFluid();
        return recipeFluid.equals(tankFluid = ((FluidVariant)checkedTank.variant).getFluid()) && checkedTank.amount >= recipe.getFluidInput().getAmount();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        int chamberCount = this.getBaseAddonData().extraChambers() + 1;
        for (int i = 0; i < chamberCount && this.canOutputRecipe(activeRecipe) && this.canProceed(activeRecipe); ++i) {
            super.craftItem(activeRecipe, outputInventory, inputInventory);
            if (!this.hasFluidAddon) continue;
            this.craftFluids(activeRecipe);
        }
    }

    @Override
    public boolean supportExtraChambersAuto() {
        return false;
    }

    private void craftFluids(OritechRecipe activeRecipe) {
        FluidStack input = activeRecipe.getFluidInput();
        FluidStack output = activeRecipe.getFluidOutput();
        try (Transaction tx = Transaction.openOuter();){
            if (input != null && input.getAmount() > 0L) {
                this.inputStorage.extract((TransferVariant)FluidVariant.of((Fluid)input.getFluid()), input.getAmount(), (TransactionContext)tx);
            }
            if (output != null && output.getAmount() > 0L) {
                this.outputStorage.insert((TransferVariant)FluidVariant.of((Fluid)output.getFluid()), output.getAmount(), (TransactionContext)tx);
            }
            tx.commit();
        }
    }

    @Override
    public void initAddons() {
        super.initAddons();
        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
        this.level.blockUpdated(this.worldPosition.above(), this.level.getBlockState(this.worldPosition.above()).getBlock());
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_FLUID_ADDON)) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasFluidAddon = false;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("fluidAddon", this.hasFluidAddon);
        CompoundTag inNbt = new CompoundTag();
        CompoundTag outNbt = new CompoundTag();
        SingleVariantStorage.writeNbt(this.inputStorage, (Codec)FluidVariant.CODEC, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
        SingleVariantStorage.writeNbt(this.outputStorage, (Codec)FluidVariant.CODEC, (CompoundTag)outNbt, (HolderLookup.Provider)registryLookup);
        CompoundTag bucketStorageNbt = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)bucketStorageNbt, (NonNullList)this.bucketInventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.put("bucket", (Tag)bucketStorageNbt);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasFluidAddon = nbt.getBoolean("fluidAddon");
        CompoundTag inNbt = nbt.getCompound("inputStorage");
        CompoundTag outNbt = nbt.getCompound("outputStorage");
        SingleVariantStorage.readNbt(this.inputStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
        SingleVariantStorage.readNbt(this.outputStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)outNbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("bucket"), (NonNullList)this.bucketInventory.items, (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        if (this.hasFluidAddon) {
            return RecipeContent.CENTRIFUGE_FLUID;
        }
        return RecipeContent.CENTRIFUGE;
    }

    @Override
    public InventorySlotAssignment getSlots() {
        return new InventorySlotAssignment(0, 1, 1, 2);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 113, 38, true), new ScreenProvider.GuiSlot(2, 113, 56, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.CENTRIFUGE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -1), new Vec3i(0, 0, 1));
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new CentrifugeScreenHandler(syncId, playerInventory, this, this.getUiData(), this.getCoreQuality());
    }

    @Override
    public int getAnimationDuration() {
        return 180;
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        if (!this.hasFluidAddon) {
            return null;
        }
        if (direction == null) {
            return this.combinedTanks;
        }
        return switch (direction) {
            case Direction.DOWN -> this.outputStorage;
            case Direction.UP -> this.inputStorage;
            default -> this.combinedTanks;
        };
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        if (!this.hasFluidAddon) {
            return null;
        }
        return this.outputStorage;
    }

    @Override
    protected void sendNetworkEntry() {
        super.sendNetworkEntry();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.CentrifugeFluidSyncPacket(this.worldPosition, this.hasFluidAddon, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.inputStorage.variant).getFluid()).toString(), this.inputStorage.amount, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.outputStorage.variant).getFluid()).toString(), this.outputStorage.amount));
    }

    private SingleVariantStorage<FluidVariant> createBasicTank() {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return CAPACITY;
            }

            protected void onFinalCommit() {
                super.onFinalCommit();
                CentrifugeBlockEntity.this.setChanged();
            }
        };
    }
}

