/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class ItemPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity {
    private static final int TRANSFER_AMOUNT = Oritech.CONFIG.itemPipeTransferAmount();
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.itemPipeIntervalDuration();
    private final HashMap<BlockPos, BlockApiCache<Storage<ItemVariant>, Direction>> lookupCache = new HashMap();
    private List<Tuple<Storage<ItemVariant>, BlockPos>> filteredTargetItemStorages;

    public ItemPipeInterfaceEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ITEM_PIPE_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, GenericPipeInterfaceEntity blockEntity) {
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.getBlock();
        if (world.isClientSide || !block.isExtractable(state)) {
            return;
        }
        if (world.getGameTime() % (long)TRANSFER_PERIOD != 0L && !this.isBoostAvailable()) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = ItemPipeBlock.ITEM_PIPE_DATA.getOrDefault(world.dimension().location(), new GenericPipeInterfaceEntity.PipeNetworkData());
        Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
        ItemStack stackToMove = ItemStack.EMPTY;
        Storage<ItemVariant> moveFromInventory = null;
        int moveCapacity = this.isBoostAvailable() ? 64 : TRANSFER_AMOUNT;
        try (Transaction mainTx = Transaction.openOuter();){
            for (BlockPos sourcePos : sources) {
                ItemStack firstStack;
                Storage<ItemVariant> inventory;
                BlockPos offset = pos.subtract((Vec3i)sourcePos);
                Direction direction = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
                if (!block.isSideExtractable(state, direction.getOpposite()) || (inventory = this.findFromCache(world, sourcePos, direction)) == null || !inventory.supportsExtraction() || (firstStack = ItemPipeInterfaceEntity.getFromStorage(inventory, moveCapacity, mainTx)).isEmpty()) continue;
                stackToMove = firstStack;
                moveFromInventory = inventory;
                break;
            }
            mainTx.abort();
        }
        if (stackToMove.isEmpty()) {
            return;
        }
        Set<Tuple<BlockPos, Direction>> targets = ItemPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.getBlockPos()));
            return;
        }
        int netHash = targets.hashCode();
        if (netHash != this.filteredTargetsNetHash || this.filteredTargetItemStorages == null) {
            this.filteredTargetItemStorages = targets.stream().filter(target -> {
                Direction direction = (Direction)target.getB();
                BlockPos pipePos = ((BlockPos)target.getA()).offset(direction.getNormal());
                BlockState pipeState = world.getBlockState(pipePos);
                Block patt0$temp = pipeState.getBlock();
                if (!(patt0$temp instanceof ItemPipeConnectionBlock)) {
                    return true;
                }
                ItemPipeConnectionBlock itemBlock = (ItemPipeConnectionBlock)patt0$temp;
                boolean extracting = itemBlock.isSideExtractable(pipeState, direction.getOpposite());
                return !extracting;
            }).map(target -> new Tuple(this.findFromCache(world, (BlockPos)target.getA(), (Direction)target.getB()), (Object)((BlockPos)target.getA()))).filter(obj -> Objects.nonNull(obj.getA()) && ((Storage)obj.getA()).supportsInsertion()).sorted(Comparator.comparingInt(a -> ((BlockPos)a.getB()).distManhattan((Vec3i)pos))).toList();
            this.filteredTargetsNetHash = netHash;
        }
        int moveCount = stackToMove.getCount();
        long moved = 0L;
        try (Transaction tx = Transaction.openOuter();){
            for (Tuple tuple : this.filteredTargetItemStorages) {
                if (((Storage)tuple.getA()).equals(moveFromInventory)) continue;
                long inserted = ((Storage)tuple.getA()).insert((Object)ItemVariant.of((ItemStack)stackToMove), (long)moveCount, (TransactionContext)tx);
                moved += inserted;
                if ((moveCount -= (int)inserted) > 0) continue;
                break;
            }
            if (moved <= 0L) {
                tx.abort();
                return;
            }
            long extracted = moveFromInventory.extract((Object)ItemVariant.of((ItemStack)stackToMove), moved, (TransactionContext)tx);
            if (extracted != moved) {
                Oritech.LOGGER.warn("Invalid state while transferring inventory. Caused at position " + String.valueOf(pos));
                tx.abort();
            } else {
                tx.commit();
            }
        }
        if (moved > 0L && moveCapacity > TRANSFER_AMOUNT) {
            this.onBoostUsed();
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    private Storage<ItemVariant> findFromCache(Level world, BlockPos pos, Direction direction) {
        BlockApiCache cacheRes = this.lookupCache.computeIfAbsent(pos, elem -> BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (ServerLevel)((ServerLevel)world), (BlockPos)pos));
        return (Storage)cacheRes.find((Object)direction);
    }

    private static ItemStack getFromStorage(Storage<ItemVariant> inventory, int maxTransferAmount, Transaction mainTx) {
        Iterator it = inventory.nonEmptyIterator();
        while (it.hasNext()) {
            StorageView stack = (StorageView)it.next();
            ItemVariant type = (ItemVariant)stack.getResource();
            long extractedAmount = inventory.extract((Object)type, (long)maxTransferAmount, (TransactionContext)mainTx);
            if (extractedAmount <= 0L) continue;
            return type.toStack((int)extractedAmount);
        }
        return ItemStack.EMPTY;
    }
}

