/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.pipes.item.ItemFilterBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.ItemFilterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.InventoryProvider;

public class ItemFilterBlockEntity
extends BlockEntity
implements InventoryProvider,
ExtendedScreenHandlerFactory,
BlockEntityTicker<ItemFilterBlockEntity> {
    public final FilterBlockInventory inventory = new FilterBlockInventory(1);
    protected FilterData filterSettings = new FilterData(false, true, new HashMap<Integer, ItemStack>());
    protected BlockApiCache<Storage<ItemVariant>, Direction> lookupCache;
    public static Endec<Map<Integer, ItemStack>> FILTER_ITEMS_ENDEC = Endec.map(Object::toString, Integer::valueOf, (Endec)MinecraftEndecs.ITEM_STACK);

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putBoolean("whitelist", this.filterSettings.useWhitelist);
        nbt.putBoolean("useNbt", this.filterSettings.useNbt);
        Collection<ItemStack> filterItems = this.filterSettings.items.values();
        ListTag itemsNbtList = new ListTag();
        for (ItemStack item : filterItems) {
            Tag data = item.save(registryLookup);
            itemsNbtList.add((Object)data);
        }
        nbt.put("filterItems", (Tag)itemsNbtList);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        boolean whiteList = nbt.getBoolean("whitelist");
        boolean useNbt = nbt.getBoolean("useNbt");
        ListTag list = nbt.getList("filterItems", 10);
        HashMap<Integer, ItemStack> itemsList = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            Tag data = list.get(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)data).orElse(ItemStack.EMPTY);
            itemsList.put(i, stack);
        }
        FilterData data = new FilterData(useNbt, whiteList, itemsList);
        this.setFilterSettings(data);
    }

    public ItemFilterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ITEM_FILTER_ENTITY, pos, state);
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return InventoryStorage.of((Container)this.inventory, (Direction)direction);
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.ItemFilterSyncPacket(this.worldPosition, this.filterSettings));
        return new ModScreens.BasicData(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new ItemFilterScreenHandler(syncId, playerInventory, this);
    }

    public void tick(Level world, BlockPos pos, BlockState state, ItemFilterBlockEntity blockEntity) {
        if (world.isClientSide || this.inventory.isEmpty()) {
            return;
        }
        Storage targetInv = (Storage)this.getCache().find((Object)((Direction)state.getValue((Property)ItemFilterBlock.TARGET_DIR)).getOpposite());
        if (targetInv == null) {
            return;
        }
        try (Transaction tx = Transaction.openOuter();){
            ItemStack firstItem = (ItemStack)this.inventory.items.get(0);
            long inserted = targetInv.insert((Object)ItemVariant.of((ItemStack)firstItem), (long)firstItem.getCount(), (TransactionContext)tx);
            firstItem.shrink((int)inserted);
            tx.commit();
        }
    }

    private BlockApiCache<Storage<ItemVariant>, Direction> getCache() {
        if (this.lookupCache == null) {
            Direction targetDirection = (Direction)this.getBlockState().getValue((Property)ItemFilterBlock.TARGET_DIR);
            BlockPos targetPos = this.worldPosition.offset(targetDirection.getNormal());
            this.lookupCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos);
        }
        return this.lookupCache;
    }

    public FilterData getFilterSettings() {
        return this.filterSettings;
    }

    public void setFilterSettings(FilterData filterSettings) {
        this.filterSettings = filterSettings;
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public class FilterBlockInventory
    extends SimpleContainer
    implements WorldlyContainer {
        public FilterBlockInventory(int size) {
            super(size);
        }

        public void setChanged() {
            ItemFilterBlockEntity.this.setChanged();
        }

        public int[] getSlotsForFace(Direction side) {
            return new int[]{0};
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
            Direction outputSide = (Direction)ItemFilterBlockEntity.this.getBlockState().getValue((Property)ItemFilterBlock.TARGET_DIR);
            if (side.equals((Object)outputSide)) {
                return false;
            }
            boolean checkNbt = ItemFilterBlockEntity.this.filterSettings.useNbt;
            boolean matchesFilterItems = false;
            for (ItemStack filterItem : ItemFilterBlockEntity.this.filterSettings.items.values()) {
                boolean matchesType = stack.getItem().equals(filterItem.getItem());
                if (!matchesType) continue;
                if (checkNbt) {
                    if (stack.has(DataComponents.CUSTOM_DATA) && filterItem.has(DataComponents.CUSTOM_DATA)) {
                        boolean match = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).equals(filterItem.get(DataComponents.CUSTOM_DATA));
                        if (!match) continue;
                        matchesFilterItems = true;
                        break;
                    }
                    if (stack.has(DataComponents.CUSTOM_DATA) || filterItem.has(DataComponents.CUSTOM_DATA)) continue;
                    matchesFilterItems = true;
                    break;
                }
                matchesFilterItems = true;
                break;
            }
            if (ItemFilterBlockEntity.this.filterSettings.useWhitelist) {
                return matchesFilterItems;
            }
            return !matchesFilterItems;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
            Direction outputSide = (Direction)ItemFilterBlockEntity.this.getBlockState().getValue((Property)ItemFilterBlock.TARGET_DIR);
            return side.equals((Object)outputSide);
        }
    }

    public record FilterData(boolean useNbt, boolean useWhitelist, Map<Integer, ItemStack> items) {
    }
}

