/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.FluidProvider;

public class FluidPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity
implements FluidProvider {
    public static final int MAX_TRANSFER_RATE = (int)(81000.0f * Oritech.CONFIG.fluidPipeExtractAmountBuckets());
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.fluidPipeExtractIntervalDuration();
    private List<Storage<FluidVariant>> filteredFluidTargetsCached;
    private final HashMap<BlockPos, BlockApiCache<Storage<FluidVariant>, Direction>> lookupCache = new HashMap();
    private final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return (long)((float)MAX_TRANSFER_RATE * Oritech.CONFIG.fluidPipeInternalStorageBuckets() * (float)(FluidPipeInterfaceEntity.this.isBoostAvailable() ? 10 : 1));
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            FluidPipeInterfaceEntity.this.setChanged();
        }
    };

    public FluidPipeInterfaceEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.FLUID_PIPE_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        SingleVariantStorage.writeNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        SingleVariantStorage.readNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
    }

    public void tick(Level world, BlockPos pos, BlockState state, GenericPipeInterfaceEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.getBlock();
        if (world.getGameTime() % (long)TRANSFER_PERIOD != 0L && !this.isBoostAvailable() || !block.isExtractable(state)) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = FluidPipeBlock.FLUID_PIPE_DATA.getOrDefault(world.dimension().location(), new GenericPipeInterfaceEntity.PipeNetworkData());
        if (block.isExtractable(state) && this.fluidStorage.amount < this.fluidStorage.getCapacity()) {
            Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
            block12: for (BlockPos sourcePos : sources) {
                Storage<FluidVariant> sourceContainer;
                BlockPos offset = pos.subtract((Vec3i)sourcePos);
                Direction direction = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
                if (!block.isSideExtractable(state, direction.getOpposite()) || (sourceContainer = this.findFromCache(world, sourcePos, direction)) == null || !sourceContainer.supportsExtraction()) continue;
                long availableInsert = this.fluidStorage.getCapacity() - this.fluidStorage.amount;
                FluidVariant ownVariant = (FluidVariant)this.fluidStorage.variant;
                Iterator it = sourceContainer.nonEmptyIterator();
                while (it.hasNext()) {
                    StorageView fluid = (StorageView)it.next();
                    if (!ownVariant.isBlank() && !((FluidVariant)fluid.getResource()).equals((Object)ownVariant)) continue;
                    FluidVariant targetVariant = (FluidVariant)fluid.getResource();
                    Transaction tx = Transaction.openOuter();
                    try {
                        long extracted = sourceContainer.extract((Object)targetVariant, availableInsert, (TransactionContext)tx);
                        if (extracted == 0L) continue;
                        long inserted = this.fluidStorage.insert((TransferVariant)targetVariant, extracted, (TransactionContext)tx);
                        if (inserted != extracted) {
                            tx.abort();
                            Oritech.LOGGER.warn("Something weird has happened with fluid pipes. Working with transaction APIs is just annoying. Caused at: " + String.valueOf(pos));
                            continue;
                        }
                        tx.commit();
                        continue block12;
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
            }
        }
        if (this.fluidStorage.amount <= 0L) {
            return;
        }
        if (this.fluidStorage.variant == FluidVariant.blank()) {
            System.err.println("this should never happen! Maybe it's updating old data?");
            this.fluidStorage.amount = 0L;
            return;
        }
        Set<Tuple<BlockPos, Direction>> targets = FluidPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.getBlockPos()));
            return;
        }
        int netHash = targets.hashCode();
        if (netHash != this.filteredTargetsNetHash || this.filteredFluidTargetsCached == null) {
            this.filteredFluidTargetsCached = targets.stream().filter(target -> {
                Direction direction = (Direction)target.getB();
                BlockPos pipePos = ((BlockPos)target.getA()).offset(direction.getNormal());
                BlockState pipeState = world.getBlockState(pipePos);
                Block patt0$temp = pipeState.getBlock();
                if (!(patt0$temp instanceof FluidPipeConnectionBlock)) {
                    return true;
                }
                FluidPipeConnectionBlock fluidBlock = (FluidPipeConnectionBlock)patt0$temp;
                boolean extracting = fluidBlock.isSideExtractable(pipeState, ((Direction)target.getB()).getOpposite());
                return !extracting;
            }).map(target -> this.findFromCache(world, (BlockPos)target.getA(), (Direction)target.getB())).filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion()).collect(Collectors.toList());
            this.filteredTargetsNetHash = netHash;
        }
        Collections.shuffle(this.filteredFluidTargetsCached);
        long availableFluid = this.fluidStorage.getAmount();
        FluidVariant ownType = (FluidVariant)this.fluidStorage.variant;
        long moved = 0L;
        try (Transaction tx = Transaction.openOuter();){
            for (Storage<FluidVariant> targetStorage : this.filteredFluidTargetsCached) {
                long transferred = targetStorage.insert((Object)ownType, availableFluid, (TransactionContext)tx);
                if (transferred < 0L) {
                    tx.abort();
                    continue;
                }
                moved += this.fluidStorage.extract((TransferVariant)ownType, transferred, (TransactionContext)tx);
                if ((availableFluid -= transferred) > 0L) continue;
                break;
            }
            tx.commit();
        }
        if (moved > 0L) {
            this.onBoostUsed();
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    private Storage<FluidVariant> findFromCache(Level world, BlockPos pos, Direction direction) {
        BlockApiCache cacheRes = this.lookupCache.computeIfAbsent(pos, elem -> BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (ServerLevel)((ServerLevel)world), (BlockPos)pos));
        return (Storage)cacheRes.find((Object)direction);
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }
}

