/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;

public class EnergyPipeInterfaceEntity
extends GenericPipeInterfaceEntity
implements EnergyApi.BlockProvider {
    private final SimpleEnergyStorage energyStorage;
    private final boolean isSuperConductor;
    private List<EnergyApi.EnergyContainer> cachedTargets = List.of();
    private int cacheHash;

    public EnergyPipeInterfaceEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ENERGY_PIPE_ENTITY, pos, state);
        this.isSuperConductor = state.getBlock().equals(BlockContent.SUPERCONDUCTOR_CONNECTION) || state.getBlock().equals(BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION);
        this.energyStorage = this.isSuperConductor ? new SimpleEnergyStorage(Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate()) : new SimpleEnergyStorage(Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate());
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy", this.energyStorage.getAmount());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy"));
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    public void tick(Level world, BlockPos pos, BlockState state, GenericPipeInterfaceEntity blockEntity) {
        List<EnergyApi.EnergyContainer> energyStorages;
        if (world.isClientSide || this.energyStorage.getAmount() <= 0L) {
            return;
        }
        HashMap<ResourceLocation, GenericPipeInterfaceEntity.PipeNetworkData> dataSource = this.isSuperConductor ? SuperConductorBlock.SUPERCONDUCTOR_DATA : EnergyPipeBlock.ENERGY_PIPE_DATA;
        GenericPipeInterfaceEntity.PipeNetworkData data = dataSource.getOrDefault(world.dimension().location(), new GenericPipeInterfaceEntity.PipeNetworkData());
        Set<Tuple<BlockPos, Direction>> targets = EnergyPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            return;
        }
        int targetHash = targets.hashCode();
        if (this.cacheHash == targetHash) {
            energyStorages = this.cachedTargets;
        } else {
            this.cachedTargets = energyStorages = targets.stream().map(target -> EnergyApi.BLOCK.find(world, (BlockPos)target.getA(), (Direction)target.getB())).filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion()).collect(Collectors.toList());
            this.cacheHash = targetHash;
        }
        Collections.shuffle(energyStorages);
        for (EnergyApi.EnergyContainer targetStorage : energyStorages) {
            if (this.energyStorage.getAmount() <= 0L) break;
            EnergyApi.transfer(this.energyStorage, targetStorage, Long.MAX_VALUE, false);
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }
}

