/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.Codec;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.SimpleEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpBlockEntity
extends BlockEntity
implements BlockEntityTicker<PumpBlockEntity>,
FluidProvider,
EnergyApi.BlockProvider,
GeoBlockEntity {
    private static final int MAX_SEARCH_COUNT = 100000;
    private static final int ENERGY_USAGE = 512;
    private static final int PUMP_RATE = 5;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<PumpBlockEntity> animationController = this.getAnimationController();
    public FluidVariant lastPumpedVariant;
    public long lastPumpTime;
    private final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 1296000L;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            PumpBlockEntity.this.setChanged();
        }
    };
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(1000L, 0L, 20000L);
    private boolean initialized = false;
    private boolean toolheadLowered = false;
    private boolean searchActive = false;
    private BlockPos toolheadPosition;
    private FloodFillSearch searchInstance;
    private Deque<BlockPos> pendingLiquidPositions;

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PUMP_BLOCK, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        SingleVariantStorage.writeNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        nbt.putBoolean("initialized", this.initialized);
        nbt.putLong("energy", this.energyStorage.getAmount());
        if (this.pendingLiquidPositions != null) {
            nbt.putLongArray("pendingTargets", this.pendingLiquidPositions.stream().mapToLong(BlockPos::asLong).toArray());
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.initialized = nbt.getBoolean("initialized");
        SingleVariantStorage.readNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy"));
        this.pendingLiquidPositions = Arrays.stream(nbt.getLongArray("pendingTargets")).mapToObj(BlockPos::of).collect(Collectors.toCollection(ArrayDeque::new));
    }

    public void tick(Level world, BlockPos pos, BlockState state, PumpBlockEntity blockEntity) {
        if (world.isClientSide) {
            if (this.isBusy()) {
                this.spawnWorkingParticles();
            }
            return;
        }
        if (!this.initialized) {
            this.progressStartup();
            return;
        }
        if (world.getGameTime() % 5L == 0L && this.hasEnoughEnergy()) {
            if (this.pendingLiquidPositions.isEmpty() || this.tankIsFull()) {
                return;
            }
            BlockPos targetBlock = this.pendingLiquidPositions.peekLast();
            if (!world.getBlockState(targetBlock).liquid()) {
                this.pendingLiquidPositions.pollLast();
                return;
            }
            FluidState targetState = world.getFluidState(targetBlock);
            if (!targetState.getType().isSame((Fluid)Fluids.WATER)) {
                this.drainSourceBlock(targetBlock);
                this.pendingLiquidPositions.pollLast();
            }
            this.addLiquidToTank(targetState);
            this.useEnergy();
            this.setChanged();
            this.setLastPumpTime(world.getGameTime());
            this.updateNetwork((FluidVariant)this.fluidStorage.variant);
        }
    }

    public void onUsed(Player player) {
        MutableComponent message = Component.translatable((String)"message.oritech.pump.starting");
        if (!this.initialized) {
            message = !this.toolheadLowered ? Component.translatable((String)"message.oritech.pump.extending") : (this.searchActive ? Component.translatable((String)"message.oritech.pump.initializing") : Component.translatable((String)"message.oritech.pump.no_fluids"));
        } else if (this.isBusy()) {
            message = Component.translatable((String)"message.oritech.pump.busy");
        } else if (!this.hasEnoughEnergy()) {
            message = Component.translatable((String)"message.oritech.pump.low_energy");
        } else if (this.pendingLiquidPositions.isEmpty()) {
            message = Component.translatable((String)"message.oritech.pump.pump_finished");
        } else if (this.tankIsFull()) {
            message = Component.translatable((String)"message.oritech.pump.full");
        }
        player.displayClientMessage((Component)message, true);
    }

    private void spawnWorkingParticles() {
        if (this.level.getGameTime() % 5L != 0L) {
            return;
        }
        Vec3 targetPos = this.worldPosition.getCenter();
        SimpleParticleType targetType = ParticleTypes.BUBBLE_COLUMN_UP;
        if (this.lastPumpedVariant.getFluid().equals(Fluids.LAVA)) {
            targetType = ParticleTypes.LAVA;
        }
        if (this.lastPumpedVariant.getFluid().equals(FluidContent.STILL_OIL)) {
            targetType = ParticleTypes.FALLING_OBSIDIAN_TEAR;
        }
        this.level.addParticle((ParticleOptions)targetType, targetPos.x(), targetPos.y(), targetPos.z(), 0.0, 0.3, 0.0);
    }

    private boolean hasEnoughEnergy() {
        return this.energyStorage.getAmount() >= 512L;
    }

    private void useEnergy() {
        this.energyStorage.extractIgnoringLimit(512L, false);
    }

    private boolean tankIsFull() {
        return this.fluidStorage.amount > this.fluidStorage.getCapacity() - 81000L;
    }

    private void addLiquidToTank(FluidState targetState) {
        try (Transaction tx = Transaction.openOuter();){
            this.fluidStorage.insert((TransferVariant)FluidVariant.of((Fluid)targetState.getType()), 81000L, (TransactionContext)tx);
            tx.commit();
        }
    }

    private void drainSourceBlock(BlockPos targetBlock) {
        this.level.setBlockAndUpdate(targetBlock, Blocks.AIR.defaultBlockState());
    }

    private void progressStartup() {
        if (this.toolheadPosition == null) {
            this.toolheadPosition = this.worldPosition;
        }
        if (!this.toolheadLowered) {
            if (this.level.getGameTime() % 10L != 0L) {
                this.moveToolheadDown();
            }
            return;
        }
        if (this.searchActive && this.searchInstance.nextGeneration()) {
            this.finishSearch();
            this.searchActive = false;
        }
    }

    private void moveToolheadDown() {
        this.toolheadLowered = this.checkToolheadEnd(this.toolheadPosition);
        if (this.toolheadLowered) {
            this.startLiquidSearch(this.toolheadPosition.below());
            return;
        }
        this.toolheadPosition = this.toolheadPosition.below();
        this.level.setBlockAndUpdate(this.toolheadPosition, BlockContent.PUMP_TRUNK_BLOCK.defaultBlockState());
    }

    private boolean checkToolheadEnd(BlockPos newPosition) {
        BlockPos posBelow = newPosition.below();
        BlockState stateBelow = this.level.getBlockState(posBelow);
        Block blockBelow = stateBelow.getBlock();
        return !blockBelow.equals(Blocks.AIR) && !blockBelow.equals(BlockContent.PUMP_TRUNK_BLOCK);
    }

    private void startLiquidSearch(BlockPos start) {
        FluidState state = this.level.getFluidState(start);
        if (!state.isSource()) {
            return;
        }
        this.searchInstance = new FloodFillSearch(start, this.level);
        this.searchActive = true;
        Oritech.LOGGER.debug("starting search at: " + String.valueOf(start) + " " + String.valueOf(state.getType()) + " " + state.isSource());
    }

    private void finishSearch() {
        Oritech.LOGGER.debug("search finished, found: " + this.searchInstance.foundTargets.size());
        this.pendingLiquidPositions = this.searchInstance.foundTargets;
        this.initialized = true;
        this.searchInstance = null;
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    private void updateNetwork(FluidVariant variant) {
        String fluid = BuiltInRegistries.FLUID.getKey((Object)variant.getFluid()).toString();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.PumpWorkSyncPacket(this.worldPosition, fluid, this.level.getGameTime()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private boolean isBusy() {
        return this.level.getGameTime() - this.lastPumpTime < 40L;
    }

    private AnimationController<PumpBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (this.isBusy()) {
                return state.setAndContinue(MachineBlockEntity.WORKING);
            }
            return PlayState.STOP;
        });
    }

    public void setLastPumpedVariant(FluidVariant lastPumpedVariant) {
        this.lastPumpedVariant = lastPumpedVariant;
    }

    public void setLastPumpTime(long lastPumpTime) {
        this.lastPumpTime = lastPumpTime;
    }

    private static class FloodFillSearch {
        final HashSet<BlockPos> checkedPositions = new HashSet();
        final HashSet<BlockPos> nextTargets = new HashSet();
        final Deque<BlockPos> foundTargets = new ArrayDeque<BlockPos>();
        final Level world;

        public FloodFillSearch(BlockPos startPosition, Level world) {
            this.world = world;
            this.nextTargets.add(startPosition);
        }

        public boolean nextGeneration() {
            HashSet currentGeneration = (HashSet)this.nextTargets.clone();
            boolean earlyStop = false;
            for (BlockPos target : currentGeneration) {
                if (this.isValidTarget(target)) {
                    this.foundTargets.addLast(target);
                    this.addNeighborsToQueue(target);
                    if (this.checkForEarlyStop(target)) {
                        earlyStop = true;
                    }
                }
                this.checkedPositions.add(target);
                this.nextTargets.remove(target);
            }
            if (this.cutoffSearch() || earlyStop) {
                this.nextTargets.clear();
            }
            return this.nextTargets.isEmpty();
        }

        private boolean checkForEarlyStop(BlockPos target) {
            return this.world.getFluidState(target).getType().isSame((Fluid)Fluids.WATER);
        }

        private boolean cutoffSearch() {
            return this.foundTargets.size() >= 100000;
        }

        private boolean isValidTarget(BlockPos target) {
            FluidState state = this.world.getFluidState(target);
            return state.isSource();
        }

        private void addNeighborsToQueue(BlockPos self) {
            for (BlockPos neighbor : this.getNeighbors(self)) {
                if (this.checkedPositions.contains(neighbor)) continue;
                this.nextTargets.add(neighbor);
            }
        }

        private List<BlockPos> getNeighbors(BlockPos pos) {
            return List.of(pos.below(), pos.north(), pos.east(), pos.south(), pos.west());
        }
    }
}

