/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.ScreenProvider;

public class PlacerBlockEntity
extends ItemEnergyFrameInteractionBlockEntity {
    public PlacerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PLACER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected boolean hasWorkAvailable(BlockPos toolPosition) {
        ItemStack firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return false;
        }
        Block block = Block.byItem((Item)firstBlock.getItem());
        if (block == null) {
            return false;
        }
        BlockPos targetPosition = toolPosition.below();
        return Objects.requireNonNull(this.level).getBlockState(targetPosition).getBlock().equals(Blocks.AIR) && block.defaultBlockState().canSurvive((LevelReader)this.level, targetPosition);
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
        ItemStack firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return;
        }
        Block block = Block.byItem((Item)firstBlock.getItem());
        if (block == null) {
            return;
        }
        BlockPos targetPosition = processed.below();
        if (Objects.requireNonNull(this.level).getBlockState(targetPosition).getBlock().equals(Blocks.AIR) && block.defaultBlockState().canSurvive((LevelReader)this.level, targetPosition)) {
            this.level.setBlockAndUpdate(targetPosition, block.defaultBlockState());
            firstBlock.shrink(1);
            this.level.playSound(null, targetPosition, block.defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            super.finishBlockWork(processed);
        }
    }

    private ItemStack getFirstInInventory() {
        for (ItemStack stack : this.inventory.items) {
            if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
        if (!this.isActivelyViewed()) {
            NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.InventorySyncPacket(this.worldPosition, (List<ItemStack>)this.inventory.items));
        }
    }

    @Override
    public float getCoreQuality() {
        return 3.0f;
    }

    @Override
    public BlockState getMachineHead() {
        return BlockContent.BLOCK_PLACER_HEAD.defaultBlockState();
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, -1, 0));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38));
    }

    @Override
    public ItemStack getToolheadAdditionalRender() {
        return this.getFirstInInventory();
    }

    @Override
    public int getMoveTime() {
        return Oritech.CONFIG.placerConfig.moveDuration();
    }

    @Override
    public int getWorkTime() {
        return Oritech.CONFIG.placerConfig.workDuration();
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.placerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.placerConfig.workEnergyUsage();
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.PLACER_SCREEN;
    }
}

