/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PipeBoosterBlockEntity
extends BlockEntity
implements BlockEntityTicker<PipeBoosterBlockEntity>,
GeoBlockEntity,
EnergyApi.BlockProvider {
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 4000L, 0L, () -> ((PipeBoosterBlockEntity)this).setChanged());
    public static final RawAnimation EXPAND = RawAnimation.begin().thenPlayAndHold("expand");
    public static final RawAnimation RETRACT = RawAnimation.begin().thenPlayAndHold("retract");
    public static final RawAnimation EXTENDED = RawAnimation.begin().thenPlay("extended");
    public static final RawAnimation RETRACTED = RawAnimation.begin().thenPlay("retracted");
    public static final RawAnimation WORK = RawAnimation.begin().thenPlay("work");
    private static final int BOOST_ENERGY_COST = 32;
    private boolean setPipe;

    public PipeBoosterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PIPE_BOOSTER_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, PipeBoosterBlockEntity blockEntity) {
        BlockPos targetPos;
        BlockEntity candidate;
        if (world.isClientSide) {
            return;
        }
        if (!this.setPipe && (world.getGameTime() & 0x19L) == 0L && (candidate = world.getBlockEntity(targetPos = pos.offset(Geometry.getBackward((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))))) instanceof GenericPipeInterfaceEntity) {
            GenericPipeInterfaceEntity pipe = (GenericPipeInterfaceEntity)candidate;
            pipe.connectedBooster = pos;
            this.setPipe = true;
            this.triggerAnim("machine", "expand");
        }
        if (world.getGameTime() % 42L == 0L) {
            if (this.setPipe) {
                this.triggerAnim("machine", "extended");
            } else {
                this.triggerAnim("machine", "retracted");
            }
        }
    }

    public boolean canUseBoost() {
        return this.energyStorage.amount >= 32L;
    }

    public void useBoost() {
        if (!this.canUseBoost()) {
            return;
        }
        this.energyStorage.amount -= 32L;
        this.setChanged();
        this.triggerAnim("machine", "work");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 5, state -> PlayState.CONTINUE).triggerableAnim("work", WORK).triggerableAnim("extended", EXTENDED).triggerableAnim("retracted", RETRACTED).triggerableAnim("expand", EXPAND).triggerableAnim("retract", RETRACT).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(@Nullable Direction direction) {
        return this.energyStorage;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

