/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.behavior.LaserArmBlockBehavior;
import rearth.oritech.block.behavior.LaserArmEntityBehavior;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserArmBlockEntity
extends BlockEntity
implements GeoBlockEntity,
BlockEntityTicker<LaserArmBlockEntity>,
EnergyApi.BlockProvider,
ScreenProvider,
ExtendedScreenHandlerFactory,
MultiblockMachineController,
MachineAddonController,
InventoryProvider,
RedstoneAddonBlockEntity.RedstoneControllable {
    public static final String LASER_PLAYER_NAME = "oritech_laser";
    private static final int BLOCK_BREAK_ENERGY = Oritech.CONFIG.laserArmConfig.blockBreakEnergyBase();
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, () -> ((LaserArmBlockEntity)this).setChanged());
    public final SimpleContainer inventory = new SimpleContainer(3){

        public void setChanged() {
            LaserArmBlockEntity.this.setChanged();
        }
    };
    protected final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<LaserArmBlockEntity> animationController = this.getAnimationController();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    private float coreQuality = 1.0f;
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;
    public int areaSize = 1;
    public int yieldAddons = 0;
    public int hunterAddons = 0;
    public boolean hasCropFilterAddon = false;
    private final int range;
    private Vec3 laserHead;
    private BlockPos targetDirection;
    private BlockPos currentTarget;
    public HunterTargetMode hunterTargetMode;
    private LivingEntity currentLivingTarget;
    private long lastFiredAt;
    private int progress;
    private int targetBlockEnergyNeeded;
    private boolean networkDirty;
    private boolean redstonePowered;
    private ArrayDeque<BlockPos> pendingArea;
    private final ArrayDeque<LivingEntity> pendingLivingTargets;
    public Vec3 lastRenderPosition;
    private Player laserPlayerEntity;

    public LaserArmBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.LASER_ARM_ENTITY, pos, state);
        this.range = Oritech.CONFIG.laserArmConfig.range();
        this.hunterTargetMode = HunterTargetMode.HOSTILE_ONLY;
        this.targetBlockEnergyNeeded = BLOCK_BREAK_ENERGY;
        this.pendingLivingTargets = new ArrayDeque();
        this.laserPlayerEntity = null;
        this.laserHead = Vec3.atLowerCornerOf((Vec3i)pos.above()).add(0.5, 0.55, 0.5);
    }

    public void tick(Level world, BlockPos pos, BlockState state, LaserArmBlockEntity blockEntity) {
        if (world.isClientSide() || !this.isActive(state)) {
            return;
        }
        if (!this.redstonePowered && this.energyStorage.getAmount() >= (long)this.energyRequiredToFire()) {
            if (this.hunterAddons > 0) {
                this.fireAtLivingEntities(world, pos, state, blockEntity);
            } else if (this.currentTarget != null && !this.currentTarget.equals((Object)BlockPos.ZERO)) {
                this.fireAtBlocks(world, pos, state, blockEntity);
            } else if (this.targetDirection != null && !this.targetDirection.equals((Object)BlockPos.ZERO) && (world.getGameTime() + (long)pos.getZ()) % 40L == 0L) {
                this.findNextBlockBreakTarget();
            }
        }
        if (this.networkDirty) {
            this.updateNetwork();
        }
    }

    private void fireAtBlocks(Level world, BlockPos pos, BlockState state, LaserArmBlockEntity blockEntity) {
        BlockPos targetBlockPos = this.currentTarget;
        BlockState targetBlockState = world.getBlockState(targetBlockPos);
        Block targetBlock = targetBlockState.getBlock();
        BlockEntity targetBlockEntity = world.getBlockEntity(targetBlockPos);
        LaserArmBlockBehavior behavior = LaserArmBlock.getBehaviorForBlock(targetBlock);
        boolean fired = false;
        if (behavior.fireAtBlock(world, this, targetBlock, targetBlockPos, targetBlockState, targetBlockEntity)) {
            this.energyStorage.amount -= (long)this.energyRequiredToFire();
            this.lastFiredAt = world.getGameTime();
            this.networkDirty = true;
        } else {
            this.findNextBlockBreakTarget();
        }
    }

    private void fireAtLivingEntities(Level world, BlockPos pos, BlockState state, LaserArmBlockEntity blockEntity) {
        if (this.currentLivingTarget != null && this.validTarget(this.currentLivingTarget)) {
            LaserArmEntityBehavior behavior = LaserArmBlock.getBehaviorForEntity(this.currentLivingTarget.getType());
            if (behavior.fireAtEntity(world, this, this.currentLivingTarget)) {
                this.energyStorage.amount -= (long)this.energyRequiredToFire();
                this.targetDirection = this.currentLivingTarget.blockPosition();
                this.lastFiredAt = world.getGameTime();
                this.networkDirty = true;
            } else {
                this.pendingLivingTargets.remove(this.currentLivingTarget);
                this.currentLivingTarget = null;
                this.currentTarget = null;
                this.networkDirty = true;
            }
        } else {
            this.loadNextLivingTarget();
        }
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    public void addBlockBreakProgress(int progress) {
        this.progress += progress;
    }

    public int getBlockBreakProgress() {
        return this.progress;
    }

    public int getTargetBlockEnergyNeeded() {
        return this.targetBlockEnergyNeeded;
    }

    public void finishBlockBreaking(BlockPos targetPos, BlockState targetBlockState) {
        this.progress -= this.targetBlockEnergyNeeded;
        BlockEntity targetEntity = this.level.getBlockEntity(targetPos);
        List<ItemStack> dropped = this.yieldAddons > 0 ? DestroyerBlockEntity.getLootDrops(targetBlockState, (ServerLevel)this.level, targetPos, targetEntity, this.yieldAddons, this.getLaserPlayerEntity()) : Block.getDrops((BlockState)targetBlockState, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (BlockEntity)targetEntity, (Entity)this.getLaserPlayerEntity(), (ItemStack)ItemStack.EMPTY);
        RecipeHolder<OritechRecipe> blockRecipe = this.tryGetRecipeOfBlock(targetBlockState);
        if (blockRecipe != null) {
            OritechRecipe recipe = (OritechRecipe)blockRecipe.value();
            int farmedCount = 1 + this.yieldAddons;
            dropped = List.of(new ItemStack((ItemLike)recipe.getResults().get(0).getItem(), farmedCount));
            ParticleContent.CHARGING.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)targetPos), (Object)1);
        }
        for (ItemStack stack : dropped) {
            this.inventory.addItem(stack);
        }
        try {
            targetBlockState.getBlock().playerWillDestroy(this.level, targetPos, targetBlockState, this.getLaserPlayerEntity());
        }
        catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + String.valueOf(targetBlockState) + " at " + String.valueOf(targetPos) + ": " + exception.getLocalizedMessage());
        }
        this.level.addDestroyBlockEffect(targetPos, this.level.getBlockState(targetPos));
        this.level.playSound(null, targetPos, targetBlockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.destroyBlock(targetPos, false);
        this.findNextBlockBreakTarget();
    }

    private RecipeHolder<OritechRecipe> tryGetRecipeOfBlock(BlockState destroyed) {
        Item inputItem = destroyed.getBlock().asItem();
        SimpleCraftingInventory inputInv = new SimpleCraftingInventory(new ItemStack((ItemLike)inputItem));
        Optional candidate = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.LASER, (RecipeInput)inputInv, this.level);
        return candidate.orElse(null);
    }

    public Player getLaserPlayerEntity() {
        if (this.laserPlayerEntity == null) {
            this.laserPlayerEntity = new Player(this.level, this.worldPosition, 0.0f, new GameProfile(UUID.randomUUID(), LASER_PLAYER_NAME)){

                public boolean isSpectator() {
                    return false;
                }

                public boolean isCreative() {
                    return false;
                }

                public boolean canBeSeenAsEnemy() {
                    return false;
                }

                public boolean addItem(ItemStack itemStack) {
                    LaserArmBlockEntity.this.inventory.addItem(itemStack);
                    return true;
                }
            };
        }
        if (this.hunterAddons > 0 && this.yieldAddons > 0) {
            ItemStack lootingSword = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
            lootingSword.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            Holder.Reference lootingEntry = (Holder.Reference)this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.LOOTING).get();
            lootingSword.enchant((Holder)lootingEntry, Math.min(this.yieldAddons, 3));
            this.laserPlayerEntity.getInventory().items.set(this.laserPlayerEntity.getInventory().selected, (Object)lootingSword);
        }
        return this.laserPlayerEntity;
    }

    private void findNextBlockBreakTarget() {
        while (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            if (!this.trySetNewTarget(this.pendingArea.pop(), false)) continue;
            if (this.pendingArea.isEmpty()) {
                this.pendingArea = null;
            }
            return;
        }
        Vec3 direction = Vec3.atLowerCornerOf((Vec3i)this.targetDirection.subtract((Vec3i)this.worldPosition.above())).normalize();
        Vec3 from = this.laserHead.add(direction.scale(1.5));
        BlockPos nextBlock = this.basicRaycast(from, direction, this.range, 0.45f);
        if (nextBlock == null) {
            this.currentTarget = null;
            return;
        }
        int maxSize = (int)from.distanceTo(nextBlock.getCenter()) - 1;
        int scanDist = Math.min(this.areaSize, maxSize);
        if (scanDist > 1) {
            this.pendingArea = this.findNextAreaBlockTarget(nextBlock, scanDist);
        }
        if (!this.trySetNewTarget(nextBlock, false)) {
            this.currentTarget = null;
        }
    }

    private double hunterRange() {
        return Math.pow(4.0, Math.min(this.hunterAddons, 3)) + 0.5;
    }

    private boolean canSee(LivingEntity entity) {
        if (entity.level() != this.getLevel() || entity.isInvisible()) {
            return false;
        }
        Vec3 target = entity.getEyePosition();
        Vec3 direction = target.subtract(this.laserHead).normalize();
        if (this.laserHead.distanceTo(target) > 128.0) {
            return false;
        }
        return this.basicRaycast(this.laserHead.add(direction.scale(1.5)), direction, (int)(this.laserHead.distanceTo(target) - 1.0), 0.2f) == null;
    }

    private boolean validTarget(LivingEntity entity) {
        return entity.isAlive() && this.canSee(entity) && this.huntedTarget(entity) && entity.position().closerThan((Position)this.worldPosition.above().getCenter(), this.hunterRange());
    }

    private boolean huntedTarget(LivingEntity entity) {
        return switch (this.hunterTargetMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> entity instanceof Enemy;
            case 1 -> {
                Animal animal;
                if (entity instanceof Animal && (animal = (Animal)entity).getLoveCause() == null || entity instanceof WaterAnimal) {
                    yield true;
                }
                yield entity instanceof Enemy;
            }
            case 2 -> true;
        };
    }

    private void loadNextLivingTarget() {
        if (this.pendingLivingTargets.isEmpty() && (this.level.getGameTime() + this.worldPosition.asLong()) % 10L == 0L) {
            this.updateEntityTargets();
        }
        while (!this.pendingLivingTargets.isEmpty()) {
            LivingEntity candidate = this.pendingLivingTargets.pop();
            if (!this.validTarget(candidate)) continue;
            this.currentLivingTarget = candidate;
            this.currentTarget = candidate.blockPosition();
            return;
        }
    }

    private void updateEntityTargets() {
        double entityRange = this.hunterRange();
        List targets = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.laserHead.x - entityRange, this.laserHead.y - entityRange, this.laserHead.z - entityRange, this.laserHead.x + entityRange, this.laserHead.y + entityRange, this.laserHead.z + entityRange), EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
        targets.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr(this.laserHead)));
        this.pendingLivingTargets.addAll(targets);
    }

    private ArrayDeque<BlockPos> findNextAreaBlockTarget(BlockPos center, int scanDist) {
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        for (int x = -scanDist; x < scanDist; ++x) {
            for (int y = -scanDist; y < scanDist; ++y) {
                for (int z = -scanDist; z < scanDist; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    if (this.canPassThrough(this.level.getBlockState(pos), pos) || center.equals((Object)pos)) continue;
                    targets.add(pos);
                }
            }
        }
        targets.sort(Comparator.comparingInt(arg_0 -> ((BlockPos)this.worldPosition).distManhattan(arg_0)));
        return new ArrayDeque<BlockPos>(targets);
    }

    private BlockPos basicRaycast(Vec3 from, Vec3 direction, int range, float searchOffset) {
        for (float i = 0.0f; i < (float)range; i += 0.3f) {
            Vec3 to = from.add(direction.scale((double)i));
            BlockPos targetBlockPos = BlockPos.containing((Position)to.add(0.0, (double)searchOffset, 0.0));
            BlockState targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            if (searchOffset == 0.0f) {
                return null;
            }
            Vec3 offsetTop = to.add(0.0, (double)(-searchOffset), 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetTop);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetLeft = to.add((double)(-searchOffset), 0.0, 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetLeft);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetRight = to.add((double)searchOffset, 0.0, 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetRight);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetFront = to.add(0.0, 0.0, (double)searchOffset);
            targetBlockPos = BlockPos.containing((Position)offsetFront);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetBack = to.add(0.0, 0.0, (double)(-searchOffset));
            targetBlockPos = BlockPos.containing((Position)offsetBack);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (this.canPassThrough(targetState, targetBlockPos)) continue;
            return targetBlockPos;
        }
        return null;
    }

    private boolean isSearchTerminatorBlock(BlockState state) {
        return state.getBlock().equals(Blocks.TARGET);
    }

    public boolean canPassThrough(BlockState state, BlockPos blockPos) {
        return state.isAir() || state.liquid() || state.is(TagContent.LASER_PASSTHROUGH) || this.hunterAddons > 0 && !state.isRedstoneConductor((BlockGetter)this.level, blockPos);
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.areaSize = 1;
        this.yieldAddons = 0;
        this.hunterAddons = 0;
        this.hasCropFilterAddon = false;
        MachineAddonController.super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        MachineAddonController.super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().getBlock().equals(BlockContent.QUARRY_ADDON)) {
            ++this.areaSize;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_HUNTER_ADDON)) {
            ++this.hunterAddons;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            ++this.yieldAddons;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.CROP_FILTER_ADDON)) {
            this.hasCropFilterAddon = true;
        }
    }

    public int energyRequiredToFire() {
        return (int)((float)Oritech.CONFIG.laserArmConfig.energyPerTick() * (1.0f / this.addonData.speed()));
    }

    public float getDamageTick() {
        return Oritech.CONFIG.laserArmConfig.damageTickBase() * (1.0f / this.addonData.speed());
    }

    private void updateNetwork() {
        int entityId = this.currentLivingTarget != null ? this.currentLivingTarget.getId() : -1;
        BlockPos sendTarget = this.currentTarget != null ? this.currentTarget : BlockPos.ZERO;
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.LaserArmSyncPacket(this.worldPosition, sendTarget, this.lastFiredAt, this.areaSize, this.yieldAddons, this.hunterAddons, this.hunterTargetMode.value, this.hasCropFilterAddon, entityId, this.redstonePowered));
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GenericEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity));
        this.networkDirty = false;
    }

    public boolean setTargetFromDesignator(BlockPos targetPos) {
        boolean success = this.trySetNewTarget(targetPos, true);
        this.findNextBlockBreakTarget();
        return success;
    }

    public void cycleHunterTargetMode() {
        this.hunterTargetMode = this.hunterTargetMode.next();
    }

    private boolean trySetNewTarget(BlockPos targetPos, boolean alsoSetDirection) {
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPos);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.level.getBlockEntity(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        int distance = targetPos.distManhattan((Vec3i)this.worldPosition);
        float blockHardness = targetState.getBlock().defaultDestroyTime();
        if (distance > this.range || (double)blockHardness < 0.0 || targetState.getBlock().equals(Blocks.AIR)) {
            return false;
        }
        this.targetBlockEnergyNeeded = (int)((double)BLOCK_BREAK_ENERGY * Math.sqrt(blockHardness) * (double)this.addonData.efficiency());
        this.currentTarget = targetPos;
        if (alsoSetDirection) {
            this.targetDirection = targetPos;
            this.pendingArea = null;
            this.networkDirty = true;
        }
        this.setChanged();
        return true;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putBoolean("redstone", this.redstonePowered);
        nbt.putInt("areaSize", this.areaSize);
        nbt.putInt("yieldAddons", this.yieldAddons);
        nbt.putInt("hunterAddons", this.hunterAddons);
        nbt.putBoolean("cropAddon", this.hasCropFilterAddon);
        nbt.putInt("hunterTargetMode", this.hunterTargetMode.value);
        if (this.targetDirection != null && this.currentTarget != null) {
            nbt.putLong("target_position", this.currentTarget.asLong());
            nbt.putLong("target_direction", this.targetDirection.asLong());
        }
        if (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            long[] positions = this.pendingArea.stream().mapToLong(BlockPos::asLong).toArray();
            nbt.putLongArray("pendingPositions", positions);
        } else {
            nbt.remove("pendingPositions");
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
        this.redstonePowered = nbt.getBoolean("redstone");
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.targetDirection = BlockPos.of((long)nbt.getLong("target_direction"));
        this.currentTarget = BlockPos.of((long)nbt.getLong("target_position"));
        this.areaSize = nbt.getInt("areaSize");
        this.yieldAddons = nbt.getInt("yieldAddons");
        this.hunterAddons = nbt.getInt("hunterAddons");
        this.hunterTargetMode = HunterTargetMode.fromValue(nbt.getInt("hunterTargetMode"));
        this.hasCropFilterAddon = nbt.getBoolean("cropAddon");
        if (nbt.contains("pendingPositions")) {
            this.pendingArea = Arrays.stream(nbt.getLongArray("pendingPositions")).mapToObj(BlockPos::of).collect(Collectors.toCollection(ArrayDeque::new));
        }
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public Direction getFacingForMultiblock() {
        return Direction.NORTH;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public InventoryProvider getInventoryForLink() {
        return this;
    }

    @Override
    public EnergyApi.EnergyContainer getEnergyStorageForLink() {
        return this.energyStorage;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0));
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return Direction.NORTH;
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public SimpleContainer getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return null;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, -1, 0));
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.laserArmConfig.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.laserArmConfig.maxEnergyInsertion();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<LaserArmBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                if (this.isFiring()) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler());
    }

    @Override
    public void playSetupAnimation() {
        this.animationController.setAnimation(MachineBlockEntity.SETUP);
        this.animationController.forceAnimationReset();
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    public BlockPos getCurrentTarget() {
        return this.currentTarget;
    }

    public Vec3 getVisualTarget() {
        if (this.hunterAddons > 0 && this.currentLivingTarget != null) {
            return this.currentLivingTarget.getEyePosition().subtract(0.5, 0.0, 0.5);
        }
        return Vec3.atLowerCornerOf((Vec3i)this.getCurrentTarget()).add(0.0, 0.5, 0.0);
    }

    public void setCurrentTarget(BlockPos currentTarget) {
        this.currentTarget = currentTarget;
    }

    public void setLivingTargetFromNetwork(int id) {
        LivingEntity livingEntity;
        Entity candidate;
        this.currentLivingTarget = id == -1 ? null : ((candidate = this.level.getEntity(id)) instanceof LivingEntity ? (livingEntity = (LivingEntity)candidate) : null);
    }

    public long getLastFiredAt() {
        return this.lastFiredAt;
    }

    @Override
    public BlockPos getMachinePos() {
        return this.getBlockPos();
    }

    @Override
    public Level getMachineWorld() {
        return this.getLevel();
    }

    public void setLastFiredAt(long lastFiredAt) {
        this.lastFiredAt = lastFiredAt;
    }

    public boolean isFiring() {
        long idleTime = this.level.getGameTime() - this.lastFiredAt;
        return idleTime < 3L;
    }

    public boolean isTargetingAtomicForge() {
        return this.level.getBlockState(this.currentTarget).getBlock().equals(BlockContent.ATOMIC_FORGE_BLOCK);
    }

    public boolean isTargetingDeepdrill() {
        return this.level.getBlockState(this.currentTarget).getBlock().equals(BlockContent.DEEP_DRILL_BLOCK);
    }

    public boolean isTargetingCatalyst() {
        return this.level.getBlockState(this.currentTarget).getBlock().equals(BlockContent.ENCHANTMENT_CATALYST_BLOCK);
    }

    public boolean isTargetingEnergyContainer() {
        EnergyApi.EnergyContainer storageCandidate = EnergyApi.BLOCK.find(this.level, this.currentTarget, null);
        return storageCandidate != null || this.isTargetingAtomicForge() || this.isTargetingDeepdrill() || this.isTargetingCatalyst();
    }

    public boolean isTargetingBuddingAmethyst() {
        return this.level.getBlockState(this.currentTarget).is(TagContent.LASER_ACCELERATED);
    }

    @Override
    public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        if (this.areaSize == 1 && this.yieldAddons == 0 && this.hunterAddons == 0) {
            return ScreenProvider.super.getExtraExtensionLabels();
        }
        if (this.hunterAddons > 0) {
            return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{(int)this.hunterRange()}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_hunter_range")), new Tuple((Object)Component.translatable((String)"title.oritech.laser_arm.addon_hunter_damage", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getDamageTick()))}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_hunter_damage")), new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_looting", (Object[])new Object[]{this.yieldAddons}), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_looting")));
        }
        return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.areaSize}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_range")), new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_fortune", (Object[])new Object[]{this.yieldAddons}), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 20, true), new ScreenProvider.GuiSlot(1, 117, 38, true), new ScreenProvider.GuiSlot(2, 117, 56, true));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.energyRequiredToFire();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.LASER_SCREEN;
    }

    @Override
    public Property<Direction> getBlockFacingProperty() {
        return ScreenProvider.super.getBlockFacingProperty();
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        this.updateNetwork();
        return new ModScreens.UpgradableData(this.worldPosition, this.getUiData(), this.getCoreQuality());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.FullEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity, this.energyStorage.maxInsert, this.energyStorage.maxExtract));
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this, this.getUiData(), this.getCoreQuality());
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.items.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentTarget == null || this.currentTarget.equals((Object)BlockPos.ZERO)) {
            return 0;
        }
        return (int)(this.currentTarget.distSqr((Vec3i)this.worldPosition) / (double)this.range) * 15;
    }

    @Override
    public int getComparatorActiveState() {
        long idleTicks = this.level.getGameTime() - this.lastFiredAt;
        return idleTicks > 3L ? 15 : 0;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.level.getBestNeighborSignal(this.worldPosition);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.redstonePowered) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    public static enum HunterTargetMode {
        HOSTILE_ONLY(1, "message.oritech.target_designator.hunter_hostile"),
        HOSTILE_NEUTRAL(2, "message.oritech.target_designator.hunter_neutral"),
        ALL(3, "message.oritech.target_designator.hunter_all");

        public final int value;
        public final String message;
        private static final Map<Integer, HunterTargetMode> map;

        private HunterTargetMode(int value, String message) {
            this.value = value;
            this.message = message;
        }

        public static HunterTargetMode fromValue(int i) {
            return map.getOrDefault(i, HOSTILE_ONLY);
        }

        public HunterTargetMode next() {
            return HunterTargetMode.values()[(this.ordinal() + 1) % HunterTargetMode.values().length];
        }

        static {
            map = new HashMap<Integer, HunterTargetMode>();
            for (HunterTargetMode targetMode : HunterTargetMode.values()) {
                map.put(targetMode.value, targetMode);
            }
        }
    }
}

