/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.interaction.DronePortBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.DroneScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.LaserTargetDesignator;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.ImplementedInventory;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DronePortEntity
extends BlockEntity
implements InventoryProvider,
FluidProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
BlockEntityTicker<DronePortEntity>,
MultiblockMachineController,
MachineAddonController,
ExtendedScreenHandlerFactory,
ScreenProvider,
RedstoneAddonBlockEntity.RedstoneControllable {
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(32768L, 10000L, 0L, this::setChanged);
    public final SimpleContainer inventory = new DronePortItemInventory(15);
    public final DronePortFluidStorage fluidStorage = new DronePortFluidStorage();
    protected final SimpleContainer cardInventory = new SimpleContainer(2){

        public void setChanged() {
            DronePortEntity.this.setChanged();
        }

        public boolean canAddItem(ItemStack stack) {
            return stack.getItem() instanceof LaserTargetDesignator;
        }
    };
    protected final InventoryStorage inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<DronePortEntity> animationController = this.getAnimationController();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    public boolean hasFluidAddon;
    public boolean disabledViaRedstone;
    private BlockPos targetPosition;
    private long lastSentAt;
    private DroneTransferData incomingPacket;
    private DroneAnimState animState = DroneAnimState.IDLE;
    private boolean networkDirty;
    private final long FLUID_CAPACITY = 10368000L;
    private final long baseEnergyUsage = 1024L;
    private final int takeOffTime = 300;
    private final int landTime = 260;
    private final int totalFlightTime = 560;
    private String statusMessage;
    public static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("takeoff").thenPlay("idle");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("landing").thenPlay("idle");

    public DronePortEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.DRONE_PORT_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, DronePortEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        this.checkPositionCard();
        if (this.incomingPacket != null) {
            this.checkIncomingAnimation();
        }
        if (world.getGameTime() % 20L == 0L) {
            if (this.incomingPacket != null) {
                this.tryReceivePacket();
            } else if (this.canSend()) {
                this.sendDrone();
            }
        }
        if (this.networkDirty && world.getGameTime() % 10L == 0L) {
            this.networkDirty = false;
            this.sendNetworkUpdate();
        }
    }

    private void checkPositionCard() {
        ItemStack source = (ItemStack)this.cardInventory.items.get(0);
        if (!(source.getItem() instanceof LaserTargetDesignator) || !source.has(ComponentContent.TARGET_POSITION.get())) {
            return;
        }
        BlockPos target = (BlockPos)source.get(ComponentContent.TARGET_POSITION.get());
        this.setTargetFromDesignator(target);
        this.cardInventory.items.set(1, (Object)source);
        this.cardInventory.items.set(0, (Object)ItemStack.EMPTY);
        this.cardInventory.setChanged();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        nbt.putBoolean("has_fluid_addon", this.hasFluidAddon);
        nbt.putBoolean("disabled_via_redstone", this.disabledViaRedstone);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        CompoundTag inNbt = new CompoundTag();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.fluidStorage, (Codec)FluidVariant.CODEC, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
        nbt.put("fluid_storage", (Tag)inNbt);
        if (this.targetPosition != null) {
            nbt.putLong("target_position", this.targetPosition.asLong());
        }
        if (this.incomingPacket != null) {
            CompoundTag compound = new CompoundTag();
            NonNullList list = NonNullList.createWithCapacity((int)this.incomingPacket.transferredStacks.size());
            list.addAll(this.incomingPacket.transferredStacks);
            ContainerHelper.saveAllItems((CompoundTag)compound, (NonNullList)list, (boolean)false, (HolderLookup.Provider)registryLookup);
            nbt.put("incoming", (Tag)compound);
            nbt.putString("transferredFluid", BuiltInRegistries.FLUID.getKey((Object)this.incomingPacket.transferredFluid.getFluid()).toString());
            nbt.putLong("transferredFluidAmount", this.incomingPacket.fluidAmount);
            nbt.putLong("incomingTime", this.incomingPacket.arrivesAt);
        } else {
            nbt.remove("incoming");
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        CompoundTag inNbt = nbt.getCompound("fluid_storage");
        SingleVariantStorage.readNbt((SingleVariantStorage)this.fluidStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)inNbt, (HolderLookup.Provider)registryLookup);
        this.hasFluidAddon = nbt.getBoolean("has_fluid_addon");
        this.disabledViaRedstone = nbt.getBoolean("disabled_via_redstone");
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.targetPosition = BlockPos.of((long)nbt.getLong("target_position"));
        if (nbt.contains("incoming")) {
            NonNullList list = NonNullList.createWithCapacity((int)15);
            ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("incoming"), (NonNullList)list, (HolderLookup.Provider)registryLookup);
            FluidVariant fluid = FluidVariant.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("transferredFluid")))));
            long fluidAmount = nbt.getLong("transferredFluidAmount");
            long arrivalTime = nbt.getLong("incomingTime");
            this.incomingPacket = new DroneTransferData((List<ItemStack>)list, fluid, fluidAmount, arrivalTime);
        }
    }

    @Override
    public void initAddons() {
        MachineAddonController.super.initAddons();
        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
        for (Vec3i corePosition : this.getCorePositions()) {
            BlockPos worldPos = new BlockPos(Geometry.offsetToWorldPosition(this.getFacingForMultiblock(), corePosition, (Vec3i)this.getMachinePos()));
            this.level.blockUpdated(worldPos, this.level.getBlockState(worldPos).getBlock());
        }
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_FLUID_ADDON)) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        MachineAddonController.super.resetAddons();
        this.hasFluidAddon = false;
    }

    private void checkIncomingAnimation() {
        if (this.level.getGameTime() == this.incomingPacket.arrivesAt - 260L) {
            this.triggerNetworkReceiveAnimation();
        }
    }

    private void tryReceivePacket() {
        boolean hasArrived;
        boolean bl = hasArrived = this.level.getGameTime() - this.incomingPacket.arrivesAt > 0L;
        if (!hasArrived) {
            return;
        }
        Oritech.LOGGER.debug("receiving drone package: " + String.valueOf(this.incomingPacket));
        long totalToInsert = this.incomingPacket.transferredStacks.stream().mapToLong(ItemStack::getCount).sum();
        try (Transaction tx = Transaction.openOuter();){
            long totalInserted = 0L;
            for (ItemStack stack : this.incomingPacket.transferredStacks) {
                totalInserted += this.inventoryStorage.insert((Object)ItemVariant.of((ItemStack)stack), (long)stack.getCount(), (TransactionContext)tx);
            }
            if (totalInserted != totalToInsert) {
                Oritech.LOGGER.warn("Something weird has happened with drone port item storage. Caused at: " + String.valueOf(this.worldPosition));
                tx.abort();
                return;
            }
            tx.commit();
        }
        if (!this.incomingPacket.transferredFluid.isBlank()) {
            tx = Transaction.openOuter();
            try {
                long inserted = this.fluidStorage.insertFromDrone(this.incomingPacket.transferredFluid, this.incomingPacket.fluidAmount, (TransactionContext)tx);
                if (inserted != this.incomingPacket.fluidAmount) {
                    Oritech.LOGGER.warn("Something weird has happened with drone port fluid storage. Caused at: " + String.valueOf(this.worldPosition));
                    tx.abort();
                } else {
                    tx.commit();
                }
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        this.incomingPacket = null;
        this.setChanged();
    }

    private void sendDrone() {
        DronePortEntity targetPort = (DronePortEntity)this.level.getBlockEntity(this.targetPosition);
        long arriveTime = this.level.getGameTime() + 300L + 260L;
        DroneTransferData data = new DroneTransferData(this.inventory.items.stream().filter(stack -> !stack.isEmpty()).toList(), (FluidVariant)this.fluidStorage.variant, this.fluidStorage.amount, arriveTime);
        targetPort.setIncomingPacket(data);
        this.inventory.clearContent();
        this.fluidStorage.amount = 0L;
        this.fluidStorage.variant = FluidVariant.blank();
        this.lastSentAt = this.level.getGameTime();
        this.energyStorage.amount -= this.calculateEnergyUsage();
        this.triggerNetworkSendAnimation();
        targetPort.setChanged();
        this.setChanged();
        Oritech.LOGGER.debug("sending drone package: " + String.valueOf(data));
    }

    public boolean canAcceptPayload(List<ItemStack> stacks, FluidVariant fluid, long fluidAmount) {
        Transaction tx = Transaction.openOuter();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || this.inventoryStorage.insert((Object)ItemVariant.of((ItemLike)stack.getItem()), (long)stack.getCount(), (TransactionContext)tx) == (long)stack.getCount()) continue;
            tx.abort();
            return false;
        }
        if (!(fluid.isBlank() || this.hasFluidAddon && this.fluidStorage.insert(fluid, fluidAmount, (TransactionContext)tx) == fluidAmount)) {
            tx.abort();
            return false;
        }
        tx.abort();
        return true;
    }

    public boolean isSendingDrone() {
        long diff = this.level.getGameTime() - this.lastSentAt;
        return diff < 300L;
    }

    private boolean canSend() {
        block5: {
            block4: {
                if (this.disabledViaRedstone || this.targetPosition == null || this.inventory.isEmpty() && this.fluidStorage.getAmount() == 0L || this.energyStorage.amount < this.calculateEnergyUsage() || this.incomingPacket != null) {
                    return false;
                }
                BlockEntity targetEntity = this.level.getBlockEntity(this.targetPosition);
                if (!(targetEntity instanceof DronePortEntity)) break block4;
                DronePortEntity targetPort = (DronePortEntity)targetEntity;
                if (!targetPort.disabledViaRedstone && targetPort.getIncomingPacket() == null && targetPort.canAcceptPayload((List<ItemStack>)this.inventory.items, (FluidVariant)this.fluidStorage.variant, this.fluidStorage.amount)) break block5;
            }
            return false;
        }
        return !this.isSendingDrone();
    }

    private long calculateEnergyUsage() {
        if (this.targetPosition == null) {
            return 1024L;
        }
        int distance = this.worldPosition.distManhattan((Vec3i)this.targetPosition);
        return (long)Math.sqrt(distance) * 50L + 1024L;
    }

    private void triggerNetworkSendAnimation() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.DroneSendEventPacket(this.worldPosition, true, false));
    }

    private void triggerNetworkReceiveAnimation() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.DroneSendEventPacket(this.worldPosition, false, true));
    }

    private void sendNetworkUpdate() {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GenericEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity));
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.DronePortFluidSyncPacket(this.worldPosition, this.hasFluidAddon, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.fluidStorage.variant).getFluid()).toString(), this.fluidStorage.amount));
    }

    private void sendNetworkStatusMessage(String statusMessage) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.DroneCardEventPacket(this.worldPosition, statusMessage));
    }

    public boolean setTargetFromDesignator(BlockPos targetPos) {
        int distance;
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPos);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.level.getBlockEntity(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        if ((distance = targetPos.distManhattan((Vec3i)this.worldPosition)) < 50) {
            this.sendNetworkStatusMessage("message.oritech.drone.invalid_distance");
            return false;
        }
        if (this.level.getBlockState(targetPos).getBlock() instanceof DronePortBlock) {
            this.targetPosition = targetPos;
            this.sendNetworkStatusMessage("message.oritech.drone.target_set");
            return true;
        }
        this.sendNetworkStatusMessage("message.oritech.drone.target_invalid");
        return false;
    }

    public void setChanged() {
        super.setChanged();
        this.networkDirty = true;
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return InventoryStorage.of((Container)this.inventory, (Direction)direction);
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, 0), new Vec3i(-2, 0, -1), new Vec3i(0, 1, 0), new Vec3i(0, 1, 1), new Vec3i(-1, 1, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        return ((Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.worldPosition;
    }

    @Override
    public Level getMachineWorld() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public InventoryProvider getInventoryForLink() {
        return this;
    }

    @Override
    public EnergyApi.EnergyContainer getEnergyStorageForLink() {
        return this.energyStorage;
    }

    @Override
    @Nullable
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.hasFluidAddon ? this.fluidStorage : null;
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        return this.hasFluidAddon ? this.fluidStorage : null;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(3, 0, -1), new Vec3i(2, 0, -2));
    }

    @Override
    public long getDefaultCapacity() {
        return 32768L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 512L;
    }

    @Override
    public SimpleContainer getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.setChanged();
    }

    public DroneTransferData getIncomingPacket() {
        return this.incomingPacket;
    }

    public void setIncomingPacket(DroneTransferData incomingPacket) {
        this.incomingPacket = incomingPacket;
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public void playSetupAnimation() {
        this.animationController.setAnimation(MachineBlockEntity.SETUP);
        this.animationController.forceAnimationReset();
    }

    public void playSendAnimation() {
        this.animState = DroneAnimState.TAKEOFF;
        this.animationController.forceAnimationReset();
    }

    public void playReceiveAnimation() {
        this.animState = DroneAnimState.LANDING;
        this.animationController.forceAnimationReset();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.items.size() <= slot) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        return this.hasFluidAddon ? Math.max(ComparatorOutputProvider.getItemStackComparatorOutput(stack), ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage)) : ComparatorOutputProvider.getItemStackComparatorOutput(stack);
    }

    @Override
    public int getComparatorProgress() {
        if (this.isSendingDrone()) {
            return (int)((float)(this.level.getGameTime() - this.lastSentAt) / 300.0f * 15.0f);
        }
        if (this.incomingPacket != null) {
            return (int)((float)(560L + (this.level.getGameTime() - this.incomingPacket.arrivesAt)) / 560.0f * 15.0f);
        }
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isSendingDrone() || this.incomingPacket != null ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    private AnimationController<DronePortEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                switch (this.animState.ordinal()) {
                    case 0: {
                        return state.setAndContinue(MachineBlockEntity.IDLE);
                    }
                    case 1: {
                        return state.setAndContinue(TAKEOFF);
                    }
                    case 2: {
                        return state.setAndContinue(LANDING);
                    }
                }
                return PlayState.CONTINUE;
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler());
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        this.sendNetworkUpdate();
        return new ModScreens.UpgradableData(this.worldPosition, this.getUiData(), this.coreQuality);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.FullEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity, this.energyStorage.maxInsert, this.energyStorage.maxExtract));
        return new DroneScreenHandler(syncId, playerInventory, this, this.getUiData(), this.coreQuality);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        int startX = 30;
        int startY = 26;
        int distance = 18;
        ArrayList<ScreenProvider.GuiSlot> list = new ArrayList<ScreenProvider.GuiSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = y * 5 + x;
                list.add(new ScreenProvider.GuiSlot(index, startX + x * distance, startY + y * distance));
            }
        }
        return list;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.DRONE_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public SimpleContainer getCardInventory() {
        return this.cardInventory;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public class DronePortItemInventory
    extends SimpleContainer
    implements ImplementedInventory {
        public DronePortItemInventory(int size) {
            super(size);
        }

        @Override
        public NonNullList<ItemStack> getItems() {
            return this.items;
        }

        @Override
        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
            if (DronePortEntity.this.incomingPacket != null) {
                return false;
            }
            return ImplementedInventory.super.canPlaceItemThroughFace(slot, stack, side);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return super.canPlaceItem(slot, stack);
        }

        @Override
        public void setChanged() {
            DronePortEntity.this.setChanged();
        }
    }

    public class DronePortFluidStorage
    extends SingleVariantStorage<FluidVariant> {
        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 10368000L;
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            if (DronePortEntity.this.incomingPacket != null) {
                return 0L;
            }
            return super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
        }

        public long insertFromDrone(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            return super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            DronePortEntity.this.setChanged();
        }
    }

    private static enum DroneAnimState {
        IDLE,
        TAKEOFF,
        LANDING;

    }

    public record DroneTransferData(List<ItemStack> transferredStacks, FluidVariant transferredFluid, long fluidAmount, long arrivesAt) {
    }
}

