/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.SimpleCraftingInventory;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DeepDrillEntity
extends BlockEntity
implements BlockEntityTicker<DeepDrillEntity>,
EnergyApi.BlockProvider,
GeoBlockEntity,
InventoryProvider,
MultiblockMachineController {
    private boolean initialized;
    private final List<Block> targetedOre = new ArrayList<Block>();
    private int progress;
    private long lastWorkTime;
    private boolean networkDirty;
    private int worktime;
    private int energyPerStep;
    protected final DynamicEnergyStorage energyStorage;
    public final SimpleContainer inventory;
    protected final InventoryStorage inventoryStorage;
    private final ArrayList<BlockPos> coreBlocksConnected;
    private float coreQuality;
    protected final AnimatableInstanceCache animatableInstanceCache;
    private final AnimationController<DeepDrillEntity> animationController;

    public DeepDrillEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.DEEP_DRILL_ENTITY, pos, state);
        this.worktime = Oritech.CONFIG.deepDrillConfig.stepsPerOre();
        this.energyPerStep = Oritech.CONFIG.deepDrillConfig.energyPerStep();
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.deepDrillConfig.energyCapacity(), 0L, 0L, () -> ((DeepDrillEntity)this).setChanged());
        this.inventory = new SimpleContainer(1){

            public void setChanged() {
                DeepDrillEntity.this.setChanged();
            }
        };
        this.inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
        this.coreBlocksConnected = new ArrayList();
        this.coreQuality = 1.0f;
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.animationController = this.getAnimationController();
    }

    public boolean init(boolean manual) {
        this.initialized = true;
        this.targetedOre.clear();
        this.loadOreBlocks(manual);
        return !this.targetedOre.isEmpty();
    }

    public void tick(Level world, BlockPos pos, BlockState state, DeepDrillEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (this.isActive(state) && !this.initialized && (world.getGameTime() + pos.asLong()) % 60L == 0L) {
            this.init(false);
        }
        if (world.isClientSide() || !this.initialized || this.targetedOre.isEmpty()) {
            return;
        }
        if (!this.inventory.isEmpty() && ((ItemStack)this.inventory.items.get(0)).getCount() >= ((ItemStack)this.inventory.items.get(0)).getMaxStackSize()) {
            return;
        }
        if (this.energyStorage.amount >= (long)this.energyPerStep) {
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
            this.lastWorkTime = world.getGameTime();
            this.networkDirty = true;
            BlockPos particlePos = this.getCenter(0);
            ParticleContent.FURNACE_BURNING.spawn(world, Vec3.atLowerCornerOf((Vec3i)particlePos), (Object)1);
        }
        for (int i = 0; i < 5; ++i) {
            if (this.energyStorage.amount < (long)this.energyPerStep) continue;
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
        }
        if (this.progress >= this.worktime) {
            this.craftResult(world, pos);
            this.progress -= this.worktime;
            this.setChanged();
        }
        this.updateNetwork();
    }

    private BlockPos getCenter(int y) {
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return this.worldPosition.offset(Geometry.rotatePosition(new Vec3i(1, y, 0), facing));
    }

    private void loadOreBlocks(boolean manual) {
        BlockPos center = this.getCenter(-1);
        for (int x = -1; x <= 1; ++x) {
            block1: for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y >= -2; --y) {
                    BlockPos target = center.offset(x, y, z);
                    BlockState targetState = this.level.getBlockState(target);
                    if (targetState.is(TagContent.RESOURCE_NODES)) {
                        if (manual) {
                            ParticleContent.DEBUG_BLOCK.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)target));
                        }
                        this.targetedOre.add(targetState.getBlock());
                        continue block1;
                    }
                    if (!targetState.isAir()) continue block1;
                }
            }
        }
    }

    private void updateNetwork() {
        if (this.networkDirty && this.level.getGameTime() % 5L == 0L) {
            NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.DeepDrillSyncPacket(this.worldPosition, this.lastWorkTime));
            this.networkDirty = false;
        }
    }

    private void craftResult(Level world, BlockPos pos) {
        Block usedOre = this.targetedOre.get(world.random.nextInt(0, this.targetedOre.size()));
        Item nodeOreBlockItem = usedOre.asItem();
        SimpleCraftingInventory sampleInv = new SimpleCraftingInventory(new ItemStack((ItemLike)nodeOreBlockItem, 1));
        Optional recipeCandidate = world.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.DEEP_DRILL, (RecipeInput)sampleInv, world);
        if (recipeCandidate.isEmpty()) {
            return;
        }
        ItemStack output = ((OritechRecipe)((RecipeHolder)recipeCandidate.get()).value()).getResults().get(0);
        if (!this.inventory.canAddItem(output)) {
            return;
        }
        try (Transaction tx = Transaction.openOuter();){
            this.inventoryStorage.insert((Object)ItemVariant.of((ItemStack)output), (long)output.getCount(), (TransactionContext)tx);
            tx.commit();
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.energyStorage.amount = nbt.getLong("energy_stored");
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, 0), new Vec3i(-2, 0, -1), new Vec3i(0, 1, 1), new Vec3i(0, 1, 0), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, -1), new Vec3i(-2, 1, 1), new Vec3i(-2, 1, 0), new Vec3i(-2, 1, -1), new Vec3i(0, 2, 1), new Vec3i(0, 2, 0), new Vec3i(0, 2, -1), new Vec3i(-1, 2, 1), new Vec3i(-1, 2, 0), new Vec3i(-1, 2, -1), new Vec3i(-2, 2, 1), new Vec3i(-2, 2, 0), new Vec3i(-2, 2, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.worldPosition;
    }

    @Override
    public Level getMachineWorld() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public InventoryProvider getInventoryForLink() {
        return this;
    }

    @Override
    public EnergyApi.EnergyContainer getEnergyStorageForLink() {
        return null;
    }

    @Override
    public void playSetupAnimation() {
        this.animationController.setAnimation(MachineBlockEntity.SETUP);
        this.animationController.forceAnimationReset();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<DeepDrillEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                long idleTime = this.level.getGameTime() - this.lastWorkTime;
                if (idleTime < 60L) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler());
    }

    public void setLastWorkTime(long lastWorkTime) {
        this.lastWorkTime = lastWorkTime;
    }

    private boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }
}

