/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.armor.BaseJetpackItem;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.FluidProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventoryProvider;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleSidedInventory;
import rearth.oritech.util.energy.EnergyApi;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;

public class ChargerBlockEntity
extends BlockEntity
implements BlockEntityTicker<ChargerBlockEntity>,
FluidProvider,
EnergyApi.BlockProvider,
InventoryProvider,
ScreenProvider,
ExtendedScreenHandlerFactory {
    protected final DynamicEnergyStorage energyStorage;
    public final SimpleContainer inventory;
    public final InventoryStorage inventoryStorage;
    private final SingleVariantStorage<FluidVariant> fluidStorage;
    private boolean networkDirty;

    public ChargerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.CHARGER_BLOCK_ENTITY, pos, state);
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.charger.energyCapacity(), Oritech.CONFIG.charger.maxEnergyInsertion(), Oritech.CONFIG.charger.maxEnergyExtraction(), this::setChanged);
        this.inventory = new SimpleSidedInventory(2, new InventorySlotAssignment(0, 1, 1, 1)){

            public void setChanged() {
                ChargerBlockEntity.this.setChanged();
            }
        };
        this.inventoryStorage = InventoryStorage.of((Container)this.inventory, null);
        this.fluidStorage = new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return 1296000L;
            }

            protected void onFinalCommit() {
                super.onFinalCommit();
                ChargerBlockEntity.this.setChanged();
            }
        };
        this.networkDirty = false;
    }

    public void tick(Level world, BlockPos pos, BlockState state, ChargerBlockEntity blockEntity) {
        ItemStack outSlot;
        if (world.isClientSide) {
            return;
        }
        if (this.networkDirty) {
            this.updateNetwork();
        }
        if (this.inventory.getItem(0).isEmpty() || this.inventory.getItem(0).getCount() > 1) {
            return;
        }
        boolean isFull = true;
        long startEnergy = this.energyStorage.amount;
        long startFluid = this.fluidStorage.amount;
        if (!this.chargeItems()) {
            isFull = false;
        }
        if (!this.fillItems()) {
            isFull = false;
        }
        if (isFull && (outSlot = this.inventory.getItem(1)).isEmpty()) {
            this.inventory.setItem(1, this.inventory.getItem(0));
            this.inventory.setItem(0, ItemStack.EMPTY);
        }
        if (this.fluidStorage.amount != startFluid || this.energyStorage.amount != startEnergy) {
            ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.getCenter().add(0.1, 0.1, 0.0), (Object)1);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.networkDirty = true;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        SingleVariantStorage.writeNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        SingleVariantStorage.readNbt(this.fluidStorage, (Codec)FluidVariant.CODEC, FluidVariant::blank, (CompoundTag)nbt, (HolderLookup.Provider)registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.items, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
    }

    private void updateNetwork() {
        this.networkDirty = false;
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.GenericEnergySyncPacket(this.worldPosition, this.energyStorage.amount, this.energyStorage.capacity));
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.SingleVariantFluidSyncPacket(this.worldPosition, BuiltInRegistries.FLUID.getKey((Object)((FluidVariant)this.fluidStorage.variant).getFluid()).toString(), this.fluidStorage.amount));
    }

    private boolean chargeItems() {
        ContainerItemContext slot;
        ItemStack heldStack = (ItemStack)this.inventory.items.get(0);
        EnergyApi.EnergyContainer slotEnergyContainer = EnergyApi.ITEM.find(heldStack, slot = ContainerItemContext.ofSingleSlot((SingleSlotStorage)this.inventoryStorage.getSlot(0)));
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
            return slotEnergyContainer.getAmount() >= slotEnergyContainer.getCapacity();
        }
        return true;
    }

    private boolean fillItems() {
        Item item;
        ItemStack inputItem = this.inventory.getItem(0);
        long rate = 4050L;
        if (!inputItem.isEmpty() && (item = inputItem.getItem()) instanceof BaseJetpackItem) {
            BaseJetpackItem jetpackItem = (BaseJetpackItem)item;
            FluidStack container = jetpackItem.getStoredFluid(inputItem);
            long usedRate = Math.min(rate, jetpackItem.getFuelCapacity() - container.getAmount());
            if (container.getAmount() >= jetpackItem.getFuelCapacity()) {
                return true;
            }
            if (this.fluidStorage.amount > usedRate && jetpackItem.isValidFuel(((FluidVariant)this.fluidStorage.variant).getFluid()) && (container.isEmpty() || container.getFluid().equals(((FluidVariant)this.fluidStorage.variant).getFluid()))) {
                long newAmount = container.getAmount() + usedRate;
                inputItem.set(ComponentContent.STORED_FLUID.get(), (Object)FluidStack.create((Fluid)((FluidVariant)this.fluidStorage.variant).getFluid(), (long)newAmount));
                this.fluidStorage.amount -= usedRate;
                this.networkDirty = true;
            }
            return false;
        }
        return true;
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    public Object getScreenOpeningData(ServerPlayer player) {
        return new ModScreens.BasicData(this.worldPosition);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        this.updateNetwork();
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.CHARGER_SCREEN;
    }

    @Override
    public EnergyApi.EnergyContainer getStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public Storage<ItemVariant> getInventory(Direction direction) {
        return this.inventoryStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 38));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 1024.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showArmor() {
        return true;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }

    @Override
    @Nullable
    public SingleVariantStorage<FluidVariant> getForDirectFluidAccess() {
        return this.fluidStorage;
    }
}

