/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.network.NetworkContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.energy.containers.DynamicEnergyStorage;

public class SteamEngineEntity
extends FluidMultiblockGeneratorBlockEntity {
    private static final int MAX_SPEED = 10;
    private final Storage<FluidVariant> waterOutputWrapper;
    private final Storage<FluidVariant> steamWrapperInput;
    private final Storage<FluidVariant> exposedSteamEngineStorage;
    private final ArrayList<SteamEngineEntity> connectedTanks;
    private SteamEngineEntity cachedTargetTank;
    public int energyProducedTick;

    public SteamEngineEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.STEAM_ENGINE_ENTITY, pos, state, Oritech.CONFIG.generators.steamEngineData.energyPerTick());
        this.waterOutputWrapper = FilteringStorage.extractOnlyOf((Storage)this.waterStorage);
        this.steamWrapperInput = FilteringStorage.insertOnlyOf((Storage)this.inputTank);
        this.exposedSteamEngineStorage = new CombinedStorage(List.of(this.steamWrapperInput, this.waterOutputWrapper));
        this.connectedTanks = new ArrayList();
        this.cachedTargetTank = null;
        this.energyProducedTick = 0;
    }

    @Override
    public void initAddons() {
        this.setupTankCache();
        this.cachedTargetTank = this.reloadTargetTankFromCache();
    }

    @Override
    public boolean initMultiblock(BlockState state) {
        this.setupTankCache();
        return super.initMultiblock(state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, MachineBlockEntity blockEntity) {
        if (world.isClientSide || !this.isActive(state)) {
            return;
        }
        this.progress = 0;
        SteamEngineEntity usedTankEntity = this.cachedTargetTank;
        if (usedTankEntity == null) {
            if (world.getGameTime() % 40L == 0L) {
                this.setupTankCache();
                this.cachedTargetTank = this.reloadTargetTankFromCache();
            }
            return;
        }
        SingleVariantStorage usedSteamTank = usedTankEntity.inputTank;
        SingleVariantStorage usedWaterTank = usedTankEntity.waterStorage;
        DynamicEnergyStorage usedEnergyStorage = usedTankEntity.energyStorage;
        if (usedSteamTank.amount == 0L || usedWaterTank.amount == usedWaterTank.getCapacity()) {
            return;
        }
        if (this.currentRecipe == OritechRecipe.DUMMY) {
            Optional<RecipeHolder<OritechRecipe>> candidate = this.getRecipe((SingleVariantStorage<FluidVariant>)usedSteamTank);
            if (candidate.isEmpty()) {
                return;
            }
            OritechRecipe recipe = (OritechRecipe)candidate.get().value();
            if (((FluidVariant)usedSteamTank.variant).getFluid() != recipe.getFluidInput().getFluid()) {
                return;
            }
            this.currentRecipe = recipe;
        }
        float speed = this.getSteamProcessingSpeed((SingleVariantStorage<FluidVariant>)usedSteamTank);
        float consumed = Math.max(1.0f, (float)this.currentRecipe.getFluidInput().getAmount() * speed);
        usedSteamTank.amount = (long)((float)usedSteamTank.amount - consumed);
        usedWaterTank.amount = (long)((float)usedWaterTank.amount + consumed * 0.9f);
        usedWaterTank.amount = Math.min(usedWaterTank.amount, usedWaterTank.getCapacity());
        this.progress = (int)(speed * 100.0f);
        float energyEfficiency = this.getSteamEnergyEfficiency(speed);
        float energyProduced = consumed * energyEfficiency * (float)this.energyPerTick;
        usedEnergyStorage.amount = (long)Math.min((float)usedEnergyStorage.amount + energyProduced, (float)usedEnergyStorage.capacity);
        usedTankEntity.energyProducedTick += (int)energyProduced;
        this.setBaseAddonData(new MachineAddonController.BaseAddonData(1.0f / speed, 1.0f / energyEfficiency, 0L, 0L, 0));
        this.spawnParticles();
        this.lastWorkedAt = world.getGameTime();
        this.setChanged();
        this.markNetDirty();
        this.outputEnergy();
        if (this.networkDirty) {
            this.updateNetwork();
        }
    }

    private void spawnParticles() {
        if ((double)this.level.random.nextFloat() > 0.4) {
            return;
        }
        Direction facing = this.getFacing();
        Vec3 offsetLocal = Geometry.rotatePosition(new Vec3(0.0, 0.0, -0.5), facing);
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition).add(offsetLocal);
        ParticleContent.STEAM_ENGINE_WORKING.spawn(this.level, emitPosition, (Object)1);
    }

    private float getSteamEnergyEfficiency(float x) {
        return (float)((double)(0.5f - 0.1966667f * x) + 0.09166666865348816 * Math.pow(x, 2.0) - (double)0.0075f * Math.pow(x, 3.0)) + 0.4f;
    }

    private void setupTankCache() {
        int i;
        this.connectedTanks.clear();
        Direction facing = this.getFacing();
        for (i = 1; i <= 10 && this.tryAddTank(facing, i); ++i) {
        }
        for (i = 1; i <= 10 && this.tryAddTank(facing, -i); ++i) {
        }
    }

    private boolean tryAddTank(Direction facing, int i) {
        BlockPos checkPos = new BlockPos(Geometry.offsetToWorldPosition(facing, new Vec3i(i, 0, 0), (Vec3i)this.worldPosition));
        BlockState state = this.level.getBlockState(checkPos);
        if (state.getBlock() instanceof MachineCoreBlock) {
            checkPos = MachineCoreBlock.getControllerPos(this.level, checkPos);
            state = this.level.getBlockState(checkPos);
        }
        if (!state.getBlock().equals(BlockContent.STEAM_ENGINE_BLOCK) || !((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return false;
        }
        this.connectedTanks.add((SteamEngineEntity)this.level.getBlockEntity(new BlockPos((Vec3i)checkPos)));
        return true;
    }

    private SteamEngineEntity reloadTargetTankFromCache() {
        SteamEngineEntity res = this.getBestInputFromConnectedEngine();
        if (res.inputTank.amount == 0L) {
            return null;
        }
        return res;
    }

    private SteamEngineEntity getBestInputFromConnectedEngine() {
        SteamEngineEntity res = this;
        long highest = this.inputTank.amount;
        for (SteamEngineEntity tank : this.connectedTanks) {
            if (tank == null) {
                this.connectedTanks.clear();
                this.connectedTanks.add(this);
                return this;
            }
            long tankAmount = tank.inputTank.amount;
            if (tankAmount <= highest) continue;
            highest = tankAmount;
            res = tank;
        }
        return res;
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
    }

    private float getSteamProcessingSpeed(SingleVariantStorage<FluidVariant> usedTank) {
        float fillPercentage = (float)usedTank.amount / (float)usedTank.getCapacity();
        return fillPercentage * 10.0f;
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.progress == 0) {
            return 1.0f;
        }
        return (float)this.progress / 100.0f;
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(149, 24, 15, 54);
    }

    @Override
    protected void sendNetworkEntry() {
        super.sendNetworkEntry();
        MachineAddonController.BaseAddonData data = this.getBaseAddonData();
        NetworkContent.MACHINE_CHANNEL.serverHandle((BlockEntity)this).send((Record)new NetworkContent.SteamEnginePacket(this.worldPosition, data.speed(), data.efficiency(), this.waterStorage.amount, this.energyProducedTick));
        this.energyProducedTick = 0;
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.STEAM_ENGINE;
    }

    @Override
    public InventorySlotAssignment getSlots() {
        return new InventorySlotAssignment(0, 0, 0, 0);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.STEAM_ENGINE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 0;
    }

    @Override
    public boolean bucketInputAllowed() {
        return false;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.steamEngineData.energyCapacity();
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.steamEngineData.maxEnergyExtraction();
    }

    @Override
    protected Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos pos, Level world) {
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        Direction facing = this.getFacingForAddon();
        Vec3i posA = new Vec3i(0, 0, 1);
        Vec3i posB = new Vec3i(-1, 0, 0);
        Vec3i posC = new Vec3i(1, 0, 0);
        Vec3i posD = new Vec3i(-1, 0, -1);
        Vec3i posE = new Vec3i(1, 0, -1);
        Vec3i posF = new Vec3i(0, 0, -2);
        BlockPos worldPosA = (BlockPos)Geometry.offsetToWorldPosition(facing, posA, (Vec3i)pos);
        BlockPos worldPosB = (BlockPos)Geometry.offsetToWorldPosition(facing, posB, (Vec3i)pos);
        BlockPos worldPosC = (BlockPos)Geometry.offsetToWorldPosition(facing, posC, (Vec3i)pos);
        BlockPos worldPosD = (BlockPos)Geometry.offsetToWorldPosition(facing, posD, (Vec3i)pos);
        BlockPos worldPosE = (BlockPos)Geometry.offsetToWorldPosition(facing, posE, (Vec3i)pos);
        BlockPos worldPosF = (BlockPos)Geometry.offsetToWorldPosition(facing, posF, (Vec3i)pos);
        res.add(new Tuple((Object)worldPosA, (Object)Geometry.fromVector(Geometry.getForward(facing))));
        res.add(new Tuple((Object)worldPosB, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new Tuple((Object)worldPosC, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new Tuple((Object)worldPosD, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new Tuple((Object)worldPosE, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new Tuple((Object)worldPosF, (Object)Geometry.fromVector(Geometry.getBackward(facing))));
        return res;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of();
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 1, -1));
    }

    @Override
    public Storage<FluidVariant> getFluidStorage(Direction direction) {
        return this.exposedSteamEngineStorage;
    }

    @Override
    public boolean showProgress() {
        return false;
    }
}

